/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import java.math.BigInteger;
import java.util.Random;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.IntArray;

public abstract class ECFieldElement
implements ECConstants {
    public abstract BigInteger toBigInteger();

    public abstract int getFieldSize();

    public abstract ECFieldElement add(ECFieldElement var1);

    public abstract ECFieldElement multiply(ECFieldElement var1);

    public abstract ECFieldElement square();

    public abstract ECFieldElement invert();

    public abstract ECFieldElement sqrt();

    public String toString() {
        return this.toBigInteger().toString(2);
    }

    public final class F2m
    extends ECFieldElement {
        private int representation;
        private int m;
        private int k1;
        private int k2;
        private int k3;
        private IntArray x;
        private int t;

        public F2m(int n, int n2, int n3, int n4, BigInteger bigInteger) {
            this.t = n + 31 >> 5;
            this.x = new IntArray(bigInteger, this.t);
            if (n3 == 0 && n4 == 0) {
                this.representation = 2;
            } else {
                if (n3 >= n4) {
                    throw new IllegalArgumentException("k2 must be smaller than k3");
                }
                if (n3 <= 0) {
                    throw new IllegalArgumentException("k2 must be larger than 0");
                }
                this.representation = 3;
            }
            if (bigInteger.signum() < 0) {
                throw new IllegalArgumentException("x value cannot be negative");
            }
            this.m = n;
            this.k1 = n2;
            this.k2 = n3;
            this.k3 = n4;
        }

        private F2m(int n, int n2, int n3, int n4, IntArray intArray) {
            this.t = n + 31 >> 5;
            this.x = intArray;
            this.m = n;
            this.k1 = n2;
            this.k2 = n3;
            this.k3 = n4;
            if (n3 == 0 && n4 == 0) {
                this.representation = 2;
                return;
            }
            this.representation = 3;
        }

        @Override
        public final BigInteger toBigInteger() {
            return this.x.toBigInteger();
        }

        @Override
        public final int getFieldSize() {
            return this.m;
        }

        public static void checkFieldElements(ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            if (!(eCFieldElement instanceof F2m) || !(eCFieldElement2 instanceof F2m)) {
                throw new IllegalArgumentException("Field elements are not both instances of ECFieldElement.F2m");
            }
            eCFieldElement = (F2m)eCFieldElement;
            eCFieldElement2 = (F2m)eCFieldElement2;
            if (((F2m)eCFieldElement).m != ((F2m)eCFieldElement2).m || ((F2m)eCFieldElement).k1 != ((F2m)eCFieldElement2).k1 || ((F2m)eCFieldElement).k2 != ((F2m)eCFieldElement2).k2 || ((F2m)eCFieldElement).k3 != ((F2m)eCFieldElement2).k3) {
                throw new IllegalArgumentException("Field elements are not elements of the same field F2m");
            }
            if (((F2m)eCFieldElement).representation != ((F2m)eCFieldElement2).representation) {
                throw new IllegalArgumentException("One of the field elements are not elements has incorrect representation");
            }
        }

        @Override
        public final ECFieldElement add(ECFieldElement eCFieldElement) {
            IntArray intArray = (IntArray)this.x.clone();
            eCFieldElement = (F2m)eCFieldElement;
            intArray.addShifted(((F2m)eCFieldElement).x, 0);
            return new F2m(this.m, this.k1, this.k2, this.k3, intArray);
        }

        @Override
        public final ECFieldElement multiply(ECFieldElement object) {
            object = (F2m)object;
            object = this.x.multiply(((F2m)object).x, this.m);
            ((IntArray)object).reduce(this.m, new int[]{this.k1, this.k2, this.k3});
            return new F2m(this.m, this.k1, this.k2, this.k3, (IntArray)object);
        }

        @Override
        public final ECFieldElement square() {
            IntArray intArray = this.x.square(this.m);
            intArray.reduce(this.m, new int[]{this.k1, this.k2, this.k3});
            return new F2m(this.m, this.k1, this.k2, this.k3, intArray);
        }

        @Override
        public final ECFieldElement invert() {
            IntArray intArray = (IntArray)this.x.clone();
            IntArray intArray2 = new IntArray(this.t);
            intArray2.setBit(this.m);
            intArray2.setBit(0);
            intArray2.setBit(this.k1);
            if (this.representation == 3) {
                intArray2.setBit(this.k2);
                intArray2.setBit(this.k3);
            }
            IntArray intArray3 = new IntArray(this.t);
            intArray3.setBit(0);
            IntArray intArray4 = new IntArray(this.t);
            while (!intArray.isZero()) {
                int n = intArray.bitLength() - intArray2.bitLength();
                if (n < 0) {
                    IntArray intArray5 = intArray;
                    intArray = intArray2;
                    intArray2 = intArray5;
                    IntArray intArray6 = intArray3;
                    intArray3 = intArray4;
                    intArray4 = intArray6;
                    n = -n;
                }
                int n2 = n >> 5;
                int n3 = n & 0x1F;
                IntArray intArray7 = intArray2.shiftLeft(n3);
                intArray.addShifted(intArray7, n2);
                intArray7 = intArray4.shiftLeft(n3);
                intArray3.addShifted(intArray7, n2);
            }
            return new F2m(this.m, this.k1, this.k2, this.k3, intArray4);
        }

        @Override
        public final ECFieldElement sqrt() {
            throw new RuntimeException("Not implemented");
        }

        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof F2m)) {
                return false;
            }
            object = (F2m)object;
            return this.m == ((F2m)object).m && this.k1 == ((F2m)object).k1 && this.k2 == ((F2m)object).k2 && this.k3 == ((F2m)object).k3 && this.representation == ((F2m)object).representation && this.x.equals(((F2m)object).x);
        }

        public final int hashCode() {
            return this.x.hashCode() ^ this.m ^ this.k1 ^ this.k2 ^ this.k3;
        }
    }

    public final class Fp
    extends ECFieldElement {
        private BigInteger x;
        private BigInteger q;

        public Fp(BigInteger bigInteger, BigInteger bigInteger2) {
            this.x = bigInteger2;
            if (bigInteger2.compareTo(bigInteger) >= 0) {
                throw new IllegalArgumentException("x value too large in field element");
            }
            this.q = bigInteger;
        }

        @Override
        public final BigInteger toBigInteger() {
            return this.x;
        }

        @Override
        public final int getFieldSize() {
            return this.q.bitLength();
        }

        @Override
        public final ECFieldElement add(ECFieldElement eCFieldElement) {
            return new Fp(this.q, this.x.add(eCFieldElement.toBigInteger()).mod(this.q));
        }

        @Override
        public final ECFieldElement multiply(ECFieldElement eCFieldElement) {
            return new Fp(this.q, this.x.multiply(eCFieldElement.toBigInteger()).mod(this.q));
        }

        @Override
        public final ECFieldElement square() {
            return new Fp(this.q, this.x.multiply(this.x).mod(this.q));
        }

        @Override
        public final ECFieldElement invert() {
            return new Fp(this.q, this.x.modInverse(this.q));
        }

        @Override
        public final ECFieldElement sqrt() {
            if (!this.q.testBit(0)) {
                throw new RuntimeException("not done yet");
            }
            if (this.q.testBit(1)) {
                Fp fp = new Fp(this.q, this.x.modPow(this.q.shiftRight(2).add(ECConstants.ONE), this.q));
                if (((ECFieldElement)fp).square().equals(this)) {
                    return fp;
                }
                return null;
            }
            BigInteger bigInteger = this.q.subtract(ECConstants.ONE);
            BigInteger bigInteger2 = bigInteger.shiftRight(1);
            if (!this.x.modPow(bigInteger2, this.q).equals(ECConstants.ONE)) {
                return null;
            }
            BigInteger bigInteger3 = bigInteger.shiftRight(2);
            bigInteger3 = bigInteger3.shiftLeft(1).add(ECConstants.ONE);
            BigInteger bigInteger4 = this.x;
            BigInteger bigInteger5 = bigInteger4.shiftLeft(2).mod(this.q);
            Random random = new Random();
            while (true) {
                BigInteger bigInteger6;
                if ((bigInteger6 = new BigInteger(this.q.bitLength(), random)).compareTo(this.q) >= 0 || !bigInteger6.multiply(bigInteger6).subtract(bigInteger5).modPow(bigInteger2, this.q).equals(bigInteger)) {
                    continue;
                }
                Object object = Fp.lucasSequence(this.q, bigInteger6, bigInteger4, bigInteger3);
                bigInteger6 = object[0];
                if (((BigInteger)(object = object[1])).multiply((BigInteger)object).mod(this.q).equals(bigInteger5)) {
                    if (((BigInteger)object).testBit(0)) {
                        object = ((BigInteger)object).add(this.q);
                    }
                    object = ((BigInteger)object).shiftRight(1);
                    return new Fp(this.q, (BigInteger)object);
                }
                if (!bigInteger6.equals(ECConstants.ONE) && !bigInteger6.equals(bigInteger)) break;
            }
            return null;
        }

        private static BigInteger[] lucasSequence(BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3, BigInteger bigInteger4) {
            int n = bigInteger4.bitLength();
            int n2 = bigInteger4.getLowestSetBit();
            BigInteger bigInteger5 = ECConstants.ONE;
            BigInteger bigInteger6 = ECConstants.TWO;
            BigInteger bigInteger7 = bigInteger2;
            BigInteger bigInteger8 = ECConstants.ONE;
            BigInteger bigInteger9 = ECConstants.ONE;
            --n;
            while (n >= n2 + 1) {
                bigInteger8 = bigInteger8.multiply(bigInteger9).mod(bigInteger);
                if (bigInteger4.testBit(n)) {
                    bigInteger9 = bigInteger8.multiply(bigInteger3).mod(bigInteger);
                    bigInteger5 = bigInteger5.multiply(bigInteger7).mod(bigInteger);
                    bigInteger6 = bigInteger7.multiply(bigInteger6).subtract(bigInteger2.multiply(bigInteger8)).mod(bigInteger);
                    bigInteger7 = bigInteger7.multiply(bigInteger7).subtract(bigInteger9.shiftLeft(1)).mod(bigInteger);
                } else {
                    bigInteger9 = bigInteger8;
                    bigInteger5 = bigInteger5.multiply(bigInteger6).subtract(bigInteger8).mod(bigInteger);
                    bigInteger7 = bigInteger7.multiply(bigInteger6).subtract(bigInteger2.multiply(bigInteger8)).mod(bigInteger);
                    bigInteger6 = bigInteger6.multiply(bigInteger6).subtract(bigInteger8.shiftLeft(1)).mod(bigInteger);
                }
                --n;
            }
            bigInteger8 = bigInteger8.multiply(bigInteger9).mod(bigInteger);
            bigInteger9 = bigInteger8.multiply(bigInteger3).mod(bigInteger);
            bigInteger5 = bigInteger5.multiply(bigInteger6).subtract(bigInteger8).mod(bigInteger);
            bigInteger6 = bigInteger7.multiply(bigInteger6).subtract(bigInteger2.multiply(bigInteger8)).mod(bigInteger);
            bigInteger8 = bigInteger8.multiply(bigInteger9).mod(bigInteger);
            for (n = 1; n <= n2; ++n) {
                bigInteger5 = bigInteger5.multiply(bigInteger6).mod(bigInteger);
                bigInteger6 = bigInteger6.multiply(bigInteger6).subtract(bigInteger8.shiftLeft(1)).mod(bigInteger);
                bigInteger8 = bigInteger8.multiply(bigInteger8).mod(bigInteger);
            }
            return new BigInteger[]{bigInteger5, bigInteger6};
        }

        public final boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Fp)) {
                return false;
            }
            object = (Fp)object;
            return this.q.equals(((Fp)object).q) && this.x.equals(((Fp)object).x);
        }

        public final int hashCode() {
            return this.q.hashCode() ^ this.x.hashCode();
        }
    }
}

