/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cryptopro;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public final class GOST3410ParamSetParameters
extends ASN1Encodable {
    private int keySize = 1024;
    private DERInteger p;
    private DERInteger q;
    private DERInteger a;

    public GOST3410ParamSetParameters(int n, BigInteger bigInteger, BigInteger bigInteger2, BigInteger bigInteger3) {
        this.p = new DERInteger(bigInteger);
        this.q = new DERInteger(bigInteger2);
        this.a = new DERInteger(bigInteger3);
    }

    public final BigInteger getP() {
        return this.p.getPositiveValue();
    }

    public final BigInteger getQ() {
        return this.q.getPositiveValue();
    }

    public final BigInteger getA() {
        return this.a.getPositiveValue();
    }

    @Override
    public final DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(new DERInteger(this.keySize));
        aSN1EncodableVector.add(this.p);
        aSN1EncodableVector.add(this.q);
        aSN1EncodableVector.add(this.a);
        return new DERSequence(aSN1EncodableVector);
    }
}

