/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.cryptopro;

import java.math.BigInteger;
import java.util.Hashtable;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.crypto.params.ECDomainParameters;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;
import org.bouncycastle.math.ec.ECPoint;

public final class ECGOST3410NamedCurves {
    private static Hashtable objIds = new Hashtable();
    private static Hashtable params = new Hashtable();
    private static Hashtable names = new Hashtable();

    public static ECDomainParameters getByOID(DERObjectIdentifier dERObjectIdentifier) {
        return (ECDomainParameters)params.get(dERObjectIdentifier);
    }

    public static ECDomainParameters getByName(String object) {
        if ((object = (DERObjectIdentifier)objIds.get(object)) != null) {
            return (ECDomainParameters)params.get(object);
        }
        return null;
    }

    public static String getName(DERObjectIdentifier dERObjectIdentifier) {
        return (String)names.get(dERObjectIdentifier);
    }

    public static DERObjectIdentifier getOID(String string) {
        return (DERObjectIdentifier)objIds.get(string);
    }

    static {
        Object object = new BigInteger("115792089237316195423570985008687907853269984665640564039457584007913129639319");
        BigInteger bigInteger = new BigInteger("115792089237316195423570985008687907853073762908499243225378155805079068850323");
        ECCurve.Fp fp = new ECCurve.Fp((BigInteger)object, new BigInteger("115792089237316195423570985008687907853269984665640564039457584007913129639316"), new BigInteger("166"));
        object = new ECDomainParameters(fp, new ECPoint.Fp(fp, new ECFieldElement.Fp(fp.getQ(), new BigInteger("1")), new ECFieldElement.Fp(fp.getQ(), new BigInteger("64033881142927202683649881450433473985931760268884941288852745803908878638612"))), bigInteger);
        params.put(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_A, object);
        object = new BigInteger("115792089237316195423570985008687907853269984665640564039457584007913129639319");
        bigInteger = new BigInteger("115792089237316195423570985008687907853073762908499243225378155805079068850323");
        fp = new ECCurve.Fp((BigInteger)object, new BigInteger("115792089237316195423570985008687907853269984665640564039457584007913129639316"), new BigInteger("166"));
        object = new ECDomainParameters(fp, new ECPoint.Fp(fp, new ECFieldElement.Fp(fp.getQ(), new BigInteger("1")), new ECFieldElement.Fp(fp.getQ(), new BigInteger("64033881142927202683649881450433473985931760268884941288852745803908878638612"))), bigInteger);
        params.put(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_XchA, object);
        object = new BigInteger("57896044618658097711785492504343953926634992332820282019728792003956564823193");
        bigInteger = new BigInteger("57896044618658097711785492504343953927102133160255826820068844496087732066703");
        fp = new ECCurve.Fp((BigInteger)object, new BigInteger("57896044618658097711785492504343953926634992332820282019728792003956564823190"), new BigInteger("28091019353058090096996979000309560759124368558014865957655842872397301267595"));
        object = new ECDomainParameters(fp, new ECPoint.Fp(fp, new ECFieldElement.Fp((BigInteger)object, new BigInteger("1")), new ECFieldElement.Fp((BigInteger)object, new BigInteger("28792665814854611296992347458380284135028636778229113005756334730996303888124"))), bigInteger);
        params.put(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_B, object);
        object = new BigInteger("70390085352083305199547718019018437841079516630045180471284346843705633502619");
        bigInteger = new BigInteger("70390085352083305199547718019018437840920882647164081035322601458352298396601");
        fp = new ECCurve.Fp((BigInteger)object, new BigInteger("70390085352083305199547718019018437841079516630045180471284346843705633502616"), new BigInteger("32858"));
        object = new ECDomainParameters(fp, new ECPoint.Fp(fp, new ECFieldElement.Fp((BigInteger)object, new BigInteger("0")), new ECFieldElement.Fp((BigInteger)object, new BigInteger("29818893917731240733471273240314769927240550812383695689146495261604565990247"))), bigInteger);
        params.put(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_XchB, object);
        object = new BigInteger("70390085352083305199547718019018437841079516630045180471284346843705633502619");
        bigInteger = new BigInteger("70390085352083305199547718019018437840920882647164081035322601458352298396601");
        fp = new ECCurve.Fp((BigInteger)object, new BigInteger("70390085352083305199547718019018437841079516630045180471284346843705633502616"), new BigInteger("32858"));
        object = new ECDomainParameters(fp, new ECPoint.Fp(fp, new ECFieldElement.Fp((BigInteger)object, new BigInteger("0")), new ECFieldElement.Fp((BigInteger)object, new BigInteger("29818893917731240733471273240314769927240550812383695689146495261604565990247"))), bigInteger);
        params.put(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_C, object);
        objIds.put("GostR3410-2001-CryptoPro-A", CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_A);
        objIds.put("GostR3410-2001-CryptoPro-B", CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_B);
        objIds.put("GostR3410-2001-CryptoPro-C", CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_C);
        objIds.put("GostR3410-2001-CryptoPro-XchA", CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_XchA);
        objIds.put("GostR3410-2001-CryptoPro-XchB", CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_XchB);
        names.put(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_A, "GostR3410-2001-CryptoPro-A");
        names.put(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_B, "GostR3410-2001-CryptoPro-B");
        names.put(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_C, "GostR3410-2001-CryptoPro-C");
        names.put(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_XchA, "GostR3410-2001-CryptoPro-XchA");
        names.put(CryptoProObjectIdentifiers.gostR3410_2001_CryptoPro_XchB, "GostR3410-2001-CryptoPro-XchB");
    }
}

