/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.DERBoolean;

public final class X509Extension {
    boolean critical;
    ASN1OctetString value;

    public X509Extension(DERBoolean dERBoolean, ASN1OctetString aSN1OctetString) {
        this.critical = dERBoolean.isTrue();
        this.value = aSN1OctetString;
    }

    public X509Extension(boolean bl, ASN1OctetString aSN1OctetString) {
        this.critical = false;
        this.value = aSN1OctetString;
    }

    public final boolean isCritical() {
        return this.critical;
    }

    public final ASN1OctetString getValue() {
        return this.value;
    }

    public final int hashCode() {
        X509Extension x509Extension = this;
        if (x509Extension.critical) {
            x509Extension = this;
            return x509Extension.value.hashCode();
        }
        x509Extension = this;
        return ~x509Extension.value.hashCode();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof X509Extension)) {
            return false;
        }
        Object object2 = object = (X509Extension)object;
        object2 = this;
        if (((X509Extension)object).value.equals(((X509Extension)object2).value)) {
            Object object3 = object;
            object2 = object3;
            object2 = this;
            if (((X509Extension)object3).critical == ((X509Extension)object2).critical) {
                return true;
            }
        }
        return false;
    }

    public static ASN1Object convertValueToObject(X509Extension x509Extension) throws IllegalArgumentException {
        try {
            return ASN1Object.fromByteArray(x509Extension.value.getOctets());
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("can't convert extension: " + iOException);
        }
    }
}

