/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public final class DERUTF8String
extends ASN1Object
implements DERString {
    private String string;

    DERUTF8String(byte[] byArray) {
        int n = 0;
        int n2 = 0;
        while (n < byArray.length) {
            ++n2;
            if ((byArray[n] & 0xF0) == 240) {
                ++n2;
                n += 4;
                continue;
            }
            if ((byArray[n] & 0xE0) == 224) {
                n += 3;
                continue;
            }
            if ((byArray[n] & 0xC0) == 192) {
                n += 2;
                continue;
            }
            ++n;
        }
        char[] cArray = new char[n2];
        n = 0;
        n2 = 0;
        while (n < byArray.length) {
            int n3;
            if ((byArray[n] & 0xF0) == 240) {
                n3 = (byArray[n] & 3) << 18 | (byArray[n + 1] & 0x3F) << 12 | (byArray[n + 2] & 0x3F) << 6 | byArray[n + 3] & 0x3F;
                char c = (char)(0xD800 | (n3 -= 65536) >> 10);
                n3 = (char)(0xDC00 | n3 & 0x3FF);
                cArray[n2++] = c;
                n += 4;
            } else if ((byArray[n] & 0xE0) == 224) {
                n3 = (char)((byArray[n] & 0xF) << 12 | (byArray[n + 1] & 0x3F) << 6 | byArray[n + 2] & 0x3F);
                n += 3;
            } else if ((byArray[n] & 0xD0) == 208) {
                n3 = (char)((byArray[n] & 0x1F) << 6 | byArray[n + 1] & 0x3F);
                n += 2;
            } else if ((byArray[n] & 0xC0) == 192) {
                n3 = (char)((byArray[n] & 0x1F) << 6 | byArray[n + 1] & 0x3F);
                n += 2;
            } else {
                n3 = byArray[n] & 0xFF;
                ++n;
            }
            cArray[n2++] = n3;
        }
        this.string = new String(cArray);
    }

    @Override
    public final String getString() {
        return this.string;
    }

    public final String toString() {
        return this.string;
    }

    @Override
    public final int hashCode() {
        return this.getString().hashCode();
    }

    @Override
    final boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERUTF8String)) {
            return false;
        }
        dERObject = (DERUTF8String)dERObject;
        return this.getString().equals(((DERUTF8String)dERObject).getString());
    }

    @Override
    final void encode(DEROutputStream object) throws IOException {
        DEROutputStream dEROutputStream = object;
        object = this.string;
        object = ((String)object).toCharArray();
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < ((Object)object).length; ++i) {
            Object object2 = object[i];
            if (object2 < 128) {
                byteArrayOutputStream.write((int)object2);
                continue;
            }
            if (object2 < 2048) {
                byteArrayOutputStream.write(0xC0 | object2 >> 6);
                byteArrayOutputStream.write(0x80 | object2 & 0x3F);
                continue;
            }
            if (object2 >= 55296 && object2 <= 57343) {
                if (i + 1 >= ((Object)object).length) {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                Object object3 = object2;
                object2 = object[++i];
                if (object3 > 56319) {
                    throw new IllegalStateException("invalid UTF-16 codepoint");
                }
                object2 = ((object3 & 0x3FF) << 10 | object2 & 0x3FF) + 65536;
                byteArrayOutputStream.write(0xF0 | object2 >> 18);
                byteArrayOutputStream.write(0x80 | object2 >> 12 & 0x3F);
                byteArrayOutputStream.write(0x80 | object2 >> 6 & 0x3F);
                byteArrayOutputStream.write(0x80 | object2 & 0x3F);
                continue;
            }
            byteArrayOutputStream.write(0xE0 | object2 >> 12);
            byteArrayOutputStream.write(0x80 | object2 >> 6 & 0x3F);
            byteArrayOutputStream.write(0x80 | object2 & 0x3F);
        }
        dEROutputStream.writeEncoded(12, byteArrayOutputStream.toByteArray());
    }
}

