/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.math.ec;

import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.math.ec.ECConstants;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECFieldElement;

public abstract class ECPoint {
    ECCurve curve;
    ECFieldElement x;
    ECFieldElement y;
    protected boolean withCompression;
    private static X9IntegerConverter converter = new X9IntegerConverter();

    protected ECPoint(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
        this.curve = eCCurve;
        this.x = eCFieldElement;
        this.y = eCFieldElement2;
    }

    public final ECCurve getCurve() {
        return this.curve;
    }

    public final ECFieldElement getX() {
        return this.x;
    }

    public final ECFieldElement getY() {
        return this.y;
    }

    public final boolean isInfinity() {
        return this.x == null && this.y == null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof ECPoint)) {
            return false;
        }
        object = (ECPoint)object;
        if (this.isInfinity()) {
            return ((ECPoint)object).isInfinity();
        }
        return this.x.equals(((ECPoint)object).x) && this.y.equals(((ECPoint)object).y);
    }

    public int hashCode() {
        if (this.isInfinity()) {
            return 0;
        }
        return this.x.hashCode() ^ this.y.hashCode();
    }

    public abstract byte[] getEncoded();

    public final class F2m
    extends ECPoint {
        public F2m(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            this(eCCurve, eCFieldElement, eCFieldElement2, false);
        }

        public F2m(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
            if (eCFieldElement != null && eCFieldElement2 == null || eCFieldElement == null && eCFieldElement2 != null) {
                throw new IllegalArgumentException("Exactly one of the field elements is null");
            }
            if (eCFieldElement != null) {
                ECFieldElement.F2m.checkFieldElements(this.x, this.y);
                if (eCCurve != null) {
                    eCCurve = this.curve;
                    ECFieldElement.F2m.checkFieldElements(this.x, eCCurve.a);
                }
            }
            this.withCompression = bl;
        }

        @Override
        public final byte[] getEncoded() {
            byte[] byArray;
            if (this.isInfinity()) {
                return new byte[1];
            }
            int n = X9IntegerConverter.getByteLength(this.x);
            byte[] byArray2 = X9IntegerConverter.integerToBytes(this.getX().toBigInteger(), n);
            if (this.withCompression) {
                byte[] byArray3 = new byte[n + 1];
                byArray = byArray3;
                byArray3[0] = 2;
                if (!this.getX().toBigInteger().equals(ECConstants.ZERO) && this.getY().multiply(this.getX().invert()).toBigInteger().testBit(0)) {
                    byArray[0] = 3;
                }
                System.arraycopy(byArray2, 0, byArray, 1, n);
            } else {
                byte[] byArray4 = X9IntegerConverter.integerToBytes(this.getY().toBigInteger(), n);
                byte[] byArray5 = new byte[n + n + 1];
                byArray = byArray5;
                byArray5[0] = 4;
                System.arraycopy(byArray2, 0, byArray, 1, n);
                System.arraycopy(byArray4, 0, byArray, n + 1, n);
            }
            return byArray;
        }
    }

    public final class Fp
    extends ECPoint {
        public Fp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2) {
            this(eCCurve, eCFieldElement, eCFieldElement2, false);
        }

        public Fp(ECCurve eCCurve, ECFieldElement eCFieldElement, ECFieldElement eCFieldElement2, boolean bl) {
            super(eCCurve, eCFieldElement, eCFieldElement2);
            if (eCFieldElement != null && eCFieldElement2 == null || eCFieldElement == null && eCFieldElement2 != null) {
                throw new IllegalArgumentException("Exactly one of the field elements is null");
            }
            this.withCompression = bl;
        }

        @Override
        public final byte[] getEncoded() {
            if (this.isInfinity()) {
                return new byte[1];
            }
            int n = X9IntegerConverter.getByteLength(this.x);
            if (this.withCompression) {
                int n2 = this.getY().toBigInteger().testBit(0) ? 3 : 2;
                byte[] byArray = X9IntegerConverter.integerToBytes(this.getX().toBigInteger(), n);
                byte[] byArray2 = new byte[byArray.length + 1];
                byte[] byArray3 = byArray2;
                byArray2[0] = n2;
                System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
                return byArray3;
            }
            byte[] byArray = X9IntegerConverter.integerToBytes(this.getX().toBigInteger(), n);
            byte[] byArray4 = X9IntegerConverter.integerToBytes(this.getY().toBigInteger(), n);
            byte[] byArray5 = new byte[byArray.length + byArray4.length + 1];
            byte[] byArray6 = byArray5;
            byArray5[0] = 4;
            System.arraycopy(byArray, 0, byArray6, 1, byArray.length);
            System.arraycopy(byArray4, 0, byArray6, byArray.length + 1, byArray4.length);
            return byArray6;
        }
    }
}

