/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.encodings;

import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;

public class PKCS1Encoding
implements AsymmetricBlockCipher {
    private SecureRandom random;
    private AsymmetricBlockCipher engine;
    private boolean forEncryption;
    private boolean forPrivateKey;
    private boolean useStrictLength;

    public PKCS1Encoding(AsymmetricBlockCipher object) {
        this.engine = object;
        object = this;
        object = (String)AccessController.doPrivileged(new PrivilegedAction((PKCS1Encoding)object){

            public final Object run() {
                return System.getProperty("org.bouncycastle.pkcs1.strict");
            }
        });
        this.useStrictLength = object == null || ((String)object).equals("true");
    }

    @Override
    public final void init(boolean bl, CipherParameters cipherParameters) {
        CipherParameters cipherParameters2;
        if (cipherParameters instanceof ParametersWithRandom) {
            cipherParameters2 = (ParametersWithRandom)cipherParameters;
            ParametersWithRandom parametersWithRandom = cipherParameters2;
            this.random = null;
            parametersWithRandom = cipherParameters2;
            cipherParameters2 = null;
        } else {
            this.random = new SecureRandom();
            cipherParameters2 = (AsymmetricKeyParameter)cipherParameters;
        }
        this.engine.init(bl, cipherParameters);
        this.forPrivateKey = ((AsymmetricKeyParameter)cipherParameters2).isPrivate();
        this.forEncryption = bl;
    }

    @Override
    public final int getInputBlockSize() {
        int n = this.engine.getInputBlockSize();
        if (this.forEncryption) {
            return n - 10;
        }
        return n;
    }

    @Override
    public final int getOutputBlockSize() {
        int n = this.engine.getOutputBlockSize();
        if (this.forEncryption) {
            return n;
        }
        return n - 10;
    }

    @Override
    public final byte[] processBlock(byte[] object, int n, int n2) throws InvalidCipherTextException {
        if (this.forEncryption) {
            int n3 = n2;
            n2 = n;
            byte[] byArray = object;
            object = this;
            if (n3 > ((PKCS1Encoding)object).getInputBlockSize()) {
                throw new IllegalArgumentException("input data too large");
            }
            byte[] byArray2 = new byte[((PKCS1Encoding)object).engine.getInputBlockSize()];
            if (((PKCS1Encoding)object).forPrivateKey) {
                byArray2[0] = 1;
                for (int i = 1; i != byArray2.length - n3 - 1; ++i) {
                    byArray2[i] = -1;
                }
            } else {
                ((PKCS1Encoding)object).random.nextBytes(byArray2);
                byArray2[0] = 2;
                for (int i = 1; i != byArray2.length - n3 - 1; ++i) {
                    while (byArray2[i] == 0) {
                        byArray2[i] = (byte)((PKCS1Encoding)object).random.nextInt();
                    }
                }
            }
            byArray2[byArray2.length - n3 - 1] = 0;
            System.arraycopy(byArray, n2, byArray2, byArray2.length - n3, n3);
            return ((PKCS1Encoding)object).engine.processBlock(byArray2, 0, byArray2.length);
        }
        return this.decodeBlock((byte[])object, n, n2);
    }

    private byte[] decodeBlock(byte[] byArray, int n, int n2) throws InvalidCipherTextException {
        byte by;
        if ((byArray = this.engine.processBlock(byArray, n, n2)).length < this.getOutputBlockSize()) {
            throw new InvalidCipherTextException("block truncated");
        }
        n = byArray[0];
        if (n != 1 && n != 2) {
            throw new InvalidCipherTextException("unknown block type");
        }
        if (this.useStrictLength && byArray.length != this.engine.getOutputBlockSize()) {
            throw new InvalidCipherTextException("block incorrect size");
        }
        for (n2 = 1; n2 != byArray.length && (by = byArray[n2]) != 0; ++n2) {
            if (n != 1 || by == -1) continue;
            throw new InvalidCipherTextException("block padding incorrect");
        }
        if (++n2 > byArray.length || n2 < 10) {
            throw new InvalidCipherTextException("no data in block");
        }
        byte[] byArray2 = new byte[byArray.length - n2];
        System.arraycopy(byArray, n2, byArray2, 0, byArray2.length);
        return byArray2;
    }

    private PKCS1Encoding() {
    }

    public static boolean areEqual(byte[] byArray, byte[] byArray2) {
        if (byArray == byArray2) {
            return true;
        }
        if (byArray == null || byArray2 == null) {
            return false;
        }
        if (byArray.length != byArray2.length) {
            return false;
        }
        for (int i = 0; i != byArray.length; ++i) {
            if (byArray[i] == byArray2[i]) continue;
            return false;
        }
        return true;
    }

    public static int hashCode(byte[] byArray) {
        if (byArray == null) {
            return 0;
        }
        int n = byArray.length;
        int n2 = n + 1;
        while (--n >= 0) {
            n2 *= 257;
            n2 ^= byArray[n];
        }
        return n2;
    }
}

