/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DEREncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERTaggedObject;

public final class DERExternal
extends ASN1Object {
    private DERObjectIdentifier directReference;
    private DERInteger indirectReference;
    private ASN1Object dataValueDescriptor;
    private int encoding;
    private DERObject externalContent;

    public DERExternal(ASN1EncodableVector object) {
        int n = 0;
        DERObject dERObject = ((DEREncodableVector)object).get(0).getDERObject();
        if (dERObject instanceof DERObjectIdentifier) {
            this.directReference = (DERObjectIdentifier)dERObject;
            ++n;
            dERObject = ((DEREncodableVector)object).get(1).getDERObject();
        }
        if (dERObject instanceof DERInteger) {
            this.indirectReference = (DERInteger)dERObject;
            dERObject = ((DEREncodableVector)object).get(++n).getDERObject();
        }
        if (!(dERObject instanceof DERTaggedObject)) {
            this.dataValueDescriptor = (ASN1Object)dERObject;
            dERObject = ((DEREncodableVector)object).get(++n).getDERObject();
        }
        if (!(dERObject instanceof DERTaggedObject)) {
            throw new IllegalArgumentException("No tagged object found in vector. Structure doesn't seem to be of type External");
        }
        Object object2 = object = (DERTaggedObject)dERObject;
        int n2 = ((ASN1TaggedObject)object2).tagNo;
        object2 = this;
        if (n2 < 0 || n2 > 2) {
            throw new IllegalArgumentException("invalid encoding value: " + n2);
        }
        ((DERExternal)object2).encoding = n2;
        this.externalContent = ((ASN1TaggedObject)object).getObject();
    }

    @Override
    public final int hashCode() {
        int n = 0;
        if (this.directReference != null) {
            n = this.directReference.hashCode();
        }
        if (this.indirectReference != null) {
            n ^= this.indirectReference.hashCode();
        }
        if (this.dataValueDescriptor != null) {
            n ^= this.dataValueDescriptor.hashCode();
        }
        return n ^= this.externalContent.hashCode();
    }

    @Override
    final void encode(DEROutputStream dEROutputStream) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.directReference != null) {
            byteArrayOutputStream.write(this.directReference.getDEREncoded());
        }
        if (this.indirectReference != null) {
            byteArrayOutputStream.write(this.indirectReference.getDEREncoded());
        }
        if (this.dataValueDescriptor != null) {
            byteArrayOutputStream.write(this.dataValueDescriptor.getDEREncoded());
        }
        DERTaggedObject dERTaggedObject = new DERTaggedObject(this.encoding, this.externalContent);
        byteArrayOutputStream.write(dERTaggedObject.getDEREncoded());
        dEROutputStream.writeEncoded(32, 8, byteArrayOutputStream.toByteArray());
    }

    @Override
    final boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERExternal)) {
            return false;
        }
        if (this == dERObject) {
            return true;
        }
        dERObject = (DERExternal)dERObject;
        if (!(this.directReference == null || ((DERExternal)dERObject).directReference != null && ((DERExternal)dERObject).directReference.equals(this.directReference))) {
            return false;
        }
        if (!(this.indirectReference == null || ((DERExternal)dERObject).indirectReference != null && ((DERExternal)dERObject).indirectReference.equals(this.indirectReference))) {
            return false;
        }
        if (!(this.dataValueDescriptor == null || ((DERExternal)dERObject).dataValueDescriptor != null && ((DERExternal)dERObject).dataValueDescriptor.equals(this.dataValueDescriptor))) {
            return false;
        }
        return this.externalContent.equals(((DERExternal)dERObject).externalContent);
    }

    public final ASN1Object getDataValueDescriptor() {
        return this.dataValueDescriptor;
    }

    public final DERObjectIdentifier getDirectReference() {
        return this.directReference;
    }

    public final int getEncoding() {
        return this.encoding;
    }

    public final DERObject getExternalContent() {
        return this.externalContent;
    }

    public final DERInteger getIndirectReference() {
        return this.indirectReference;
    }
}

