/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1;

import java.io.IOException;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DEROutputStream;
import org.bouncycastle.asn1.DERString;

public final class DERBMPString
extends ASN1Object
implements DERString {
    private String string;

    public DERBMPString(byte[] byArray) {
        char[] cArray = new char[byArray.length / 2];
        for (int i = 0; i != cArray.length; ++i) {
            cArray[i] = (char)(byArray[i * 2] << 8 | byArray[i * 2 + 1] & 0xFF);
        }
        this.string = new String(cArray);
    }

    @Override
    public final String getString() {
        return this.string;
    }

    public final String toString() {
        return this.string;
    }

    @Override
    public final int hashCode() {
        return this.getString().hashCode();
    }

    @Override
    protected final boolean asn1Equals(DERObject dERObject) {
        if (!(dERObject instanceof DERBMPString)) {
            return false;
        }
        dERObject = (DERBMPString)dERObject;
        return this.getString().equals(((DERBMPString)dERObject).getString());
    }

    @Override
    final void encode(DEROutputStream dEROutputStream) throws IOException {
        char[] cArray = this.string.toCharArray();
        byte[] byArray = new byte[cArray.length << 1];
        for (int i = 0; i != cArray.length; ++i) {
            byArray[i * 2] = (byte)(cArray[i] >> 8);
            byArray[i * 2 + 1] = (byte)cArray[i];
        }
        dEROutputStream.writeEncoded(30, byArray);
    }
}

