/*
 * Decompiled with CFR 0.152.
 */
package to_do_o.gui;

import org.eclipse.swt.events.MenuDetectEvent;
import org.eclipse.swt.events.MenuDetectListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Decorations;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Tray;
import org.eclipse.swt.widgets.TrayItem;
import to_do_o.core.settings.SettingsStoreSingleton;
import to_do_o.gui.IconProvider;
import to_do_o.gui.shell.DesktopWidget;
import to_do_o.gui.shell.MainShell;

public class ToDoOTray {
    private Display display;
    private MainShell mainShell;
    private DesktopWidget desktopWidget;
    private TrayItem trayItem;
    private boolean quitToTraySetting;

    public ToDoOTray(Display object, MainShell mainShell, DesktopWidget desktopWidget) {
        this.display = object;
        this.mainShell = mainShell;
        this.desktopWidget = desktopWidget;
        object = this;
        boolean bl = SettingsStoreSingleton.getInstance().getBoolean("ShowTray");
        if (bl) {
            Tray tray = ((ToDoOTray)object).display.getSystemTray();
            if (tray == null || !((ToDoOTray)object).isDisposed()) {
                return;
            }
            ((ToDoOTray)object).trayItem = new TrayItem(tray, 0);
            ((ToDoOTray)object).trayItem.setToolTipText("To-Do-O Tray");
            ((ToDoOTray)object).trayItem.setImage(IconProvider.getIconImage("/icons/small_icon.png"));
            ((ToDoOTray)object).trayItem.addSelectionListener(new SelectionListener((ToDoOTray)object){
                private /* synthetic */ ToDoOTray this$0;
                {
                    this.this$0 = toDoOTray;
                }

                public final void widgetDefaultSelected(SelectionEvent arg0) {
                }

                public final void widgetSelected(SelectionEvent selectionEvent) {
                    if (this.this$0.mainShell.isDisposed()) {
                        this.this$0.mainShell.openShell();
                        if (!this.this$0.quitToTraySetting) {
                            SettingsStoreSingleton.getInstance().set("QuitToTray", String.valueOf(this.this$0.quitToTraySetting));
                        }
                        if (!this.this$0.desktopWidget.isDisposed()) {
                            this.this$0.desktopWidget.setToDoTree(this.this$0.mainShell.getToDoTree());
                            return;
                        }
                    } else {
                        this.this$0.quitToTraySetting = SettingsStoreSingleton.getInstance().getBoolean("QuitToTray");
                        if (!this.this$0.quitToTraySetting) {
                            SettingsStoreSingleton.getInstance().set("QuitToTray", String.valueOf(Boolean.TRUE));
                        }
                        this.this$0.mainShell.closeShell();
                        this.this$0.trayItem.getToolTipText();
                    }
                }
            });
            ((ToDoOTray)object).trayItem.addMenuDetectListener(new MenuDetectListener(){

                public final void menuDetected(MenuDetectEvent shell) {
                    shell = ToDoOTray.this.display.getShells();
                    if (shell == null || ((Shell[])shell).length <= 0) {
                        return;
                    }
                    shell = shell[0];
                    shell = new Menu((Decorations)shell, 8);
                    shell.setVisible(true);
                    MenuItem menuItem = new MenuItem((Menu)shell, 32);
                    menuItem.setText("Show Desktop Widget");
                    menuItem.setSelection(!ToDoOTray.this.desktopWidget.isDisposed());
                    menuItem.addSelectionListener(new SelectionListener(this){
                        private /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public final void widgetDefaultSelected(SelectionEvent arg0) {
                        }

                        public final void widgetSelected(SelectionEvent selectionEvent) {
                            selectionEvent = (MenuItem)selectionEvent.widget;
                            if (selectionEvent.getSelection()) {
                                this.this$1.ToDoOTray.this.desktopWidget.setToDoTree(this.this$1.ToDoOTray.this.mainShell.getToDoTree());
                                this.this$1.ToDoOTray.this.desktopWidget.open();
                                return;
                            }
                            this.this$1.ToDoOTray.this.desktopWidget.close();
                        }
                    });
                    new MenuItem((Menu)shell, 2);
                    menuItem = new MenuItem((Menu)shell, 8);
                    menuItem.setText("Exit");
                    menuItem.addSelectionListener(new SelectionListener(this){
                        private /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public final void widgetDefaultSelected(SelectionEvent arg0) {
                        }

                        public final void widgetSelected(SelectionEvent arg0) {
                            this.this$1.ToDoOTray.this.trayItem.dispose();
                            this.this$1.ToDoOTray.this.desktopWidget.close();
                            this.this$1.ToDoOTray.this.mainShell.closeShell();
                        }
                    });
                }
            });
        }
    }

    public final boolean isDisposed() {
        return this.trayItem == null || this.trayItem.isDisposed();
    }

    public ToDoOTray() {
    }

    public static boolean getBooleanValue(String string) {
        return string != null && string.equalsIgnoreCase(String.valueOf(Boolean.TRUE));
    }
}

