/*
 * Decompiled with CFR 0.152.
 */
package to_do_o.core.settings;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import java.util.Properties;
import to_do_o.core.config.SWTConstants;
import to_do_o.core.settings.SettingsStore;

public final class SWTSettingsStore
extends SettingsStore {
    private File propertiesFile;

    public SWTSettingsStore() {
        this.settings = SWTConstants.getDefaultSettings();
        this.loadSettings();
    }

    @Override
    protected final void loadSettings() {
        Object object = this;
        if (((SWTSettingsStore)object).propertiesFile == null) {
            ((SWTSettingsStore)object).propertiesFile = new File(SWTConstants.PROPERTIES_FILE);
            if (!((SWTSettingsStore)object).propertiesFile.exists()) {
                new File(((SWTSettingsStore)object).propertiesFile.getParent()).mkdirs();
                try {
                    ((SWTSettingsStore)object).propertiesFile.createNewFile();
                }
                catch (IOException iOException) {
                    object = iOException;
                    iOException.printStackTrace();
                }
            }
        }
        try {
            object = new FileInputStream(this.propertiesFile);
            Properties properties = new Properties();
            properties.load((InputStream)object);
            ((FileInputStream)object).close();
            this.settings.putAll((Map)((Object)properties));
            return;
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            return;
        }
    }

    @Override
    public final void storeSettings() {
        try {
            FileOutputStream fileOutputStream = new FileOutputStream(this.propertiesFile);
            Properties properties = new Properties();
            properties.putAll((Map<?, ?>)((Object)this.settings));
            properties.store(fileOutputStream, "To-Do-O Settings");
            fileOutputStream.flush();
            fileOutputStream.close();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }
}

