/*
 * Decompiled with CFR 0.152.
 */
package to_do_o.core.pki;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.net.ssl.X509TrustManager;
import org.eclipse.swt.widgets.Display;
import to_do_o.core.config.SWTConstants;
import to_do_o.core.io.StreamUtil;

public final class ToDoOTrustManager
implements X509TrustManager {
    private KeyStore trustStore;
    private boolean acceptNewCert = false;
    private X509Certificate serverCert;
    private String serverSubjectDN;

    public ToDoOTrustManager() throws KeyStoreException, NoSuchAlgorithmException, CertificateException, FileNotFoundException, IOException {
        ToDoOTrustManager toDoOTrustManager = this;
        File file = new File(SWTConstants.TRUSTSTORE_FILE);
        toDoOTrustManager.trustStore = KeyStore.getInstance("JKS");
        if (file.exists()) {
            toDoOTrustManager.trustStore.load(new FileInputStream(file), "quaerite et invenietis".toCharArray());
        } else {
            toDoOTrustManager.trustStore.load(null);
        }
        System.setProperty((String)"javax.net.ssl.trustStore", (String)SWTConstants.TRUSTSTORE_FILE);
        System.setProperty((String)"javax.net.ssl.trustStorePassword", (String)"quaerite et invenietis");
    }

    @Override
    public final void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        throw new UnsupportedOperationException();
    }

    @Override
    public final void checkServerTrusted(X509Certificate[] object, String string) throws CertificateException {
        if (string == null || !string.equals("RSA")) {
            return;
        }
        this.serverCert = object[0];
        this.serverSubjectDN = this.serverCert.getSubjectDN().getName().substring(3);
        try {
            block4: {
                block5: {
                    block3: {
                        if (!this.trustStore.containsAlias(this.serverSubjectDN)) break block3;
                        object = (X509Certificate)this.trustStore.getCertificate(this.serverSubjectDN);
                        if (!((Certificate)object).equals(this.serverCert)) break block4;
                        ((X509Certificate)object).checkValidity();
                        break block5;
                    }
                    object = this;
                    Display.getDefault().syncExec(new Runnable((ToDoOTrustManager)object){
                        private /* synthetic */ ToDoOTrustManager this$0;
                        {
                            this.this$0 = toDoOTrustManager;
                        }

                        @Override
                        public final void run() {
                            StreamUtil streamUtil = new StreamUtil(Display.getDefault().getActiveShell(), "Connect to:\n" + this.this$0.serverSubjectDN + "?");
                            this.this$0.acceptNewCert = streamUtil.answerYes();
                        }
                    });
                    this.processAcceptanceAnswer();
                }
                return;
            }
            object = this;
            Display.getDefault().syncExec(new Runnable((ToDoOTrustManager)object){
                private /* synthetic */ ToDoOTrustManager this$0;
                {
                    this.this$0 = toDoOTrustManager;
                }

                @Override
                public final void run() {
                    StreamUtil streamUtil = new StreamUtil(Display.getDefault().getActiveShell(), "Attention!\nReceived a new certificate for\nan existing device!\nThis could indicate a possible attack!\n\n" + this.this$0.serverSubjectDN + "\n\n" + "Do you want to trust the new certificate?");
                    this.this$0.acceptNewCert = streamUtil.answerYes();
                }
            });
            this.processAcceptanceAnswer();
        }
        catch (Exception exception) {
            object = exception;
            exception.printStackTrace();
            throw new CertificateException((Throwable)object);
        }
    }

    @Override
    public final X509Certificate[] getAcceptedIssuers() {
        X509Certificate[] x509CertificateArray = new X509Certificate[]{};
        try {
            Enumeration<String> enumeration = this.trustStore.aliases();
            ArrayList<String> arrayList = new ArrayList<String>();
            while (enumeration.hasMoreElements()) {
                String string = (String)enumeration.nextElement();
                if (!string.startsWith("CN=To-Do-O: ")) continue;
                arrayList.add(string);
            }
            if (arrayList.size() > 0) {
                x509CertificateArray = new X509Certificate[arrayList.size()];
                for (int i = 0; i < arrayList.size(); ++i) {
                    x509CertificateArray[i] = (X509Certificate)this.trustStore.getCertificate((String)arrayList.get(i));
                }
            }
        }
        catch (KeyStoreException keyStoreException) {
            KeyStoreException keyStoreException2 = keyStoreException;
            keyStoreException.printStackTrace();
        }
        return x509CertificateArray;
    }

    private void processAcceptanceAnswer() throws CertificateException, KeyStoreException, NoSuchAlgorithmException, FileNotFoundException, IOException {
        if (!this.acceptNewCert) {
            throw new CertificateException("Certificate not accepted by user!");
        }
        this.trustStore.setCertificateEntry(this.serverSubjectDN, this.serverCert);
        this.trustStore.store(new FileOutputStream(SWTConstants.TRUSTSTORE_FILE), "quaerite et invenietis".toCharArray());
        this.acceptNewCert = false;
    }
}

