/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1Set;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERString;
import org.bouncycastle.asn1.DERUniversalString;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.X509NameEntryConverter;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.util.encoders.Hex;

public class X509Name
extends ASN1Encodable {
    private static DERObjectIdentifier C = new DERObjectIdentifier("2.5.4.6");
    private static DERObjectIdentifier O = new DERObjectIdentifier("2.5.4.10");
    private static DERObjectIdentifier OU = new DERObjectIdentifier("2.5.4.11");
    private static DERObjectIdentifier T = new DERObjectIdentifier("2.5.4.12");
    private static DERObjectIdentifier CN = new DERObjectIdentifier("2.5.4.3");
    private static DERObjectIdentifier SN = new DERObjectIdentifier("2.5.4.5");
    private static DERObjectIdentifier STREET = new DERObjectIdentifier("2.5.4.9");
    private static DERObjectIdentifier L = new DERObjectIdentifier("2.5.4.7");
    private static DERObjectIdentifier ST = new DERObjectIdentifier("2.5.4.8");
    private static DERObjectIdentifier SURNAME = new DERObjectIdentifier("2.5.4.4");
    private static DERObjectIdentifier GIVENNAME = new DERObjectIdentifier("2.5.4.42");
    private static DERObjectIdentifier INITIALS = new DERObjectIdentifier("2.5.4.43");
    private static DERObjectIdentifier GENERATION = new DERObjectIdentifier("2.5.4.44");
    private static DERObjectIdentifier UNIQUE_IDENTIFIER = new DERObjectIdentifier("2.5.4.45");
    private static DERObjectIdentifier BUSINESS_CATEGORY = new DERObjectIdentifier("2.5.4.15");
    private static DERObjectIdentifier POSTAL_CODE = new DERObjectIdentifier("2.5.4.17");
    private static DERObjectIdentifier DN_QUALIFIER = new DERObjectIdentifier("2.5.4.46");
    private static DERObjectIdentifier PSEUDONYM = new DERObjectIdentifier("2.5.4.65");
    private static DERObjectIdentifier DATE_OF_BIRTH = new DERObjectIdentifier("1.3.6.1.5.5.7.9.1");
    private static DERObjectIdentifier PLACE_OF_BIRTH = new DERObjectIdentifier("1.3.6.1.5.5.7.9.2");
    private static DERObjectIdentifier GENDER = new DERObjectIdentifier("1.3.6.1.5.5.7.9.3");
    private static DERObjectIdentifier COUNTRY_OF_CITIZENSHIP = new DERObjectIdentifier("1.3.6.1.5.5.7.9.4");
    private static DERObjectIdentifier COUNTRY_OF_RESIDENCE = new DERObjectIdentifier("1.3.6.1.5.5.7.9.5");
    private static DERObjectIdentifier NAME_AT_BIRTH = new DERObjectIdentifier("1.3.36.8.3.14");
    private static DERObjectIdentifier POSTAL_ADDRESS = new DERObjectIdentifier("2.5.4.16");
    private static DERObjectIdentifier TELEPHONE_NUMBER;
    private static DERObjectIdentifier NAME;
    private static DERObjectIdentifier EmailAddress;
    private static DERObjectIdentifier UnstructuredName;
    private static DERObjectIdentifier UnstructuredAddress;
    private static DERObjectIdentifier E;
    private static DERObjectIdentifier DC;
    private static DERObjectIdentifier UID;
    private static boolean DefaultReverse;
    private static Hashtable DefaultSymbols;
    private static Hashtable RFC2253Symbols;
    private static Hashtable RFC1779Symbols;
    private static Hashtable DefaultLookUp;
    private static final Boolean TRUE;
    private static final Boolean FALSE;
    private X509NameEntryConverter converter = null;
    private Vector ordering = new Vector();
    private Vector values = new Vector();
    private Vector added = new Vector();
    private ASN1Sequence seq;
    private boolean isHashCodeCalculated;
    private int hashCodeValue;

    public static X509Name getInstance(Object object) {
        if (object == null || object instanceof X509Name) {
            return (X509Name)object;
        }
        if (object instanceof ASN1Sequence) {
            return new X509Name((ASN1Sequence)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public X509Name(ASN1Sequence object) {
        this.seq = object;
        object = ((ASN1Sequence)object).getObjects();
        while (object.hasMoreElements()) {
            Object object2 = object.nextElement();
            if (object2 != null && !(object2 instanceof ASN1Set)) {
                throw new IllegalArgumentException("unknown object in getInstance: " + object2.getClass().getName());
            }
            object2 = (ASN1Set)object2;
            for (int i = 0; i < ((ASN1Set)object2).size(); ++i) {
                Object object3 = ASN1Sequence.getInstance(((ASN1Set)object2).getObjectAt(i));
                if (((ASN1Sequence)object3).size() != 2) {
                    throw new IllegalArgumentException("badly sized pair");
                }
                this.ordering.addElement(DERObjectIdentifier.getInstance(((ASN1Sequence)object3).getObjectAt(0)));
                object3 = ((ASN1Sequence)object3).getObjectAt(1);
                if (object3 instanceof DERString && !(object3 instanceof DERUniversalString)) {
                    if (((String)(object3 = ((DERString)object3).getString())).length() > 0 && ((String)object3).charAt(0) == '#') {
                        this.values.addElement("\\" + (String)object3);
                    } else {
                        this.values.addElement(object3);
                    }
                } else {
                    this.values.addElement("#" + X509Name.bytesToString(Hex.encode(object3.getDERObject().getDEREncoded())));
                }
                this.added.addElement(i != 0 ? TRUE : FALSE);
            }
        }
    }

    @Override
    public final DERObject toASN1Object() {
        if (this.seq == null) {
            ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
            ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
            DERObjectIdentifier dERObjectIdentifier = null;
            for (int i = 0; i != this.ordering.size(); ++i) {
                ASN1EncodableVector aSN1EncodableVector3 = new ASN1EncodableVector();
                DERObjectIdentifier dERObjectIdentifier2 = (DERObjectIdentifier)this.ordering.elementAt(i);
                aSN1EncodableVector3.add(dERObjectIdentifier2);
                this.values.elementAt(i);
                aSN1EncodableVector3.add(((X509NameEntryConverter)null).getConvertedValue$369106f2());
                if (dERObjectIdentifier == null || ((Boolean)this.added.elementAt(i)).booleanValue()) {
                    aSN1EncodableVector2.add(new DERSequence(aSN1EncodableVector3));
                } else {
                    aSN1EncodableVector.add(new DERSet(aSN1EncodableVector2));
                    aSN1EncodableVector2 = new ASN1EncodableVector();
                    aSN1EncodableVector2.add(new DERSequence(aSN1EncodableVector3));
                }
                dERObjectIdentifier = dERObjectIdentifier2;
            }
            aSN1EncodableVector.add(new DERSet(aSN1EncodableVector2));
            this.seq = new DERSequence(aSN1EncodableVector);
        }
        return this.seq;
    }

    @Override
    public int hashCode() {
        if (this.isHashCodeCalculated) {
            return this.hashCodeValue;
        }
        this.isHashCodeCalculated = true;
        for (int i = 0; i != this.ordering.size(); ++i) {
            String string = (String)this.values.elementAt(i);
            string = this.canonicalize(string);
            string = X509Name.stripInternalSpaces(string);
            this.hashCodeValue ^= string.hashCode();
        }
        return this.hashCodeValue;
    }

    @Override
    public boolean equals(Object object) {
        int n;
        int n2;
        int n3;
        if (object == this) {
            return true;
        }
        if (!(object instanceof X509Name) && !(object instanceof ASN1Sequence)) {
            return false;
        }
        DERObject dERObject = ((DEREncodable)object).getDERObject();
        if (this.getDERObject().equals(dERObject)) {
            return true;
        }
        try {
            object = X509Name.getInstance(object);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return false;
        }
        int n4 = this.ordering.size();
        if (n4 != ((X509Name)object).ordering.size()) {
            return false;
        }
        boolean[] blArray = new boolean[n4];
        if (this.ordering.elementAt(0).equals(((X509Name)object).ordering.elementAt(0))) {
            n3 = 0;
            n2 = n4;
            n = 1;
        } else {
            n3 = n4 - 1;
            n2 = -1;
            n = -1;
        }
        while (n3 != n2) {
            boolean bl = false;
            DERObjectIdentifier dERObjectIdentifier = (DERObjectIdentifier)this.ordering.elementAt(n3);
            String string = (String)this.values.elementAt(n3);
            for (int i = 0; i < n4; ++i) {
                Object object2;
                if (blArray[i] || !dERObjectIdentifier.equals(object2 = (DERObjectIdentifier)((X509Name)object).ordering.elementAt(i))) continue;
                Object object3 = object2 = (String)((X509Name)object).values.elementAt(i);
                String string2 = string;
                object2 = this;
                if (!((string2 = ((X509Name)object2).canonicalize(string2)).equals(object2 = super.canonicalize((String)object3)) || (string2 = X509Name.stripInternalSpaces(string2)).equals(object2 = X509Name.stripInternalSpaces((String)object2)))) continue;
                blArray[i] = true;
                bl = true;
                break;
            }
            if (!bl) {
                return false;
            }
            n3 += n;
        }
        return true;
    }

    private String canonicalize(String string) {
        ASN1Object aSN1Object;
        if ((string = AsymmetricKeyParameter.toLowerCase(string.trim())).length() > 0 && string.charAt(0) == '#' && (aSN1Object = X509Name.decodeObject(string)) instanceof DERString) {
            string = AsymmetricKeyParameter.toLowerCase(((DERString)((Object)aSN1Object)).getString().trim());
        }
        return string;
    }

    private static ASN1Object decodeObject(String string) {
        try {
            return ASN1Object.fromByteArray(Hex.decode(string.substring(1)));
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unknown encoding in name: " + iOException);
        }
    }

    private static String stripInternalSpaces(String string) {
        StringBuffer stringBuffer = new StringBuffer();
        if (string.length() != 0) {
            char c = string.charAt(0);
            stringBuffer.append(c);
            for (int i = 1; i < string.length(); ++i) {
                char c2 = string.charAt(i);
                if (c != ' ' || c2 != ' ') {
                    stringBuffer.append(c2);
                }
                c = c2;
            }
        }
        return stringBuffer.toString();
    }

    private static void appendValue(StringBuffer stringBuffer, Hashtable object, DERObjectIdentifier dERObjectIdentifier, String string) {
        if ((object = (String)((Hashtable)object).get(dERObjectIdentifier)) != null) {
            stringBuffer.append((String)object);
        } else {
            stringBuffer.append(dERObjectIdentifier.getId());
        }
        stringBuffer.append('=');
        int n = stringBuffer.length();
        stringBuffer.append(string);
        int n2 = stringBuffer.length();
        if (string.length() >= 2 && string.charAt(0) == '\\' && string.charAt(1) == '#') {
            n += 2;
        }
        while (n != n2) {
            if (stringBuffer.charAt(n) == ',' || stringBuffer.charAt(n) == '\"' || stringBuffer.charAt(n) == '\\' || stringBuffer.charAt(n) == '+' || stringBuffer.charAt(n) == '=' || stringBuffer.charAt(n) == '<' || stringBuffer.charAt(n) == '>' || stringBuffer.charAt(n) == ';') {
                stringBuffer.insert(n, "\\");
                ++n;
                ++n2;
            }
            ++n;
        }
    }

    private static String bytesToString(byte[] byArray) {
        char[] cArray = new char[byArray.length];
        for (int i = 0; i != cArray.length; ++i) {
            cArray[i] = (char)(byArray[i] & 0xFF);
        }
        return new String(cArray);
    }

    public String toString() {
        int n;
        Hashtable hashtable = DefaultSymbols;
        boolean bl = false;
        X509Name x509Name = this;
        StringBuffer stringBuffer = new StringBuffer();
        Vector<StringBuffer> vector = new Vector<StringBuffer>();
        boolean bl2 = true;
        StringBuffer stringBuffer2 = null;
        for (n = 0; n < x509Name.ordering.size(); ++n) {
            if (((Boolean)x509Name.added.elementAt(n)).booleanValue()) {
                stringBuffer2.append('+');
                X509Name.appendValue(stringBuffer2, hashtable, (DERObjectIdentifier)x509Name.ordering.elementAt(n), (String)x509Name.values.elementAt(n));
                continue;
            }
            stringBuffer2 = new StringBuffer();
            X509Name.appendValue(stringBuffer2, hashtable, (DERObjectIdentifier)x509Name.ordering.elementAt(n), (String)x509Name.values.elementAt(n));
            vector.addElement(stringBuffer2);
        }
        if (bl) {
            for (n = vector.size() - 1; n >= 0; --n) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append(',');
                }
                stringBuffer.append(vector.elementAt(n).toString());
            }
        } else {
            for (n = 0; n < vector.size(); ++n) {
                if (bl2) {
                    bl2 = false;
                } else {
                    stringBuffer.append(',');
                }
                stringBuffer.append(vector.elementAt(n).toString());
            }
        }
        return stringBuffer.toString();
    }

    static {
        new DERObjectIdentifier("2.5.4.54");
        TELEPHONE_NUMBER = X509ObjectIdentifiers.id_at_telephoneNumber;
        NAME = X509ObjectIdentifiers.id_at_name;
        EmailAddress = PKCSObjectIdentifiers.pkcs_9_at_emailAddress;
        UnstructuredName = PKCSObjectIdentifiers.pkcs_9_at_unstructuredName;
        UnstructuredAddress = PKCSObjectIdentifiers.pkcs_9_at_unstructuredAddress;
        E = EmailAddress;
        DC = new DERObjectIdentifier("0.9.2342.19200300.100.1.25");
        UID = new DERObjectIdentifier("0.9.2342.19200300.100.1.1");
        DefaultReverse = false;
        DefaultSymbols = new Hashtable();
        RFC2253Symbols = new Hashtable();
        RFC1779Symbols = new Hashtable();
        DefaultLookUp = new Hashtable();
        TRUE = new Boolean(true);
        FALSE = new Boolean(false);
        DefaultSymbols.put(C, "C");
        DefaultSymbols.put(O, "O");
        DefaultSymbols.put(T, "T");
        DefaultSymbols.put(OU, "OU");
        DefaultSymbols.put(CN, "CN");
        DefaultSymbols.put(L, "L");
        DefaultSymbols.put(ST, "ST");
        DefaultSymbols.put(SN, "SERIALNUMBER");
        DefaultSymbols.put(EmailAddress, "E");
        DefaultSymbols.put(DC, "DC");
        DefaultSymbols.put(UID, "UID");
        DefaultSymbols.put(STREET, "STREET");
        DefaultSymbols.put(SURNAME, "SURNAME");
        DefaultSymbols.put(GIVENNAME, "GIVENNAME");
        DefaultSymbols.put(INITIALS, "INITIALS");
        DefaultSymbols.put(GENERATION, "GENERATION");
        DefaultSymbols.put(UnstructuredAddress, "unstructuredAddress");
        DefaultSymbols.put(UnstructuredName, "unstructuredName");
        DefaultSymbols.put(UNIQUE_IDENTIFIER, "UniqueIdentifier");
        DefaultSymbols.put(DN_QUALIFIER, "DN");
        DefaultSymbols.put(PSEUDONYM, "Pseudonym");
        DefaultSymbols.put(POSTAL_ADDRESS, "PostalAddress");
        DefaultSymbols.put(NAME_AT_BIRTH, "NameAtBirth");
        DefaultSymbols.put(COUNTRY_OF_CITIZENSHIP, "CountryOfCitizenship");
        DefaultSymbols.put(COUNTRY_OF_RESIDENCE, "CountryOfResidence");
        DefaultSymbols.put(GENDER, "Gender");
        DefaultSymbols.put(PLACE_OF_BIRTH, "PlaceOfBirth");
        DefaultSymbols.put(DATE_OF_BIRTH, "DateOfBirth");
        DefaultSymbols.put(POSTAL_CODE, "PostalCode");
        DefaultSymbols.put(BUSINESS_CATEGORY, "BusinessCategory");
        DefaultSymbols.put(TELEPHONE_NUMBER, "TelephoneNumber");
        DefaultSymbols.put(NAME, "Name");
        RFC2253Symbols.put(C, "C");
        RFC2253Symbols.put(O, "O");
        RFC2253Symbols.put(OU, "OU");
        RFC2253Symbols.put(CN, "CN");
        RFC2253Symbols.put(L, "L");
        RFC2253Symbols.put(ST, "ST");
        RFC2253Symbols.put(STREET, "STREET");
        RFC2253Symbols.put(DC, "DC");
        RFC2253Symbols.put(UID, "UID");
        RFC1779Symbols.put(C, "C");
        RFC1779Symbols.put(O, "O");
        RFC1779Symbols.put(OU, "OU");
        RFC1779Symbols.put(CN, "CN");
        RFC1779Symbols.put(L, "L");
        RFC1779Symbols.put(ST, "ST");
        RFC1779Symbols.put(STREET, "STREET");
        DefaultLookUp.put("c", C);
        DefaultLookUp.put("o", O);
        DefaultLookUp.put("t", T);
        DefaultLookUp.put("ou", OU);
        DefaultLookUp.put("cn", CN);
        DefaultLookUp.put("l", L);
        DefaultLookUp.put("st", ST);
        DefaultLookUp.put("sn", SN);
        DefaultLookUp.put("serialnumber", SN);
        DefaultLookUp.put("street", STREET);
        DefaultLookUp.put("emailaddress", E);
        DefaultLookUp.put("dc", DC);
        DefaultLookUp.put("e", E);
        DefaultLookUp.put("uid", UID);
        DefaultLookUp.put("surname", SURNAME);
        DefaultLookUp.put("givenname", GIVENNAME);
        DefaultLookUp.put("initials", INITIALS);
        DefaultLookUp.put("generation", GENERATION);
        DefaultLookUp.put("unstructuredaddress", UnstructuredAddress);
        DefaultLookUp.put("unstructuredname", UnstructuredName);
        DefaultLookUp.put("uniqueidentifier", UNIQUE_IDENTIFIER);
        DefaultLookUp.put("dn", DN_QUALIFIER);
        DefaultLookUp.put("pseudonym", PSEUDONYM);
        DefaultLookUp.put("postaladdress", POSTAL_ADDRESS);
        DefaultLookUp.put("nameofbirth", NAME_AT_BIRTH);
        DefaultLookUp.put("countryofcitizenship", COUNTRY_OF_CITIZENSHIP);
        DefaultLookUp.put("countryofresidence", COUNTRY_OF_RESIDENCE);
        DefaultLookUp.put("gender", GENDER);
        DefaultLookUp.put("placeofbirth", PLACE_OF_BIRTH);
        DefaultLookUp.put("dateofbirth", DATE_OF_BIRTH);
        DefaultLookUp.put("postalcode", POSTAL_CODE);
        DefaultLookUp.put("businesscategory", BUSINESS_CATEGORY);
        DefaultLookUp.put("telephonenumber", TELEPHONE_NUMBER);
        DefaultLookUp.put("name", NAME);
    }
}

