/*
 * Decompiled with CFR 0.152.
 */
package ch.elca.el4j.services.xmlmerge.anttask;

import ch.elca.el4j.services.xmlmerge.AbstractXmlMergeException;
import ch.elca.el4j.services.xmlmerge.ConfigurationException;
import ch.elca.el4j.services.xmlmerge.config.ConfigurableXmlMerge;
import ch.elca.el4j.services.xmlmerge.config.PropertyXPathConfigurer;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.FileSet;

public class XmlMergeTask
extends Task {
    String m_confFilename = null;
    String m_destFilename = null;
    List m_filesets = new ArrayList();

    public void setConf(String confFilename) {
        this.m_confFilename = confFilename;
    }

    public void setDest(String destFilename) {
        this.m_destFilename = destFilename;
    }

    public void addFileSet(FileSet fileset) {
        this.m_filesets.add(fileset);
    }

    public void validate() {
        if (this.m_confFilename == null) {
            throw new BuildException("conf file not set");
        }
        if (this.m_destFilename == null) {
            throw new BuildException("dest file not set");
        }
        if (this.m_filesets.isEmpty()) {
            throw new BuildException("no source fileset specified");
        }
    }

    public void execute() {
        InputStream in;
        ConfigurableXmlMerge xmlMerge;
        FileOutputStream out;
        this.validate();
        ArrayList<FileInputStream> streamsToMerge = new ArrayList<FileInputStream>();
        for (FileSet fs : this.m_filesets) {
            DirectoryScanner ds = fs.getDirectoryScanner(this.getProject());
            String[] includedFiles = ds.getIncludedFiles();
            for (int i = 0; i < includedFiles.length; ++i) {
                try {
                    streamsToMerge.add(new FileInputStream(new File(ds.getBasedir(), includedFiles[i])));
                    continue;
                }
                catch (IOException e) {
                    throw new BuildException((Throwable)e);
                }
            }
        }
        File destFile = new File(this.m_destFilename);
        if (!destFile.isAbsolute()) {
            destFile = new File(this.getProject().getBaseDir(), this.m_destFilename);
        }
        try {
            out = new FileOutputStream(destFile);
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        Properties confProps = new Properties();
        File confFile = new File(this.m_confFilename);
        if (!confFile.isAbsolute()) {
            confFile = new File(this.getProject().getBaseDir(), this.m_confFilename);
        }
        try {
            confProps.load(new FileInputStream(confFile));
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        try {
            xmlMerge = new ConfigurableXmlMerge(new PropertyXPathConfigurer(confProps));
        }
        catch (ConfigurationException e) {
            throw new BuildException((Throwable)e);
        }
        try {
            in = xmlMerge.merge(streamsToMerge.toArray(new InputStream[streamsToMerge.size()]));
        }
        catch (AbstractXmlMergeException e) {
            throw new BuildException((Throwable)e);
        }
        this.writeFromTo(in, out);
        try {
            in.close();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
        try {
            ((OutputStream)out).close();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    private void writeFromTo(InputStream in, OutputStream out) throws BuildException {
        int len = 0;
        byte[] buffer = new byte[1024];
        try {
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
            }
        }
        catch (IOException ioe) {
            throw new BuildException((Throwable)ioe);
        }
    }
}

