/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.pkcs;

import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERSequence;

public final class DHParameter
extends ASN1Encodable {
    private DERInteger p;
    private DERInteger g;
    private DERInteger l;

    public DHParameter(BigInteger bigInteger, BigInteger bigInteger2, int n) {
        this.p = new DERInteger(bigInteger);
        this.g = new DERInteger(bigInteger2);
        if (n != 0) {
            this.l = new DERInteger(n);
            return;
        }
        this.l = null;
    }

    public DHParameter(ASN1Sequence object) {
        object = ((ASN1Sequence)object).getObjects();
        this.p = (DERInteger)object.nextElement();
        this.g = (DERInteger)object.nextElement();
        if (object.hasMoreElements()) {
            this.l = (DERInteger)object.nextElement();
            return;
        }
        this.l = null;
    }

    public final BigInteger getP() {
        return this.p.getPositiveValue();
    }

    public final BigInteger getG() {
        return this.g.getPositiveValue();
    }

    public final BigInteger getL() {
        if (this.l == null) {
            return null;
        }
        return this.l.getPositiveValue();
    }

    @Override
    public final DERObject toASN1Object() {
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.p);
        aSN1EncodableVector.add(this.g);
        if (this.getL() != null) {
            aSN1EncodableVector.add(this.l);
        }
        return new DERSequence(aSN1EncodableVector);
    }
}

