/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.interfaces.ECPublicKey;
import org.bouncycastle.jce.interfaces.GOST3410Params;
import org.bouncycastle.jce.spec.GOST3410ParameterSpec;

public final class JDKGOST3410PublicKey
implements ECPublicKey {
    private BigInteger y;
    private GOST3410Params gost3410Spec;

    JDKGOST3410PublicKey(SubjectPublicKeyInfo object) {
        GOST3410PublicKeyAlgParameters gOST3410PublicKeyAlgParameters = new GOST3410PublicKeyAlgParameters((ASN1Sequence)((SubjectPublicKeyInfo)object).getAlgorithmId().getParameters());
        try {
            object = (DEROctetString)((SubjectPublicKeyInfo)object).getPublicKey();
            byte[] byArray = ((ASN1OctetString)object).getOctets();
            object = byArray;
            byte[] byArray2 = new byte[byArray.length];
            for (int i = 0; i != ((Object)object).length; ++i) {
                byArray2[i] = (byte)object[((Object)object).length - 1 - i];
            }
            this.y = new BigInteger(1, byArray2);
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid info structure in GOST3410 public key");
        }
        this.gost3410Spec = GOST3410ParameterSpec.fromPublicKeyAlg(gOST3410PublicKeyAlgParameters);
    }

    @Override
    public final String getAlgorithm() {
        return "GOST3410";
    }

    @Override
    public final String getFormat() {
        return "X.509";
    }

    @Override
    public final byte[] getEncoded() {
        Object object = this;
        byte[] byArray = ((JDKGOST3410PublicKey)object).y.toByteArray();
        object = byArray;
        byte[] byArray2 = byArray[0] == 0 ? new byte[((Object)object).length - 1] : new byte[((Object)object).length];
        for (int i = 0; i != byArray2.length; ++i) {
            byArray2[i] = (byte)object[((Object)object).length - 1 - i];
        }
        object = this.gost3410Spec instanceof GOST3410ParameterSpec ? (this.gost3410Spec.getEncryptionParamSetOID() != null ? new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94, new GOST3410PublicKeyAlgParameters(new DERObjectIdentifier(this.gost3410Spec.getPublicKeyParamSetOID()), new DERObjectIdentifier(this.gost3410Spec.getDigestParamSetOID()), new DERObjectIdentifier(this.gost3410Spec.getEncryptionParamSetOID())).getDERObject()), new DEROctetString(byArray2)) : new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94, new GOST3410PublicKeyAlgParameters(new DERObjectIdentifier(this.gost3410Spec.getPublicKeyParamSetOID()), new DERObjectIdentifier(this.gost3410Spec.getDigestParamSetOID())).getDERObject()), new DEROctetString(byArray2))) : new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_94), new DEROctetString(byArray2));
        return ((ASN1Encodable)object).getDEREncoded();
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("GOST3410 Public Key").append(string);
        JDKGOST3410PublicKey jDKGOST3410PublicKey = this;
        stringBuffer.append("            y: ").append(jDKGOST3410PublicKey.y.toString(16)).append(string);
        return stringBuffer.toString();
    }

    public final boolean equals(Object object) {
        if (object instanceof JDKGOST3410PublicKey) {
            object = (JDKGOST3410PublicKey)object;
            return this.y.equals(((JDKGOST3410PublicKey)object).y) && this.gost3410Spec.equals(((JDKGOST3410PublicKey)object).gost3410Spec);
        }
        return false;
    }

    public final int hashCode() {
        return this.y.hashCode() ^ this.gost3410Spec.hashCode();
    }
}

