/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DEREncodable;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.X509Name;
import org.bouncycastle.asn1.x509.X509ObjectIdentifiers;

public final class X509CertificateStructure
extends ASN1Encodable
implements PKCSObjectIdentifiers,
X509ObjectIdentifiers {
    private ASN1Sequence seq;
    private TBSCertificateStructure tbsCert;
    private AlgorithmIdentifier sigAlgId;
    private DERBitString sig;

    public X509CertificateStructure(ASN1Sequence aSN1Sequence) {
        this.seq = aSN1Sequence;
        if (aSN1Sequence.size() == 3) {
            TBSCertificateStructure tBSCertificateStructure;
            DEREncodable dEREncodable = aSN1Sequence.getObjectAt(0);
            if (dEREncodable instanceof TBSCertificateStructure) {
                tBSCertificateStructure = (TBSCertificateStructure)dEREncodable;
            } else if (dEREncodable instanceof ASN1Sequence) {
                tBSCertificateStructure = new TBSCertificateStructure((ASN1Sequence)dEREncodable);
            } else {
                throw new IllegalArgumentException("unknown object in factory: " + dEREncodable.getClass().getName());
            }
            this.tbsCert = tBSCertificateStructure;
            this.sigAlgId = AlgorithmIdentifier.getInstance(aSN1Sequence.getObjectAt(1));
            this.sig = DERBitString.getInstance(aSN1Sequence.getObjectAt(2));
            return;
        }
        throw new IllegalArgumentException("sequence wrong size for a certificate");
    }

    public final TBSCertificateStructure getTBSCertificate() {
        return this.tbsCert;
    }

    public final int getVersion() {
        TBSCertificateStructure tBSCertificateStructure = this.tbsCert;
        return tBSCertificateStructure.version.getValue().intValue() + 1;
    }

    public final DERInteger getSerialNumber() {
        TBSCertificateStructure tBSCertificateStructure = this.tbsCert;
        return tBSCertificateStructure.serialNumber;
    }

    public final X509Name getIssuer() {
        TBSCertificateStructure tBSCertificateStructure = this.tbsCert;
        return tBSCertificateStructure.issuer;
    }

    public final Time getStartDate() {
        TBSCertificateStructure tBSCertificateStructure = this.tbsCert;
        return tBSCertificateStructure.startDate;
    }

    public final Time getEndDate() {
        TBSCertificateStructure tBSCertificateStructure = this.tbsCert;
        return tBSCertificateStructure.endDate;
    }

    public final X509Name getSubject() {
        TBSCertificateStructure tBSCertificateStructure = this.tbsCert;
        return tBSCertificateStructure.subject;
    }

    public final SubjectPublicKeyInfo getSubjectPublicKeyInfo() {
        TBSCertificateStructure tBSCertificateStructure = this.tbsCert;
        return tBSCertificateStructure.subjectPublicKeyInfo;
    }

    public final AlgorithmIdentifier getSignatureAlgorithm() {
        return this.sigAlgId;
    }

    public final DERBitString getSignature() {
        return this.sig;
    }

    @Override
    public final DERObject toASN1Object() {
        return this.seq;
    }
}

