/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x509.TBSCertificateStructure;
import org.bouncycastle.asn1.x509.Time;
import org.bouncycastle.asn1.x509.X509Extension;
import org.bouncycastle.asn1.x509.X509Extensions;
import org.bouncycastle.asn1.x509.X509Name;

public final class V3TBSCertificateGenerator {
    private DERTaggedObject version = new DERTaggedObject(0, new DERInteger(2));
    private DERInteger serialNumber;
    private AlgorithmIdentifier signature;
    private X509Name issuer;
    private Time startDate;
    private Time endDate;
    private X509Name subject;
    private SubjectPublicKeyInfo subjectPublicKeyInfo;
    private X509Extensions extensions;
    private boolean altNamePresentAndCritical;

    public final void setSerialNumber(DERInteger dERInteger) {
        this.serialNumber = dERInteger;
    }

    public final void setSignature(AlgorithmIdentifier algorithmIdentifier) {
        this.signature = algorithmIdentifier;
    }

    public final void setIssuer(X509Name x509Name) {
        this.issuer = x509Name;
    }

    public final void setStartDate(Time time) {
        this.startDate = time;
    }

    public final void setEndDate(Time time) {
        this.endDate = time;
    }

    public final void setSubject(X509Name x509Name) {
        this.subject = x509Name;
    }

    public final void setSubjectPublicKeyInfo(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.subjectPublicKeyInfo = subjectPublicKeyInfo;
    }

    public final void setExtensions(X509Extensions object) {
        this.extensions = object;
        if (object != null && (object = ((X509Extensions)object).getExtension(X509Extensions.SubjectAlternativeName)) != null && ((X509Extension)object).critical) {
            this.altNamePresentAndCritical = true;
        }
    }

    public final TBSCertificateStructure generateTBSCertificate() {
        if (this.serialNumber == null || this.signature == null || this.issuer == null || this.startDate == null || this.endDate == null || this.subject == null && !this.altNamePresentAndCritical || this.subjectPublicKeyInfo == null) {
            throw new IllegalStateException("not all mandatory fields set in V3 TBScertificate generator");
        }
        ASN1EncodableVector aSN1EncodableVector = new ASN1EncodableVector();
        aSN1EncodableVector.add(this.version);
        aSN1EncodableVector.add(this.serialNumber);
        aSN1EncodableVector.add(this.signature);
        aSN1EncodableVector.add(this.issuer);
        ASN1EncodableVector aSN1EncodableVector2 = new ASN1EncodableVector();
        aSN1EncodableVector2.add(this.startDate);
        aSN1EncodableVector2.add(this.endDate);
        aSN1EncodableVector.add(new DERSequence(aSN1EncodableVector2));
        if (this.subject != null) {
            aSN1EncodableVector.add(this.subject);
        } else {
            aSN1EncodableVector.add(new DERSequence());
        }
        aSN1EncodableVector.add(this.subjectPublicKeyInfo);
        if (this.extensions != null) {
            aSN1EncodableVector.add(new DERTaggedObject(3, this.extensions));
        }
        return new TBSCertificateStructure(new DERSequence(aSN1EncodableVector));
    }
}

