/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.IOException;
import java.math.BigInteger;
import java.security.interfaces.ECPublicKey;
import java.security.spec.ECParameterSpec;
import java.security.spec.ECPoint;
import java.security.spec.EllipticCurve;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERBitString;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERObjectIdentifier;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.cryptopro.CryptoProObjectIdentifiers;
import org.bouncycastle.asn1.cryptopro.ECGOST3410NamedCurves;
import org.bouncycastle.asn1.cryptopro.GOST3410PublicKeyAlgParameters;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9IntegerConverter;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.jce.provider.ProviderUtil;
import org.bouncycastle.jce.provider.asymmetric.ec.EC5Util;
import org.bouncycastle.jce.provider.asymmetric.ec.ECUtil;
import org.bouncycastle.jce.spec.ECNamedCurveParameterSpec;
import org.bouncycastle.jce.spec.ECNamedCurveSpec;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import to_do_o.gui.tree.ToDoTree;

public final class JCEECPublicKey
implements ECPublicKey,
org.bouncycastle.jce.interfaces.ECPublicKey {
    private String algorithm = "EC";
    private org.bouncycastle.math.ec.ECPoint q;
    private ECParameterSpec ecSpec;
    private GOST3410PublicKeyAlgParameters gostParams;

    JCEECPublicKey(SubjectPublicKeyInfo subjectPublicKeyInfo) {
        this.populateFromPubKeyInfo(subjectPublicKeyInfo);
    }

    private void populateFromPubKeyInfo(SubjectPublicKeyInfo object) {
        Object object2;
        ASN1Encodable aSN1Encodable;
        if (((SubjectPublicKeyInfo)object).getAlgorithmId().getObjectId().equals(CryptoProObjectIdentifiers.gostR3410_2001)) {
            int n;
            Object object3 = ((SubjectPublicKeyInfo)object).getPublicKeyData();
            this.algorithm = "ECGOST3410";
            try {
                object3 = (ASN1OctetString)ASN1Object.fromByteArray(((DERBitString)object3).getBytes());
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException("error recovering public key");
            }
            byte[] byArray = ((ASN1OctetString)object3).getOctets();
            byte[] byArray2 = new byte[32];
            byte[] byArray3 = new byte[32];
            for (n = 0; n != byArray2.length; ++n) {
                byArray2[n] = byArray[31 - n];
            }
            for (n = 0; n != byArray3.length; ++n) {
                byArray3[n] = byArray[63 - n];
            }
            this.gostParams = new GOST3410PublicKeyAlgParameters((ASN1Sequence)((SubjectPublicKeyInfo)object).getAlgorithmId().getParameters());
            ECNamedCurveParameterSpec eCNamedCurveParameterSpec = ToDoTree.getParameterSpec((String)ECGOST3410NamedCurves.getName(this.gostParams.getPublicKeyParamSet()));
            object = eCNamedCurveParameterSpec.getCurve();
            object3 = EC5Util.convertCurve$3bd7a276((ECCurve)object);
            this.q = ((ECCurve)object).createPoint(new BigInteger(1, byArray2), new BigInteger(1, byArray3), false);
            this.ecSpec = new ECNamedCurveSpec(ECGOST3410NamedCurves.getName(this.gostParams.getPublicKeyParamSet()), (EllipticCurve)object3, new ECPoint(eCNamedCurveParameterSpec.getG().getX().toBigInteger(), eCNamedCurveParameterSpec.getG().getY().toBigInteger()), eCNamedCurveParameterSpec.getN(), eCNamedCurveParameterSpec.getH());
            return;
        }
        Object object4 = new X962Parameters((DERObject)((SubjectPublicKeyInfo)object).getAlgorithmId().getParameters());
        if (((X962Parameters)object4).isNamedCurve()) {
            aSN1Encodable = (DERObjectIdentifier)((X962Parameters)object4).getParameters();
            object2 = ECUtil.getNamedCurveByOid((DERObjectIdentifier)aSN1Encodable);
            object4 = ((X9ECParameters)object2).getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve$3bd7a276((ECCurve)object4);
            this.ecSpec = new ECNamedCurveSpec(ECUtil.getCurveName((DERObjectIdentifier)aSN1Encodable), ellipticCurve, new ECPoint(((X9ECParameters)object2).getG().getX().toBigInteger(), ((X9ECParameters)object2).getG().getY().toBigInteger()), ((X9ECParameters)object2).getN(), ((X9ECParameters)object2).getH());
        } else if (((X962Parameters)object4).isImplicitlyCA()) {
            this.ecSpec = null;
            object4 = ProviderUtil.getEcImplicitlyCa().getCurve();
        } else {
            aSN1Encodable = new X9ECParameters((ASN1Sequence)((X962Parameters)object4).getParameters());
            object4 = ((X9ECParameters)aSN1Encodable).getCurve();
            EllipticCurve ellipticCurve = EC5Util.convertCurve$3bd7a276((ECCurve)object4);
            this.ecSpec = new ECParameterSpec(ellipticCurve, new ECPoint(((X9ECParameters)aSN1Encodable).getG().getX().toBigInteger(), ((X9ECParameters)aSN1Encodable).getG().getY().toBigInteger()), ((X9ECParameters)aSN1Encodable).getN(), ((X9ECParameters)aSN1Encodable).getH().intValue());
        }
        aSN1Encodable = ((SubjectPublicKeyInfo)object).getPublicKeyData();
        object2 = ((DERBitString)aSN1Encodable).getBytes();
        ASN1OctetString aSN1OctetString = new DEROctetString((byte[])object2);
        if (object2[0] == 4 && object2[1] == ((Object)object2).length - 2 && (object2[2] == 2 || object2[2] == 3)) {
            new X9IntegerConverter();
            object = object4;
            int n = (((ECCurve)object).getFieldSize() + 7) / 8;
            if (n >= ((Object)object2).length - 3) {
                try {
                    aSN1OctetString = (ASN1OctetString)ASN1Object.fromByteArray((byte[])object2);
                }
                catch (IOException iOException) {
                    throw new IllegalArgumentException("error recovering public key");
                }
            }
        }
        object = new X9ECPoint((ECCurve)object4, aSN1OctetString);
        this.q = ((X9ECPoint)object).getPoint();
    }

    @Override
    public final String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    public final String getFormat() {
        return "X.509";
    }

    @Override
    public final byte[] getEncoded() {
        ASN1Encodable aSN1Encodable;
        if (this.algorithm.equals("ECGOST3410")) {
            Object object;
            Object object2;
            if (this.gostParams != null) {
                aSN1Encodable = this.gostParams;
            } else if (this.ecSpec instanceof ECNamedCurveSpec) {
                aSN1Encodable = new GOST3410PublicKeyAlgParameters(ECGOST3410NamedCurves.getOID(((ECNamedCurveSpec)this.ecSpec).getName()), CryptoProObjectIdentifiers.gostR3411_94_CryptoProParamSet);
            } else {
                object2 = EC5Util.convertCurve(this.ecSpec.getCurve());
                object = new X9ECParameters((ECCurve)object2, EC5Util.convertPoint((ECCurve)object2, this.ecSpec.getGenerator(), false), this.ecSpec.getOrder(), BigInteger.valueOf(this.ecSpec.getCofactor()), this.ecSpec.getCurve().getSeed());
                aSN1Encodable = new X962Parameters((X9ECParameters)object);
            }
            object2 = this.q.getX().toBigInteger();
            object = this.q.getY().toBigInteger();
            byte[] byArray = new byte[64];
            JCEECPublicKey.extractBytes(byArray, 0, (BigInteger)object2);
            JCEECPublicKey.extractBytes(byArray, 32, (BigInteger)object);
            aSN1Encodable = new SubjectPublicKeyInfo(new AlgorithmIdentifier(CryptoProObjectIdentifiers.gostR3410_2001, aSN1Encodable.getDERObject()), new DEROctetString(byArray));
        } else {
            ASN1Encodable aSN1Encodable2;
            Object object;
            if (this.ecSpec instanceof ECNamedCurveSpec) {
                object = ECUtil.getNamedCurveOid(((ECNamedCurveSpec)this.ecSpec).getName());
                aSN1Encodable = new X962Parameters((DERObjectIdentifier)object);
            } else if (this.ecSpec == null) {
                aSN1Encodable = new X962Parameters(DERNull.INSTANCE);
            } else {
                object = EC5Util.convertCurve(this.ecSpec.getCurve());
                aSN1Encodable2 = new X9ECParameters((ECCurve)object, EC5Util.convertPoint((ECCurve)object, this.ecSpec.getGenerator(), false), this.ecSpec.getOrder(), BigInteger.valueOf(this.ecSpec.getCofactor()), this.ecSpec.getCurve().getSeed());
                aSN1Encodable = new X962Parameters((X9ECParameters)aSN1Encodable2);
            }
            object = this;
            object = ((JCEECPublicKey)object).q.getCurve();
            aSN1Encodable2 = (ASN1OctetString)new X9ECPoint(((ECCurve)object).createPoint(this.getQ().getX().toBigInteger(), this.getQ().getY().toBigInteger(), false)).getDERObject();
            aSN1Encodable = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, aSN1Encodable.getDERObject()), ((ASN1OctetString)aSN1Encodable2).getOctets());
        }
        return aSN1Encodable.getDEREncoded();
    }

    private static void extractBytes(byte[] byArray, int n, BigInteger object) {
        byte[] byArray2 = ((BigInteger)object).toByteArray();
        object = byArray2;
        if (byArray2.length < 32) {
            byte[] byArray3 = new byte[32];
            System.arraycopy(object, 0, byArray3, byArray3.length - ((Object)object).length, ((Object)object).length);
        }
        for (int i = 0; i != 32; ++i) {
            byArray[n + i] = (byte)object[((Object)object).length - 1 - i];
        }
    }

    @Override
    public final ECParameterSpec getParams() {
        return this.ecSpec;
    }

    @Override
    public final ECPoint getW() {
        return new ECPoint(this.q.getX().toBigInteger(), this.q.getY().toBigInteger());
    }

    private org.bouncycastle.math.ec.ECPoint getQ() {
        if (this.ecSpec == null) {
            if (this.q instanceof ECPoint.Fp) {
                return new ECPoint.Fp(null, this.q.getX(), this.q.getY());
            }
            return new ECPoint.F2m(null, this.q.getX(), this.q.getY());
        }
        return this.q;
    }

    private org.bouncycastle.jce.spec.ECParameterSpec engineGetSpec() {
        if (this.ecSpec != null) {
            return EC5Util.convertSpec(this.ecSpec, false);
        }
        return ProviderUtil.getEcImplicitlyCa();
    }

    public final String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = System.getProperty("line.separator");
        stringBuffer.append("EC Public Key").append(string);
        stringBuffer.append("            X: ").append(this.q.getX().toBigInteger().toString(16)).append(string);
        stringBuffer.append("            Y: ").append(this.q.getY().toBigInteger().toString(16)).append(string);
        return stringBuffer.toString();
    }

    public final boolean equals(Object object) {
        if (!(object instanceof JCEECPublicKey)) {
            return false;
        }
        object = (JCEECPublicKey)object;
        JCEECPublicKey jCEECPublicKey = this;
        Object object2 = jCEECPublicKey;
        object2 = object;
        return jCEECPublicKey.q.equals(((JCEECPublicKey)object2).q) && this.engineGetSpec().equals(super.engineGetSpec());
    }

    public final int hashCode() {
        JCEECPublicKey jCEECPublicKey = this;
        return jCEECPublicKey.q.hashCode() ^ this.engineGetSpec().hashCode();
    }
}

