/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.x509;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.SimpleTimeZone;
import org.bouncycastle.asn1.ASN1Choice;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.DERGeneralizedTime;
import org.bouncycastle.asn1.DERObject;
import org.bouncycastle.asn1.DERUTCTime;

public final class Time
extends ASN1Encodable
implements ASN1Choice {
    private DERObject time;

    private Time(DERObject dERObject) {
        if (!(dERObject instanceof DERUTCTime) && !(dERObject instanceof DERGeneralizedTime)) {
            throw new IllegalArgumentException("unknown object passed to Time");
        }
        this.time = dERObject;
    }

    public Time(Date object) {
        SimpleTimeZone simpleTimeZone = new SimpleTimeZone(0, "Z");
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmss");
        simpleDateFormat.setTimeZone(simpleTimeZone);
        object = simpleDateFormat.format((Date)object) + "Z";
        int n = Integer.parseInt(((String)object).substring(0, 4));
        if (n < 1950 || n > 2049) {
            this.time = new DERGeneralizedTime((String)object);
            return;
        }
        this.time = new DERUTCTime(((String)object).substring(2));
    }

    public static Time getInstance(Object object) {
        if (object instanceof Time) {
            return (Time)object;
        }
        if (object instanceof DERUTCTime) {
            return new Time((DERUTCTime)object);
        }
        if (object instanceof DERGeneralizedTime) {
            return new Time((DERGeneralizedTime)object);
        }
        throw new IllegalArgumentException("unknown object in factory: " + object.getClass().getName());
    }

    public final String getTime() {
        if (this.time instanceof DERUTCTime) {
            return ((DERUTCTime)this.time).getAdjustedTime();
        }
        return ((DERGeneralizedTime)this.time).getTime();
    }

    public final Date getDate() {
        try {
            if (this.time instanceof DERUTCTime) {
                DERUTCTime dERUTCTime = (DERUTCTime)this.time;
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyyMMddHHmmssz");
                simpleDateFormat.setTimeZone(new SimpleTimeZone(0, "Z"));
                return simpleDateFormat.parse(dERUTCTime.getAdjustedTime());
            }
            return ((DERGeneralizedTime)this.time).getDate();
        }
        catch (ParseException parseException) {
            throw new IllegalStateException("invalid date string: " + parseException.getMessage());
        }
    }

    @Override
    public final DERObject toASN1Object() {
        return this.time;
    }

    public final String toString() {
        return this.getTime();
    }
}

