/*
 * Decompiled with CFR 0.152.
 */
package to_do_o.core.settings;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import to_do_o.core.Constants;
import to_do_o.gui.ToDoOTray;

public class SettingsStore {
    protected Hashtable settings = Constants.getDefaultSettings();
    private RecordStore recStore;

    public SettingsStore() {
        this.loadSettings();
    }

    public final String get(String key) {
        return (String)this.settings.get(key);
    }

    public final boolean getBoolean(String key) {
        return ToDoOTray.getBooleanValue((String)this.settings.get(key));
    }

    public final int getInt(String key) {
        return Integer.parseInt((String)this.settings.get(key));
    }

    protected void loadSettings() {
        try {
            this.recStore = RecordStore.openRecordStore((String)"To-Do_Settings", (boolean)true);
            RecordEnumeration recordEnumeration = this.recStore.enumerateRecords(null, null, false);
            while (recordEnumeration.hasNextElement()) {
                Object object = recordEnumeration.nextRecord();
                DataInputStream dataInputStream = new DataInputStream(new ByteArrayInputStream((byte[])object));
                object = dataInputStream;
                String string = dataInputStream.readUTF();
                object = ((DataInputStream)object).readUTF();
                this.set(string, (String)object);
            }
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }

    public final void set(String string, String string2) {
        if (this.settings.containsKey(string)) {
            this.settings.remove(string);
        }
        this.settings.put(string, string2);
    }

    public void storeSettings() {
        try {
            this.recStore.closeRecordStore();
            RecordStore.deleteRecordStore((String)"To-Do_Settings");
            this.recStore = RecordStore.openRecordStore((String)"To-Do_Settings", (boolean)true);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            Enumeration enumeration = this.settings.keys();
            while (enumeration.hasMoreElements()) {
                byteArrayOutputStream.reset();
                String string = (String)enumeration.nextElement();
                dataOutputStream.writeUTF(string);
                dataOutputStream.writeUTF((String)this.settings.get(string));
                dataOutputStream.flush();
                this.recStore.addRecord(byteArrayOutputStream.toByteArray(), 0, byteArrayOutputStream.toByteArray().length);
            }
            this.recStore.closeRecordStore();
            byteArrayOutputStream.close();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            exception.printStackTrace();
            return;
        }
    }
}

