/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.jce.provider;

import java.io.IOException;
import java.math.BigInteger;
import javax.crypto.interfaces.DHPublicKey;
import javax.crypto.spec.DHParameterSpec;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.DERInteger;
import org.bouncycastle.asn1.oiw.ElGamalParameter;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.jce.interfaces.ElGamalPublicKey;
import org.bouncycastle.jce.spec.ElGamalParameterSpec;

public final class JCEElGamalPublicKey
implements DHPublicKey,
ElGamalPublicKey {
    private BigInteger y;
    private ElGamalParameterSpec elSpec;

    JCEElGamalPublicKey(SubjectPublicKeyInfo aSN1Encodable) {
        ElGamalParameter elGamalParameter = new ElGamalParameter((ASN1Sequence)((SubjectPublicKeyInfo)aSN1Encodable).getAlgorithmId().getParameters());
        try {
            aSN1Encodable = (DERInteger)((SubjectPublicKeyInfo)aSN1Encodable).getPublicKey();
        }
        catch (IOException iOException) {
            throw new IllegalArgumentException("invalid info structure in DSA public key");
        }
        this.y = ((DERInteger)aSN1Encodable).getValue();
        this.elSpec = new ElGamalParameterSpec(elGamalParameter.getP(), elGamalParameter.getG());
    }

    @Override
    public final String getAlgorithm() {
        return "ElGamal";
    }

    @Override
    public final String getFormat() {
        return "X.509";
    }

    @Override
    public final byte[] getEncoded() {
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(OIWObjectIdentifiers.elGamalAlgorithm, new ElGamalParameter(this.elSpec.getP(), this.elSpec.getG()).getDERObject()), new DERInteger(this.y));
        return subjectPublicKeyInfo.getDEREncoded();
    }

    @Override
    public final DHParameterSpec getParams() {
        return new DHParameterSpec(this.elSpec.getP(), this.elSpec.getG());
    }

    @Override
    public final BigInteger getY() {
        return this.y;
    }
}

