/*
    TipQalc - A tip, tax and total calculator for touchscreen.
    Copyright (C) 2010 Ianaré Sévi.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#include "numberpad.h"
#include "ui_numberpad.h"

NumberPad::NumberPad(QWidget *parent) :
    QWidget(parent),
    ui(new Ui::NumberPad)
{
    ui->setupUi(this);
}

NumberPad::~NumberPad()
{
    delete ui;
}

void NumberPad::changeEvent(QEvent *e)
{
    QWidget::changeEvent(e);
    switch (e->type()) {
    case QEvent::LanguageChange:
        ui->retranslateUi(this);
        break;
    default:
        break;
    }
}

void NumberPad::numberClicked(QString value)
{
    emit numberClickedSignal(value);
}

void NumberPad::on_periodButton_clicked()
{
    emit periodClickedSignal();
}

void NumberPad::on_number00Button_clicked()
{
    numberClicked("00");
}

void NumberPad::on_number0Button_clicked()
{
    numberClicked("0");
}

void NumberPad::on_number1Button_clicked()
{
    numberClicked("1");
}

void NumberPad::on_number2Button_clicked()
{
    numberClicked("2");
}

void NumberPad::on_number3Button_clicked()
{
    numberClicked("3");
}

void NumberPad::on_number4Button_clicked()
{
    numberClicked("4");
}

void NumberPad::on_number5Button_clicked()
{
    numberClicked("5");
}

void NumberPad::on_number6Button_clicked()
{
    numberClicked("6");
}

void NumberPad::on_number7Button_clicked()
{
    numberClicked("7");
}

void NumberPad::on_number8Button_clicked()
{
    numberClicked("8");
}

void NumberPad::on_number9Button_clicked()
{
    numberClicked("9");
}

void NumberPad::on_deleteButton_clicked()
{
    emit deleteClickedSignal();
}

void NumberPad::on_clearButton_clicked()
{
    emit clearClickedSignal();
}
