/*
    TipQalc - A tip, tax and total calculator for touchscreen.
    Copyright (C) 2010 Ianaré Sévi.

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef NUMBERPAD_H
#define NUMBERPAD_H

#include <QWidget>

namespace Ui {
    class NumberPad;
}

class NumberPad : public QWidget {
    Q_OBJECT
public:
    NumberPad(QWidget *parent = 0);
    ~NumberPad();

protected:
    void changeEvent(QEvent *e);

private:
    Ui::NumberPad *ui;

    void numberClicked(QString number);

private slots:
    void on_clearButton_clicked();
    void on_deleteButton_clicked();
    void on_periodButton_clicked();
    void on_number9Button_clicked();
    void on_number8Button_clicked();
    void on_number7Button_clicked();
    void on_number6Button_clicked();
    void on_number5Button_clicked();
    void on_number4Button_clicked();
    void on_number3Button_clicked();
    void on_number2Button_clicked();
    void on_number1Button_clicked();
    void on_number0Button_clicked();
    void on_number00Button_clicked();

public slots:

signals:
    void numberClickedSignal(QString value);
    void periodClickedSignal();
    void deleteClickedSignal();
    void clearClickedSignal();
};

#endif // NUMBERPAD_H
