#ifndef TINYCFG_H
#define TINYCFG_H

#include <QFile>
#include <QTextStream>
#include <QList>
#include <QObject>
#include "tinyshare.h"
#include "tinysmbcfg.h"

class TinyCfg : public QObject {
    Q_OBJECT
public:
    TinyCfg();
    ~TinyCfg();

    void set_cfg(TinySmbCfg config);
    TinySmbCfg get_cfg();

    void add_share(TinyShare share);
    void rm_share(int idx);
    TinyShare get_share(int idx);

    void add_shares(QList<TinyShare> shares);
    void rm_all_shares();
    QList<TinyShare> get_all_shares();

    void read_cfg_file();
    void write_cfg_file();

    void set_tinycfgfile(QString path);
    QString get_tinycfgfile();

    void debug_out();
    QString state;



private:
    TinySmbCfg cfg;
    QList<TinyShare> sharelist;
    QString tinycfgfile;
};


#endif // TINYCFG_H
