#ifndef SETTINGS_H
#define SETTINGS_H

#include <QDialog>
#include "wlanadr.h"
#include "tinysmbcfg.h"

namespace Ui {
    class Settings;
}

class Settings : public QDialog
{
    Q_OBJECT

public:
    explicit Settings(QWidget *parent = 0);
    ~Settings();

    TinySmbCfg get_cfg();
    void set_cfg(TinySmbCfg c);
    void labelrefresh();

private:
    Ui::Settings *ui;
    WlanIp adr;
    TinySmbCfg cfg;

private slots:
    void on_pushButton_save_clicked();
    void on_lineEdit_snm_cursorPositionChanged(int , int );
    void on_lineEdit_ip_editingFinished();
    void on_lineEdit_wrkgr_editingFinished();
    void on_lineEdit_hname_editingFinished();
    void on_pushButton_wlan_clicked();
};

#endif // SETTINGS_H
