//  Copyright © 2010    Karl Wintermmann
//
//  TinySmbGui is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use TinySmbGui must be published. Commercial users
//  must published their code too.


#include "newshare.h"
#include "ui_newshare.h"
#include <QFileDialog>
#include <QDebug>

newshare::newshare(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::newshare)
{
    ui->setupUi(this);
    check_share();
    share.set_all_users("yes");
    share.set_access("vo");
    connect(ui->pushButton_2,SIGNAL(clicked()),this,SLOT(accept()));
}

newshare::~newshare()
{
    delete ui;
}
void newshare::check_share(){
    if( (share.get_share_name()!="") && (share.get_path()!="") && (share.get_all_users()!="") && (share.get_access()!="") ){
        ui->pushButton_2->setEnabled(true);
    }
    else ui->pushButton_2->setEnabled(false);
}

TinyShare newshare::get_share(){
    return share;
}
void newshare::set_button_name(){
    ui->pushButton_2->setText("Save");
}

void newshare::set_share(TinyShare s){
    share=s;
    QString tmp=share.get_share_name();
    tmp.remove('[');
    tmp.remove(']');
    ui->lineEdit->setText(tmp);
    ui->pushButton->setText(share.get_path());
    if(share.get_access()=="vo") ui->comboBox->setCurrentIndex(0);
    if(share.get_access()=="ro") ui->comboBox->setCurrentIndex(1);
    if(share.get_access()=="rw") ui->comboBox->setCurrentIndex(2);
    check_share();

}

void newshare::on_pushButton_clicked()
{
    QString dir = QFileDialog::getExistingDirectory(this,"Choose a Directory","/home/user/MyDocs/");
    ui->pushButton->setText(dir);
    share.set_path(dir);
    check_share();

//    qDebug()<<share.get_share_name();
//    qDebug()<<share.get_all_users();
//    qDebug()<<share.get_path();
//    qDebug()<<share.get_access();


}

void newshare::on_lineEdit_editingFinished()
{
    QRegExp rx("\\w+");
    if(rx.exactMatch(ui->lineEdit->text())) {
        share.set_share_name("["+ui->lineEdit->text()+"]");
    }
    else ui->lineEdit->setText(QString(share.get_share_name()).remove('[').remove(']'));
    check_share();
}


void newshare::on_comboBox_activated(int index)
{
    if(index==0) share.set_access("vo");
    if(index==1) share.set_access("ro");
    if(index==2) share.set_access("rw");
    check_share();
}

//void newshare::on_lineEdit_returnPressed()
//{
//    QRegExp rx("\\w+");
//    if(rx.exactMatch(ui->lineEdit->text())) {
//        share.set_share_name("["+ui->lineEdit->text()+"]");
//    }
//    check_share();
//    qDebug()<<ui->lineEdit->text();
//}
