//  Copyright © 2010    Karl Wintermmann
//
//  TinySmbGui is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use TinySmbGui must be published. Commercial users
//  must published their code too.


#include "dialog.h"
#include "ui_dialog.h"
#include <QDebug>

Dialog::Dialog(QWidget *parent) :
    QDialog(parent),
    ui(new Ui::Dialog)
{
    ui->setupUi(this);
    nshare=new newshare;
    eshare=new newshare;
    eshare->setWindowTitle("Edit Share");
    eshare->set_button_name();
    current_item=new QListWidgetItem;
    ui->pushButton_edit->setEnabled(false);
    ui->pushButton_rm->setEnabled(false);
}


Dialog::~Dialog()
{
    delete ui;
    delete nshare;
    delete current_item;
}


void Dialog::setshares(QList<TinyShare> s){
    shares=s;
}


QList<TinyShare> Dialog::getshares(){
    return shares;
}


void Dialog::upd_label(){
    ui->listWidget->clear();
    for(int i=0;i<shares.size();i++){
        ui->listWidget->insertItem(i,shares[i].get_share_name());
    }
    ui->pushButton_edit->setEnabled(false);
    ui->pushButton_rm->setEnabled(false);
}


void Dialog::on_pushButton_new_pressed()
{
    if(nshare->exec()==1) {
        if(!shares.contains(nshare->get_share())) shares.append(nshare->get_share());
    }
    upd_label();
}

void Dialog::on_pushButton_save_clicked()
{
    this->accept();
}

void Dialog::on_pushButton_rm_clicked()
{
    int c_index=ui->listWidget->currentIndex().row();
    if( (c_index>=0) && (c_index<shares.size()) ){
        shares.removeAt(c_index);
    }
    upd_label();

}

void Dialog::on_listWidget_itemActivated(QListWidgetItem* item)
{
    ui->pushButton_edit->setEnabled(true);
    ui->pushButton_rm->setEnabled(true);
    *current_item=*item;
    //qDebug()<<item->text();
}

void Dialog::on_pushButton_edit_clicked()
{

    int c_index=ui->listWidget->currentIndex().row();
    if( (c_index>=0) && (c_index<shares.size()) ){
        eshare->set_share(shares[c_index]);
        if(eshare->exec()==1) {
            if(!shares.contains(eshare->get_share())) shares[c_index]=eshare->get_share();
        }
    }
    upd_label();
}
