//*****************************************************************************
//*
//*
//*		SocketUtility.h
//*
//*
//*****************************************************************************
//
//	(C) Copyright Anton Zechner 2007
//
//
//	This is a UDP/TCP library for
//
//		LINUX
//		WINDOWS
//		RT-TARGET
//
//	Copyright  2003	Anton Zechner
//
//
#ifndef 	__SOCKETUTIL_H__
#define 	__SOCKETUTIL_H__



#ifdef		_MSC_VER
#ifndef		__cplusplus
#ifndef 	inline
#define 	inline	__inline
#endif
#endif
#endif

#ifdef	__cplusplus
extern	"C" {
#endif


#ifndef		__cplusplus
#ifndef		D
#define 	D(a)
#endif
#else
#ifndef		D
#define 	D(a)	a
#endif
#endif

#define 	TCP_CLIENT		0
#define 	TCP_SERVER		1
#define		TCP_NOBLOCKING	0x00000001
#define 	TCP_NODELAYACK	0x00000002
#define 	TCP_KEEP_ALIVE	0x00000004
#define 	TCP_REUSEADDR	0x00000008
#define 	TCP_USEPORT(a)	((a)<<16)
#define		SU_IPV4_TAG		0xFFFF0000
#define		SU_IPV4_ID		0xD93B3BD9
#ifndef		SU_USE_IPV6
#ifdef		RTTARGET
#define		SU_USE_IPV6		0
#else
#define		SU_USE_IPV6		1
#endif
#endif


	#if SU_USE_IPV6
	typedef	struct
		{
		unsigned			uAddr[4];
		}IpAddr;
	#else
	typedef	unsigned		IpAddr;
	#endif

	typedef	struct
		{
		int	volatile		iSocket;
		int volatile		iValue;
		}TcpCancel;

	typedef	short*			UdpHandle;
	typedef	long*			TcpHandle;

	int			IpAddress (IpAddr *pAddr,const char *pIp,const char *pMask D(=0));
	int			IpHostname(IpAddr *pAddr,const char *pHostname);
	int			IpToString(IpAddr *pAddr,char *pIp);
	int			IpIsV6Address(const char *pName);
	int			IpSetHostname(const char *pName);
	const char *IpGetHostname();


	#if 	SU_USE_IPV6
	static inline int IsIpV6Ex(const IpAddr *pAddr)
		{
		return (pAddr->uAddr[0]==SU_IPV4_ID || pAddr->uAddr[2]==SU_IPV4_TAG)? 0:1;
		}
	#else
	#define 	IsIpV6Ex(p)	0
	#endif

	#if 	SU_USE_IPV6
	static inline int IsIpV6(const IpAddr *pAddr)
		{
		return (pAddr->uAddr[0]==SU_IPV4_ID)? 0:1;
		}
	#else
	#define 	IsIpV6(p)	0
	#endif


	#if 	SU_USE_IPV6
	static inline int IsIpAny(const IpAddr *pAddr)
		{
		if(pAddr->uAddr[1]!=0         )return 0;
		if(pAddr->uAddr[0]!=SU_IPV4_ID)return 1;
		if(pAddr->uAddr[0]!=0         )return 0;
		if(pAddr->uAddr[2]!=0         )return 0;
		if(pAddr->uAddr[3]!=0         )return 0;
		return 1;
		}
	#else
	static inline int IsIpAny(const IpAddr *pAddr)
		{
		return (*pAddr==0)? 1:0;
		}
	#endif

	#if 	SU_USE_IPV6
	static inline int IsIpLoop(const IpAddr *pAddr)
		{
		if(pAddr->uAddr[0]==SU_IPV4_ID)
			{
			return (pAddr->uAddr[1]==(*(unsigned*)"\x7F\0\0\1"))? 1:0;
			}
		if(pAddr->uAddr[3]!=1         )return 0;
		if(pAddr->uAddr[2]!=0         )return 0;
		if(pAddr->uAddr[1]!=0         )return 0;
		if(pAddr->uAddr[0]!=0         )return 0;
		return 1;
		}
	#else
	static inline int IsIpLoop(const IpAddr *pAddr)
		{
		return (*pAddr==(*(unsigned*)"\x7F\0\0\1"))? 1:0;
		}
	#endif

	#if 	SU_USE_IPV6
	static inline unsigned GetIpV4(const IpAddr *pAddr)
		{
		if(pAddr->uAddr[0]!=SU_IPV4_ID)return 0;
		return pAddr->uAddr[1];
		}
	#else
	#define 	GetIpV4(p)	(*(unsigned*)(p))
	#endif

	static inline int IpCompareV4(const unsigned *pAddrA,const unsigned *pAddrB)
		{
		unsigned char	*pPtrA,*pPtrB;
		if(*pAddrA==*pAddrB)return 0;
		pPtrA=(unsigned char*)pAddrA;
		pPtrB=(unsigned char*)pAddrB;
		if(pPtrA[0]!=pPtrB[0])return pPtrA[0]-pPtrB[0];
		if(pPtrA[1]!=pPtrB[1])return pPtrA[1]-pPtrB[1];
		if(pPtrA[2]!=pPtrB[2])return pPtrA[2]-pPtrB[2];
							  return pPtrA[3]-pPtrB[3];
		}

	#if 	SU_USE_IPV6
	static inline int IpCompare(const IpAddr *pAddrA,const IpAddr *pAddrB)
		{
		unsigned char	*pPtrA;
		unsigned char	*pPtrB;
		unsigned		 uOffA;
		unsigned		 uOffB;
		unsigned		 uPos;


		if(pAddrA->uAddr[0]==SU_IPV4_ID)
			{
			uOffA = 1;
			}
		else if(pAddrA->uAddr[2]==SU_IPV4_TAG && !pAddrA->uAddr[1] && !pAddrA->uAddr[0])
			{
			uOffA = 3;
			}
		else{
			uOffA = 0;
			}


		if(pAddrB->uAddr[0]==SU_IPV4_ID)
			{
			uOffB = 1;
			}
		else if(pAddrB->uAddr[2]==SU_IPV4_TAG && !pAddrB->uAddr[1] && !pAddrB->uAddr[0])
			{
			uOffB = 3;
			}
		else{
			uOffB = 0;
			}


		if(uOffA && uOffB)
			{
			return IpCompareV4(pAddrA->uAddr+uOffA,pAddrB->uAddr+uOffB);
			}

		if(uOffA || uOffB)return -1;

		pPtrA=(unsigned char*)pAddrA;
		pPtrB=(unsigned char*)pAddrB;

		for(uPos=0;uPos<15;uPos++)
			{
			if(pPtrA[uPos]!=pPtrB[uPos])return pPtrA[uPos]-pPtrB[uPos];
			}

		return pPtrA[15]-pPtrB[15];
		}
	#else
	static inline int IpCompare(IpAddr *pAddrA,IpAddr *pAddrB)
		{
		return IpCompareV4(pAddrA,pAddrB);
		}
	#endif


//******************** UDP ****************************************************



	UdpHandle	UdpOpen      (IpAddr   *pAddr,unsigned short uPort,int iBcast D(=0),int iNoBlock D(=0));
	int			UdpClose     (UdpHandle hHandle);
	int			UdpShutdown  (UdpHandle hHandle);
	int			UdpBlock     (UdpHandle hHandle,int iOn);
	int			UdpPut       (UdpHandle hHandle,IpAddr *pTarget,const void *pMsg,int iLen);
	int			UdpPutTo     (UdpHandle hHandle,IpAddr *pTarget,const void *pMsg,int iLen,             unsigned short  uPort);
	int			UdpGet       (UdpHandle hHandle,IpAddr *pFrom  ,      void *pMsg,int iLen,             unsigned short *pPort D(=0));
	int			UdpGetWait   (UdpHandle hHandle,IpAddr *pFrom  ,      void *pMsg,int iLen,int iTimeout,unsigned short *pPort D(=0));
	int 		UdpGetLocal	 (UdpHandle hHandle,IpAddr *pAddr,unsigned short *pPort D(=0));
	int			UdpGetCount  (UdpHandle hHandle);
	int			UdpGetPort   (UdpHandle hHandle);
	int 		UdpWaitMulti (UdpHandle*pHandle,int iCount,int iTimeout,int iOffset D(=0));
	int			UdpSetBuffers(UdpHandle hHandle,int iRecvSize,int iSendSize);
	int 		UdpWait      (UdpHandle hHandle,int iTimeout);

	static inline int UdpGetAddr(UdpHandle hHandle,IpAddr *pAddr)
		{
		#if SU_USE_IPV6

		if(!hHandle)
			{
			pAddr->uAddr[0]=SU_IPV4_ID;
			pAddr->uAddr[1]=0;
			return 0;
			}

		pAddr->uAddr[0]=((IpAddr*)hHandle)->uAddr[0];
		pAddr->uAddr[1]=((IpAddr*)hHandle)->uAddr[1];
		pAddr->uAddr[2]=((IpAddr*)hHandle)->uAddr[2];
		pAddr->uAddr[3]=((IpAddr*)hHandle)->uAddr[3];
		return 1;

		#else

		if(!hHandle)
			{
			*pAddr=0;
			return 0;
			}

		*pAddr=*(IpAddr*)hHandle;
		return 1;

		#endif
		}


//******************** TCP ****************************************************


	int			TcpOpenCancel (TcpCancel*pCancel);
	TcpHandle	TcpOpenWait   (IpAddr   *pAddr,unsigned short uPort,int iTimeout,TcpCancel *pCancel D(=0),int iServer D(=0),int iFalgs D(=0));
	TcpHandle   TcpAccept     (TcpHandle hHandle,IpAddr *pAddr,unsigned short *uPort);
	TcpHandle   TcpAcceptWait (TcpHandle hHandle,IpAddr *pAddr,unsigned short *uPort,int iTimeout);
	int 		TcpGetLocal	  (TcpHandle hHandle,IpAddr *pAddr,unsigned short *pPort D(=0));
	int			TcpClose      (TcpHandle hHandle);
	int			TcpShutdown   (TcpHandle hHandle);
	int			TcpSetFlags   (TcpHandle hHandle,int iFlags);
	int			TcpBlock      (TcpHandle hHandle,int iOn);
	int			TcpPut        (TcpHandle hHandle,const void *pMsg,int iLen);
	int			TcpGet        (TcpHandle hHandle,      void *pMsg,int iLen);
	int			TcpGetWait    (TcpHandle hHandle,      void *pMsg,int iLen,int iTimeout);
	int			TcpGetNext	  (TcpHandle hHandle,      void *pMsg,int iLen,int iTimeout);
	int			TcpGetCount   (TcpHandle hHandle);
	int			TcpIsBroken   (TcpHandle hHandle);
	int 		TcpWaitMulti  (TcpHandle*pHandle,int iCount,int iTimeout,int iOffset D(=0));
	int			TcpSetBuffers (TcpHandle hHandle,int iRecvSize,int iSendSize);
	int 		TcpSendTimeout(TcpHandle hHandle,int iTimeout);
	int 		TcpRecvTimeout(TcpHandle hHandle,int iTimeout);
	int 		TcpWait       (TcpHandle hHandle,int iTimeout);


	static inline TcpHandle	TcpOpen(IpAddr *pAddr,unsigned short uPort,int iServer D(=0),int iFlags D(=0))
		{
		return TcpOpenWait(pAddr,uPort,0,0,iServer,iFlags);
		}

	static inline int TcpGetAddr(TcpHandle hHandle,IpAddr *pAddr)
		{
		#if SU_USE_IPV6

		if(!hHandle)
			{
			pAddr->uAddr[0]=SU_IPV4_ID;
			pAddr->uAddr[1]=0;
			return 0;
			}

		pAddr->uAddr[0]=((IpAddr*)hHandle)->uAddr[0];
		pAddr->uAddr[1]=((IpAddr*)hHandle)->uAddr[1];
		pAddr->uAddr[2]=((IpAddr*)hHandle)->uAddr[2];
		pAddr->uAddr[3]=((IpAddr*)hHandle)->uAddr[3];
		return 1;

		#else

		if(!hHandle)
			{
			*pAddr=0;
			return 0;
			}

		*pAddr=*(IpAddr*)hHandle;
		return 1;

		#endif
		}

#ifdef	__cplusplus
}
#endif


#endif


