//*****************************************************************************
//*
//*
//*     SmbTrans2.cpp
//*
//*
//*****************************************************************************
//
//  Copyright  2003    Anton Zechner
//
//  AzSmb is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use AzSmb must be published. Commercial users
//  must published their code too, or make an licence agreement with me.
//
//
//  AzSmb wird unter GNU GENERAL PUBLIC LICENSE (GPL) vertreiben.
//  Sourcecode welcher AzSmb verwendet muss verffentlicht werden.
//  Kommerzielle Nutzer mssen ihren Code ebenfalls verffentlichen, oder
//  eine Nutzungsvereinbarung mit mir treffen.
//
//  az_software@inode.at
//
#include "Smb.h"
#include "SmbServer.h"
#include "SmbInline.h"



//*****************************************************************************
//*
//*     CharRealloc
//*
//*****************************************************************************
inline char *CharRealloc(void *pMem,int iSize)
{
void    *pNewMem;


    if(pMem)pNewMem=SmbReAlloc(pMem,iSize);
    else    pNewMem=SmbAlloc(iSize);

    if(!pNewMem)
        {
        PRINT_SMB_ERRS(("\nSYSERROR out of memory (size=%i)",iSize));
        SmbFree(pMem);
        return 0;
        }

return (char*)pNewMem;
}



//*****************************************************************************
//*
//*     SaveDirEntry
//*
//*****************************************************************************
//  get a level dependent lanman2 dir entry.
static int SaveDirEntry(SmbSession *pSession,int iInfoLevel,int bResumeKey,char *pDataPtr,int iSpaceLeft,SysFindStruct *pFind,int *pLastNameOff)
{
int     iResKey=0;
int     iMode,iLen,iSize,iExtAttr;
char   *pPtr;
#if SYS_HAS_SHORT_NAME
int     iShort;
#endif




    iLen=strlen(pFind->cName);
    pPtr=pDataPtr;

    switch (iInfoLevel)
        {
    case 1: if(bResumeKey)
                {
                SIVAL(pPtr,0,iResKey);
                pPtr += 4;
                }

            SysTimeConvertSD(pFind->dwTimeCreate,(SysDW*)(pPtr+0));
            SysTimeConvertSD(pFind->dwTimeAccess,(SysDW*)(pPtr+4));
            SysTimeConvertSD(pFind->dwTimeWrite ,(SysDW*)(pPtr+8));

            iMode=AttrSysToDos(pFind->dwAttr);
            SIVAL(pPtr,12, pFind->dwSize);
            SIVAL(pPtr,16,(pFind->dwSize+1023)&~1023);
            SSVAL(pPtr,20,iMode);
            SCVAL(pPtr,22,iLen);

            *pLastNameOff=pPtr-pDataPtr+23;
            memcpy(pPtr+23,pFind->cName,iLen+1);
            pPtr += 23+iLen+1;
            break;

    case 2: if(bResumeKey)
                {
                SIVAL(pPtr,0,iResKey);
                pPtr += 4;
                }

            SysTimeConvertSD(pFind->dwTimeCreate,(SysDW*)(pPtr+0));
            SysTimeConvertSD(pFind->dwTimeAccess,(SysDW*)(pPtr+4));
            SysTimeConvertSD(pFind->dwTimeWrite ,(SysDW*)(pPtr+8));

            iMode=AttrSysToDos(pFind->dwAttr);
            SIVAL(pPtr,12, pFind->dwSize);
            SIVAL(pPtr,16,(pFind->dwSize+1023)&~1023);
            SSVAL(pPtr,20,iMode);
            SIVAL(pPtr,22,0);
            SCVAL(pPtr,26,iLen);

            *pLastNameOff=pPtr-pDataPtr+27;
            memcpy(pPtr+27,pFind->cName,iLen+1);
            pPtr += 27+iLen+1;
            break;

    case 3: SIVAL(pPtr,0,iResKey);

            SysTimeConvertSD(pFind->dwTimeCreate,(SysDW*)(pPtr+4));
            SysTimeConvertSD(pFind->dwTimeAccess,(SysDW*)(pPtr+8));
            SysTimeConvertSD(pFind->dwTimeWrite ,(SysDW*)(pPtr+12));

            iLen=strlen(pFind->cName);
            iMode=AttrSysToDos(pFind->dwAttr);
            SIVAL(pPtr,16, pFind->dwSize);
            SIVAL(pPtr,20,(pFind->dwSize+1023)&~1023);
            SSVAL(pPtr,24,iMode);
            SIVAL(pPtr,26,4);
            SCVAL(pPtr,30,iLen);

            *pLastNameOff=pPtr-pDataPtr+31;
            memcpy(pPtr+31,pFind->cName,iLen+1);
            pPtr += 31+iLen+1;
            break;

    case 4: if(bResumeKey)
                {
                SIVAL(pPtr,0,iResKey);
                pPtr += 4;
                }

            iLen=strlen(pFind->cName);
            SIVAL(pPtr,0,33+iLen+1);
            SysTimeConvertSD(pFind->dwTimeCreate,(SysDW*)(pPtr+4));
            SysTimeConvertSD(pFind->dwTimeAccess,(SysDW*)(pPtr+8));
            SysTimeConvertSD(pFind->dwTimeWrite ,(SysDW*)(pPtr+12));

            iMode=AttrSysToDos(pFind->dwAttr);
            SIVAL(pPtr,16, pFind->dwSize);
            SIVAL(pPtr,20,(pFind->dwSize+1023)&~1023);
            SSVAL(pPtr,24,iMode);
            SCVAL(pPtr,32,iLen);

            *pLastNameOff=pPtr-pDataPtr+33;
            memcpy(pPtr+33,pFind->cName,iLen+1);
            pPtr += 33+iLen+1;
            break;


    case SMB_FIND_FILE_BOTH_DIRECTORY_INFO:

            iSize = 94+iLen;
            iSize = (iSize+3)& ~3;

            SIVAL(pPtr,0,iSize  );                              pPtr += 4;
            SIVAL(pPtr,0,iResKey);                              pPtr += 4;
            SysTimeConvertSF(pFind->dwTimeCreate,(SysDW*)pPtr); pPtr += 8;
            SysTimeConvertSF(pFind->dwTimeAccess,(SysDW*)pPtr); pPtr += 8;
            SysTimeConvertSF(pFind->dwTimeWrite ,(SysDW*)pPtr); pPtr += 8;
            SysTimeConvertSF(pFind->dwTimeWrite ,(SysDW*)pPtr); pPtr += 8;


            SIVAL(pPtr, 0, pFind->dwSize);
            SIVAL(pPtr, 4, 0 );
            SIVAL(pPtr, 8,(pFind->dwSize+1023)&~1023);
            SIVAL(pPtr,12, 0 );
            pPtr += 16;

            iExtAttr=AttrSysToWin(pFind->dwAttr);
            SIVAL(pPtr,0,iExtAttr);     pPtr += 4;
            SIVAL(pPtr,0,iLen);         pPtr += 4;
            SIVAL(pPtr,0,0);            pPtr += 4;


            #if SYS_HAS_SHORT_NAME
            iShort=strlen(pFind->cShortName);
            if(iShort!=iLen || memcmp(pFind->cShortName,pFind->cName,iLen))
                {
                SSVAL(pPtr,0,iShort);
                memcpy(pPtr+2,pFind->cShortName,iShort+1);
                }
            else{
                SSVAL(pPtr,0,0);                    // is short name
                SSVAL(pPtr,2,0);
                }
            #else
            SSVAL(pPtr,0,0);                        // no short name
            SSVAL(pPtr,2,0);
            #endif

            pPtr += 2+24;
            *pLastNameOff=pPtr-pDataPtr;
            memcpy(pPtr,pFind->cName,iLen+1);
            pPtr  = pDataPtr + iSize;
            break;

    case SMB_FIND_FILE_DIRECTORY_INFO:

            iSize = 64+iLen;
            iSize = (iSize+3)& ~3;

            SIVAL(pPtr,0,iSize);        pPtr += 4;
            SIVAL(pPtr,0,iResKey);      pPtr += 4;

            SysTimeConvertSF(pFind->dwTimeCreate,(SysDW*)pPtr); pPtr += 8;
            SysTimeConvertSF(pFind->dwTimeAccess,(SysDW*)pPtr); pPtr += 8;
            SysTimeConvertSF(pFind->dwTimeWrite ,(SysDW*)pPtr); pPtr += 8;
            SysTimeConvertSF(pFind->dwTimeWrite ,(SysDW*)pPtr); pPtr += 8;

            SIVAL(pPtr, 0, pFind->dwSize);
            SIVAL(pPtr, 4, 0 );
            SIVAL(pPtr, 8,(pFind->dwSize+1023)&~1023);
            SIVAL(pPtr,12, 0 );
            pPtr += 16;

            iExtAttr=AttrSysToWin(pFind->dwAttr);
            SIVAL(pPtr,0,iExtAttr);     pPtr += 4;
            SIVAL(pPtr,0,iLen);         pPtr += 4;

            *pLastNameOff=pPtr-pDataPtr;
            memcpy(pPtr,pFind->cName,iLen+1);
            pPtr = pDataPtr + iSize;
            break;

    case SMB_FIND_FILE_FULL_DIRECTORY_INFO:

            iSize = 68+iLen;
            iSize = (iSize+3)& ~3;
            SIVAL(pPtr,0,iSize);    pPtr += 4;
            SIVAL(pPtr,0,iResKey);  pPtr += 4;

            SysTimeConvertSF(pFind->dwTimeCreate,(SysDW*)pPtr); pPtr += 8;
            SysTimeConvertSF(pFind->dwTimeAccess,(SysDW*)pPtr); pPtr += 8;
            SysTimeConvertSF(pFind->dwTimeWrite ,(SysDW*)pPtr); pPtr += 8;
            SysTimeConvertSF(pFind->dwTimeWrite ,(SysDW*)pPtr); pPtr += 8;

            SIVAL(pPtr, 0, pFind->dwSize);
            SIVAL(pPtr, 4, 0 );
            SIVAL(pPtr, 8,(pFind->dwSize+1023)&~1023);
            SIVAL(pPtr,12, 0 );
            pPtr += 16;

            iExtAttr=AttrSysToWin(pFind->dwAttr);
            SIVAL(pPtr,0,iExtAttr);     pPtr += 4;
            SIVAL(pPtr,0,iLen);         pPtr += 4;
            SIVAL(pPtr,0,0);            pPtr += 4;

            *pLastNameOff=pPtr-pDataPtr;
            memcpy(pPtr,pFind->cName,iLen+1);
            pPtr = pDataPtr + iSize;
            break;

    case SMB_FIND_FILE_NAMES_INFO:

            iSize = 12+iLen;
            iSize = (iSize+3) & ~3;
            SIVAL(pPtr,0,iSize);    pPtr += 4;
            SIVAL(pPtr,0,iResKey);  pPtr += 4;
            SIVAL(pPtr,0,iLen);     pPtr += 4;

            *pLastNameOff=pPtr-pDataPtr;
            memcpy(pPtr,pFind->cName,iLen+1);
            pPtr = pDataPtr + iSize;
            break;

    default:*pLastNameOff=0;
            return 0;
        }


    iSize=PTR_DIFF(pPtr,pDataPtr);


return iSize;
}



//*****************************************************************************
//*
//*     SendTrans2Replies
//*
//*****************************************************************************
//  Send the required number of replies back.
static int SendTrans2Replies(SmbSession *pSession,unsigned char *pOut, int iBuffSize, char *pParam,
                               int iParamSize, char *pData, int iDataSize)
{
int     iOutsize;
int     iDataToSend  = iDataSize;
int     iParamToSend = iParamSize;
int     iUseableSpace;
int     iParamSend;
int     iTotalSend;
int     iDataSend;
int     iAlignOffset     = 1;
int     iDataAlignOffset = 0;
char   *pParamPtr;
char   *pDataPtr;




    pParamPtr = pParam;
    pDataPtr  = pData;


    iOutsize=SmbSetMessage(pOut,10,0,TRUE);

    if(iParamToSend<=0 && iDataToSend<=0)
        {
        if(!TcpPut(pSession->hTcp,pOut,iOutsize))
            {
            PRINT_SMB_ERRS(("\nSMB SYSERROR  SendTrans2Replies: send_smb failed."))
            if(pParam)SmbFree(pParam);
            if(pData )SmbFree(pData);
            SmbSessionExit(pSession);
			return -1;
            }

        return 0;
        }

    if((iParamToSend&3) && iDataToSend>=0)
        {
        iDataAlignOffset = 4 - (iParamToSend&3);
        }

    iUseableSpace = iBuffSize - ((smb_buf(pOut)-pOut)-iAlignOffset-iDataAlignOffset);
    iUseableSpace = MIN(iUseableSpace, pSession->iMaxResvSize-iAlignOffset-iDataAlignOffset-smb_size-20);


    while(iParamToSend>0 || iDataToSend>0)
        {
        iTotalSend = iParamToSend + iDataToSend + iAlignOffset + iDataAlignOffset;
        iTotalSend = MIN(iTotalSend,iUseableSpace+iAlignOffset + iDataAlignOffset);

        iOutsize=SmbSetMessage(pOut, 10, iTotalSend, TRUE);

        SSVAL(pOut,smb_tprcnt,iParamSize);
        SSVAL(pOut,smb_tdrcnt,iDataSize);

        iParamSend = MIN(iParamToSend,iUseableSpace);
        iDataSend  = iUseableSpace - iParamSend;
        iDataSend  = MIN(iDataSend,iDataToSend);

        SSVAL(pOut,smb_prcnt, iParamSend);
        SSVAL(pOut,smb_proff,((char*)(smb_buf(pOut)+iAlignOffset) - smb_base(pOut)));

        if(iParamSend == 0)
                SSVAL(pOut,smb_prdisp,0);
        else    SSVAL(pOut,smb_prdisp,pParamPtr - pParam);


        SSVAL(pOut,smb_drcnt, iDataSend);

        if(iDataSend == 0)
            {
            SSVAL(pOut,smb_droff ,0);
            SSVAL(pOut,smb_drdisp,0);
            }
        else{
            SSVAL(pOut,smb_droff,((char*)(smb_buf(pOut)+iAlignOffset) - smb_base(pOut)) + iParamSend + iDataAlignOffset);
            SSVAL(pOut,smb_drdisp, pDataPtr - pData);
            }

        if(iParamSend)memcpy(smb_buf(pOut)+iAlignOffset,pParamPtr,iParamSend);
        if(iDataSend )memcpy(smb_buf(pOut)+iAlignOffset+iParamSend+iDataAlignOffset,pDataPtr,iDataSend);


        if(!TcpPut(pSession->hTcp,pOut,iOutsize))
            {
            PRINT_SMB_ERRS(("\nSMB SYSERROR  SendTrans2Replies: send_smb failed."))
            if(pParam)SmbFree(pParam);
            if(pData )SmbFree(pData);
            SmbSessionExit(pSession);
			return -1;
            }

        pParamPtr    += iParamSend;
        pDataPtr     += iDataSend;
        iParamToSend -= iParamSend;
        iDataToSend  -= iDataSend;
        }

return 0;
}



//*****************************************************************************
//*
//*     Trans2Open
//*
//*****************************************************************************
//  reply to a TRANSACT2_OPEN
static int Trans2Open(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,
                            int iBuffSize, char **pParam, char **pData)
{
char            cName[MAX_PATHNAME_SIZE];
char           *pName;
char           *pPtr;
int             iFlag;
int             iMode;
int             iOpen;
int             iSize;
int             iError;
int             iAction;
int             iAccess;
int             bExist;
int             bError;
unsigned int    uAttr;
unsigned short  wFid;
SysFindStruct   sInfo;
SysFile         hFile;




    pPtr  = *pParam;

    iFlag = SVAL(pPtr,2);
    iMode = SVAL(pPtr,6);
    iOpen = SVAL(pPtr,12);
    iSize = IVAL(pPtr,14);



    pName = pPtr+28;


    if(SmbPathName(pSession,cName,pName)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong file: \"%s\"",pName))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }

    if(pSession->pTree->iConnectType!=0)        // wrong connection
        {
        return SMB_ERROR(ERRDOS,ERRaccess);
        }


    PRINT_SMB_MSG1((" mode=%02Xh open=%02Xh file=\"%s\"",iMode,iOpen,cName))

    switch(iMode&0x0F)
        {
    case 0: uAttr=SYS_READ;                    break;
    case 1: uAttr=SYS_WRITE;                   break;
    case 2: uAttr=SYS_WRITE|SYS_READ;          break;
    default:uAttr=SYS_READ;
            bError=TRUE;
        }

    switch((iMode>>4)&0x07)
        {
    case 0:
    case 1:                                     break;
    case 2: uAttr|=SYS_SHARE_RD;               break;
    case 3: uAttr|=SYS_SHARE_WR;               break;
    case 4: uAttr|=SYS_SHARE_WR|SYS_SHARE_RD;  break;
    default:bError=TRUE;
        }

    if(iOpen&0x10)uAttr|=SYS_CREATE|SYS_WRITE;

    bExist=SysGetAttributes(cName)>=0;
    PRINT_SMB_MSG1((" exist=%i",bExist));


    if(bExist)
    switch(iOpen&0x03)
        {
    case 0: bError  = TRUE;                     break;
    case 1: uAttr &=~SYS_CREATE;               break;
    case 2: uAttr |= SYS_TRUNC;                break;
    default:bError  = TRUE;
        }

    if((uAttr&SYS_WRITE) && pSession->pTree->bReadOnly)
        {
        PRINT_SMB_ERR(("SMB_ERROR no writte access"))
        return SMB_ERROR(ERRDOS,ERRnoaccess);
        }

    switch(uAttr&(SYS_WRITE|SYS_READ))
        {
    case SYS_WRITE|SYS_READ:    iAccess=DOS_OPEN_RDWR;      break;
    case SYS_WRITE:             iAccess=DOS_OPEN_WRONLY;    break;
    case SYS_READ:              iAccess=DOS_OPEN_RDONLY;    break;
    default:bError=TRUE;
        }

    if(bError)return SMB_ERROR(ERRDOS,ERRnoaccess);


        hFile=SysOpenEx(cName,uAttr,&iError);
    if(!hFile)
        {
        PRINT_SMB_ERRS(("SMB_ERROR cant't open file '%s'",cName));

        switch(iError)
            {
        case SYS_ERR_NO_HANDLES:        return SMB_ERROR(ERRDOS,ERRnofids);
        case SYS_ERR_PATH_NOTFOUND:     return SMB_ERROR(ERRDOS,ERRbadpath);
        case SYS_ERR_INVALID_FILENAME:  return SMB_ERROR(ERRDOS,ERRbadpath);
        case SYS_ERR_FILE_NOT_FOUND:    return SMB_ERROR(ERRDOS,ERRbadfile);
        default:                        return SMB_ERROR(ERRDOS,ERRnoaccess);
            }
        }

    if(SysGetFileInfo(hFile,&sInfo)<0)
        {
        PRINT_SMB_ERRS(("SYSERROR cant't get file info"));
        SysClose(hFile);
        return SMB_ERROR(ERRDOS,ERRnoaccess);
        }



    bError = FALSE;

        wFid=SmbCreateFile(pSession,hFile,0);
    if(!wFid)
        {
        PRINT_SMB_ERRS(("SYSERROR no SmbFree file id"));
        SysClose(hFile);
        return SMB_ERROR(ERRDOS,ERRnofids);
        }


    pSession->wFid  = wFid;
    pSession->pFile = SmbGetFile(pSession,wFid);



    if(!bExist)
        {
        iAction=FILE_WAS_CREATED;
        PRINT_SMB_MSG1((" create "))
        }
    else{
        if(uAttr&SYS_TRUNC)
                iAction=FILE_WAS_OVERWRITTEN;
        else    iAction=FILE_WAS_OPENED;

        PRINT_SMB_MSG1(("%s",(uAttr&SYS_TRUNC)? " overwrite ":" opened "))
        }



    iMode=AttrSysToDos(sInfo.dwAttr);
    memset(pPtr,0,28);
    SSVAL(pPtr, 0,wFid);
    SSVAL(pPtr, 2,iMode);
    SIVAL(pPtr, 4,sInfo.dwTimeWrite);
    SIVAL(pPtr, 8,sInfo.dwSize);
    SSVAL(pPtr,12,iMode);
    SSVAL(pPtr,18,iAction);


    SendTrans2Replies(pSession,pOut,iBuffSize,pPtr,28,*pData,0);
    PRINT_SMB_MSG1((" FID=%i size=%u <ok>",wFid,sInfo.dwSize))


return 0;
}

//*****************************************************************************
//*
//*     Trans2FindFirst
//*
//*****************************************************************************
//  reply to a TRANS2_FINDFIRST.
static int Trans2FindFirst(SmbSession *pSession,unsigned char *pIn, unsigned char *pOut, int iBuffSize,
                                char **pParam, char **pData)
{
char            cName[MAX_PATHNAME_SIZE];
char           *pParamPtr;
char           *pDataPtr;
char           *pName;
char           *pPtr;
int             iMaxDataBytes;
int             iLastNameOff;
int             iMaxCount;
int             iAttribut;
int             iInfoLevel;
int             iSpaceLeft;
int             iFlags;
int             iError;
int             iSize;
int             iLen;
int             iNum;
unsigned short  wFid;
unsigned int    uAttr;
int             bFail;
int             bResumeKey;
int             bFinished;
int             bOutOfSpace;
SmbFileEntry   *pFile;
SmbTreeEntry   *pTree;
SmbBase         hBase;
SysFind         hFind;
SysFindStruct   sFind;





    pParamPtr       = *pParam;
    pDataPtr        = *pData;

    iMaxDataBytes   = SVAL(pIn, smb_mdrcnt);
    iAttribut       = SVAL(pParamPtr,0);
    iMaxCount       = SVAL(pParamPtr,2);
    iFlags          = SVAL(pParamPtr,4);
    iInfoLevel      = SVAL(pParamPtr,6);
    bResumeKey      = iFlags&4;


    switch (iInfoLevel)                             // check info level
        {
        case 1:
        case 2:
        case 3:
        case 4:
        case SMB_FIND_FILE_DIRECTORY_INFO:
        case SMB_FIND_FILE_FULL_DIRECTORY_INFO:
        case SMB_FIND_FILE_NAMES_INFO:
        case SMB_FIND_FILE_BOTH_DIRECTORY_INFO:
                break;
        default:return SMB_ERROR(ERRDOS,ERRunknownlevel);
        }


    if(!pSession->pTree->pUser)
        {
        return SMB_ERROR(ERRDOS,ERRbaduid);
        }


    pName = pParamPtr+12;


       iLen=SmbPathName(pSession,cName,pName);
    if(iLen<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong file: \"%s\"",pName))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }


//******************** create buffers *****************************************


       pDataPtr = CharRealloc(*pData,iMaxDataBytes+512);
    if(pDataPtr == NULL )
        {
        PRINT_SMB_ERRS(("SYSERROR out of memory (size=%i)",iMaxDataBytes+512))
        return SMB_ERROR(ERRDOS,ERRnomem);
        }

    *pData = pDataPtr;
    memset(pDataPtr,0,iMaxDataBytes + 512);


       pParamPtr = CharRealloc(*pParam, 10);
    if(pParamPtr == NULL )
        {
        PRINT_SMB_ERRS(("SYSERROR out of memory (size=10)"))
        return SMB_ERROR(ERRDOS,ERRnomem);
        }

    *pParam = pParamPtr;


//******************** init search ********************************************


    for(iNum=iLen;iNum>=0;)                         // check filer
        {
        iNum--;
        if(cName[iNum]=='\\')break;
        if(cName[iNum]==':' )break;
        }

    iNum++;
    if(iNum==iLen)
        {
        if(iNum>0 && cName[iNum-1]!='\\')
                SIVAL(cName,iNum,0x002A5C);         // add '\*'
        else    SSVAL(cName,iNum,0x002A);           // add '*'
        }

    PRINT_SMB_MSG1((" file=\"%s\" ",cName))
    uAttr=AttrDosToSys(iAttribut);



        pTree=pSession->pTree;
    if( pTree->iConnectType==4)                     // base dir connection
        {
        if(!iAttribut || (iAttribut&aDIR))
                hBase=SmbBaseFirst(pSession,cName,&sFind);
        else    hBase=0;

        if(!hBase)
            {
            PRINT_SMB_MSG1((" found=0   "))
            return SMB_ERROR(ERRDOS,ERRbadfile);
            }

        wFid=SmbCreateFile(pSession,hBase,2);
        PRINT_SMB_MSG1((" Base=%X",wFid))
        }
    else{
            hFind=SysFindFirstEx(cName,&sFind,&iError);
        if(!hFind)
            {
            PRINT_SMB_MSG1((" found=0   "))
            switch(iError)
                {
            case SYS_ERR_PATH_NOTFOUND: return SMB_ERROR(ERRDOS,ERRbadpath);
            default:                    return SMB_ERROR(ERRDOS,ERRbadfile);
                }
            }

        wFid=SmbCreateFile(pSession,hFind,1);
        PRINT_SMB_MSG1((" Find=%X (%s) ",wFid,sFind.cName))
        }



//******************** seach **************************************************


                         uAttr =0;                 // set search attributes
    if(iAttribut&aHIDDEN)uAttr|=SYS_HIDDEN;
    if(iAttribut&aSYSTEM)uAttr|=SYS_SYSTEM;
    if(iAttribut&aDIR   )uAttr|=SYS_DIR;

    iSpaceLeft  = iMaxDataBytes;
    iLastNameOff= 0;
    pFile       = SmbGetFile(pSession,wFid);
    pPtr        = pDataPtr;
    bFinished   = FALSE;
    bOutOfSpace = FALSE;
    bFail       = FALSE;


    if(!pFile)                                      // ckeck file
        {
        PRINT_SMB_MSG1((" found=0   "))
        return SMB_ERROR(ERRDOS,ERRbadfile);
        }

    pFile->ulUser=iAttribut;

    for(iNum=0;iNum<iMaxCount;iNum++)               // copy entries
        {
        if(bFail)
            {
            if(pFile->bType==2)
                    bFail=SmbBaseNext(pSession,pFile->hBase,&sFind);
            else    bFail=SysFindNext(         pFile->hFind,&sFind);
            }

        if(bFail)
            {
            bFinished=TRUE;
            break;
            }

        PRINT_SMB_MSG2(("\n %i\t\"%s\"",iNum,sFind.cName))
        bFail=TRUE;

        if(iAttribut)
            {
            if(!(uAttr&sFind.dwAttr))
            if(sFind.dwAttr&(SYS_SYSTEM|SYS_HIDDEN|SYS_DIR)){iNum--;continue;}
            }
        else{
            if(sFind.dwAttr&(SYS_SYSTEM|SYS_HIDDEN|SYS_DIR)){iNum--;continue;}
            }

            iSize = SaveDirEntry(pSession,iInfoLevel,bResumeKey,pPtr,iSpaceLeft,&sFind,&iLastNameOff);
        if(!iSize)break;


        iLastNameOff += pPtr-pDataPtr;              // next buffer
        iSpaceLeft   -= iSize;
        pPtr         += iSize;


        if(iSpaceLeft<68+256)
            {
            bOutOfSpace = TRUE;
            break;
            }
        }


    PRINT_SMB_MSG1((" found=%i  FID=%i ",iNum,wFid))

    if(iNum==0)
        {
        SmbClearFile(pSession,wFid);
        return SMB_ERROR(ERRDOS,ERRbadfile);
        }

    if(iFlags&1 && wFid)                            // close after this request
        {
        SmbClearFile(pSession,wFid);
        pFile = 0;
        wFid  = 0;
        }

    if(iFlags&2 && wFid && bFinished)               // close after search end
        {
        SmbClearFile(pSession,wFid);
        pFile = 0;
        wFid  = 0;
        }

    pSession->wFid  = wFid;
    pSession->pFile = pFile;

    SSVAL(pParamPtr,0,wFid);
    SSVAL(pParamPtr,2,iNum);
    SSVAL(pParamPtr,4,bFinished);
    SSVAL(pParamPtr,6,0);
    SSVAL(pParamPtr,8,iLastNameOff);

    SendTrans2Replies(pSession,pOut,iBuffSize,pParamPtr,10,pDataPtr,PTR_DIFF(pPtr,pDataPtr));
    PRINT_SMB_MSG1((" <ok>"))



return 0;
}

//*****************************************************************************
//*
//*     Trans2FindNext
//*
//*****************************************************************************
//  reply to a TRANS2_FINDFIRST.
static int Trans2FindNext(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iBuffSize,
                                char **pParam, char **pData)
{
char           *pParamPtr;
char           *pDataPtr;
char           *pName;
char           *pPtr;
int             iMaxDataBytes;
int             iMaxCount;
int             iAttribut;
int             iFlags;
int             iInfoLevel;
int             iSpaceLeft;
int             iLastNameOff;
int             iSize;
int             iNum;
unsigned short  wFid;
unsigned        uAttr;
int             bFail;
int             bResumeKey;
int             bFinished;
int             bOutOfSpace;
SmbFileEntry   *pFile;
SysFindStruct   sFind;





    pParamPtr       = *pParam;
    pDataPtr        = *pData;

    iMaxDataBytes   = SVAL(pIn, smb_mdrcnt);
    wFid            = SVAL(pParamPtr,0);
    iMaxCount       = SVAL(pParamPtr,2);
    iInfoLevel      = SVAL(pParamPtr,4);
    iFlags          = SVAL(pParamPtr,10);
    bResumeKey      = iFlags&4;
    pName           = pParamPtr+12;

    switch (iInfoLevel)                             // check info level
        {
        case 1:
        case 2:
        case 3:
        case 4:
        case SMB_FIND_FILE_DIRECTORY_INFO:
        case SMB_FIND_FILE_FULL_DIRECTORY_INFO:
        case SMB_FIND_FILE_NAMES_INFO:
        case SMB_FIND_FILE_BOTH_DIRECTORY_INFO:
                break;
        default:return SMB_ERROR(ERRDOS,ERRunknownlevel);
        }


//******************** create buffers *****************************************


       pDataPtr = CharRealloc(*pData,iMaxDataBytes+512);
    if(pDataPtr == NULL )
        {
        PRINT_SMB_ERRS(("SYSERROR out of memory (size=%i)",iMaxDataBytes+512))
        return SMB_ERROR(ERRDOS,ERRnomem);
        }

    *pData = pDataPtr;
    memset(pDataPtr,0,iMaxDataBytes + 512);


       pParamPtr = CharRealloc(*pParam, 10);
    if(pParamPtr == NULL )
        {
        PRINT_SMB_ERRS(("SYSERROR out of memory (size=10)"))
        return SMB_ERROR(ERRDOS,ERRnomem);
        }

    *pParam = pParamPtr;


//******************** init search ********************************************

        pFile=SmbGetFile(pSession,wFid);
    if(!pFile)                                      // ckeck file
        {
        PRINT_SMB_MSG1((" found=0   "))
        return SMB_ERROR(ERRDOS,ERRbadfile);
        }

    if(pFile->bType!=1 && pFile->bType!=2)
        {
        PRINT_SMB_MSG1((" found=0   "))
        return SMB_ERROR(ERRDOS,ERRbadfile);
        }


    iAttribut=pFile->ulUser;


//******************** seach **************************************************


                         uAttr =0;                 // set search attributes
    if(iAttribut&aHIDDEN)uAttr|=SYS_HIDDEN;
    if(iAttribut&aSYSTEM)uAttr|=SYS_SYSTEM;
    if(iAttribut&aDIR   )uAttr|=SYS_DIR;

    iSpaceLeft  = iMaxDataBytes;
    iLastNameOff= 0;
    pFile       = SmbGetFile(pSession,wFid);
    pPtr        = pDataPtr;
    bFinished   = FALSE;
    bOutOfSpace = FALSE;
    bFail       = TRUE;


    for(iNum=0;iNum<iMaxCount;iNum++)               // copy entries
        {
        if(bFail)
            {
            if(pFile->bType==2)
                    bFail=SmbBaseNext(pSession,pFile->hBase,&sFind);
            else    bFail=SysFindNext(         pFile->hFind,&sFind);
            }

        if(bFail)
            {
            bFinished=TRUE;
            break;
            }

        PRINT_SMB_MSG2(("\n %i\t\"%s\"",iNum,sFind.cName))
        bFail=TRUE;

        if(iAttribut)
            {
            if(!(uAttr&sFind.dwAttr))
            if(sFind.dwAttr&(SYS_SYSTEM|SYS_HIDDEN|SYS_DIR)){iNum--;continue;}
            }
        else{
            if(sFind.dwAttr&(SYS_SYSTEM|SYS_HIDDEN|SYS_DIR)){iNum--;continue;}
            }

            iSize = SaveDirEntry(pSession,iInfoLevel,bResumeKey,pPtr,iSpaceLeft,&sFind,&iLastNameOff);
        if(!iSize)break;

        iLastNameOff += pPtr-pDataPtr;              // next buffer
        iSpaceLeft   -= iSize;
        pPtr         += iSize;


        if(iSpaceLeft<94+256)
            {
            bOutOfSpace = TRUE;
            break;
            }
        }


    PRINT_SMB_MSG1((" found=%i  FID=%i ",iNum,wFid))

    if(iNum==0)
        {
        SmbClearFile(pSession,wFid);
        return SMB_ERROR(ERRDOS,ERRbadfile);
        }

    if(iFlags&1 && wFid)                            // close after this request
        {
        SmbClearFile(pSession,wFid);
        pFile=0;
        wFid=0;
        }

    if(iFlags&2 && wFid && bFinished)               // close after search end
        {
        SmbClearFile(pSession,wFid);
        pFile=0;
        wFid=0;
        }


    pSession->wFid  = wFid;
    pSession->pFile = pFile;

    SSVAL(pParamPtr,0,iNum);
    SSVAL(pParamPtr,2,bFinished);
    SSVAL(pParamPtr,4,0);
    SSVAL(pParamPtr,6,iLastNameOff);

    SendTrans2Replies(pSession,pOut,iBuffSize,pParamPtr,8,pDataPtr,PTR_DIFF(pPtr,pDataPtr));
    PRINT_SMB_MSG1((" <ok>"))


return 0;
}

//*****************************************************************************
//*
//*     Trans2QFsInfo
//*
//*****************************************************************************
//  reply to a TRANS2_QFSINFO (query filesystem info)
static int Trans2QFsInfo(   SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,
                                int iBuffSize,char **pParam, char **pData)
{
int             iMaxDataBytes;
int             iInfoLevel;
int             iDataLen;
int             iLen,iFreeCalc;
char           *pDataPtr;
char           *pParamPtr;
const char     *pPath;
SmbTreeEntry   *pTree;
SmbUserEntry   *pUser;
SysVolumeInfo   sInfo;




    pDataPtr  = *pData;
    pParamPtr = *pParam;

    iMaxDataBytes = SVAL(pIn,smb_mdrcnt);
    iInfoLevel    = SVAL(pParamPtr,0);

    switch (iInfoLevel)
        {
    case 1:
    case SMB_QUERY_FS_SIZE_INFO:    iFreeCalc=1;    break;
    default:                        iFreeCalc=0;    break;
        }

    if(pSession->pTree->iConnectType!=0)
        {
        return SMB_ERROR(ERRSRV,ERRinvdevice);
        }


    pUser=pSession->pUser;
    pTree=pSession->pTree;
    pPath=pUser->pPath[pTree->iConnect];
    PRINT_SMB_MSG1((" file=\"%s\"",pPath))


    if(SysGetVolumeInfo(pPath,&sInfo,iFreeCalc)<0)
        {
        return SMB_ERROR(ERRSRV,ERRinvdevice);
        }


       pDataPtr =  CharRealloc(*pData, iMaxDataBytes + 64);
    if(pDataPtr == NULL )
        {
        return SMB_ERROR(ERRDOS,ERRnomem);
        }

    memset(pDataPtr,0,iMaxDataBytes+64);
    *pData  = pDataPtr;

    PRINT_SMB_MSG1((" level=%i",iInfoLevel))

    switch (iInfoLevel)
        {
    case 1: iDataLen = 18;
            SIVAL(pDataPtr, 0,0);
            SIVAL(pDataPtr, 4,sInfo.dwSectorsPerUnit);
            SIVAL(pDataPtr, 8,sInfo.dwTotalUnits);
            SIVAL(pDataPtr,12,sInfo.dwFreeUnits);
            SSVAL(pDataPtr,16,sInfo.dwBytesPerSector);
            break;

    case 2: iLen=strlen(sInfo.cName);
            if(iLen>11)iLen=11;
            iDataLen = 5+iLen+1;
            SIVAL(pDataPtr,0,sInfo.dwSerialNumber);
            SCVAL(pDataPtr,4,iLen);
            memcpy(pDataPtr+5,sInfo.cName,iLen);
            break;

    case SMB_QUERY_FS_ATTRIBUTE_INFO:

            iLen=strlen(sInfo.cName);
            iDataLen = 12+iLen+1;
            SIVAL(pDataPtr,0,0x022);
            SIVAL(pDataPtr,4,255);
            SIVAL(pDataPtr,8,iLen);
            memcpy(pDataPtr+12,sInfo.cName,iLen);
            break;

    case SMB_QUERY_FS_LABEL_INFO:

            iLen=strlen(sInfo.cName);
            iDataLen = 4+iLen;
            SIVAL(pDataPtr,0,iLen);
            memcpy(pDataPtr+4,sInfo.cName,iLen);
            break;

    case SMB_QUERY_FS_VOLUME_INFO:

            iLen=strlen(sInfo.cName);
            iDataLen = 18+iLen;
            SIVAL(pDataPtr, 8,sInfo.dwSerialNumber);
            SIVAL(pDataPtr,12,iLen);
            memcpy(pDataPtr+18,sInfo.cName,iLen);
            break;

    case SMB_QUERY_FS_SIZE_INFO:

            iDataLen = 24;
            SIVAL(pDataPtr, 0,sInfo.dwTotalUnits);
            SIVAL(pDataPtr, 8,sInfo.dwFreeUnits);
            SIVAL(pDataPtr,16,sInfo.dwSectorsPerUnit);
            SIVAL(pDataPtr,20,sInfo.dwBytesPerSector);
            break;

    case SMB_QUERY_FS_DEVICE_INFO:

            iDataLen = 8;
            SIVAL(pDataPtr,0,0);                // dev type
            SIVAL(pDataPtr,4,8);                // characteristics
            break;

    default:return SMB_ERROR(ERRDOS,ERRunknownlevel);
        }


    SendTrans2Replies(pSession,pOut, iBuffSize, pParamPtr, 0, pDataPtr, iDataLen);
    PRINT_SMB_MSG1((" <ok>"))



return 0;
}

//*****************************************************************************
//*
//*     Trans2SetFsInfo
//*
//*****************************************************************************
//  reply to a TRANS2_SETFSINFO  set filesystem info
static int Trans2SetFsInfo(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iBuffSize,char **pParam, char **pData)
{
int iOutsize;


    if(!pSession->pTree || pSession->pTree->bReadOnly)
        {
        return SMB_ERROR(ERRSRV,ERRaccess);
        }

    iOutsize = SmbSetMessage(pOut,10,0,TRUE);
    PRINT_SMB_MSG1((" <ok>"))


return iOutsize;
}

//*****************************************************************************
//*
//*     Trans2QFilePathInfo
//*
//*****************************************************************************
//  Reply to a TRANS2_QFILEPATHINFO or TRANSACT2_QFILEINFO (
//  query file info by file name or file id.
static int Trans2QFilePathInfo(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iBuffSize,char **pParam,char **pData)
{
char            cName[MAX_PATHNAME_SIZE];
char           *pName;
char           *pDataPtr;
char           *pParamPtr;
int             iDataSize;
int             iInfoLevel;
int             iTransCall;
int             iMode,iLen;
int             iMaxDataBytes;
unsigned short  wFid;
unsigned        uTell;
SmbFileEntry   *pFile;
SysFindStruct   sInfo;
SysFind         hFind;



    pDataPtr      = *pData;
    pParamPtr     = *pParam;

    iMaxDataBytes = SVAL(pIn,smb_mdrcnt);
    iTransCall    = SVAL(pIn,smb_setup);




    if(iTransCall==TRANSACT2_QFILEINFO)
        {
        wFid       = SVAL(pParamPtr,0);
        iInfoLevel = SVAL(pParamPtr,2);

            pFile  = SmbGetFile(pSession,wFid);
        if(!pFile || pFile->bType!=0)
            {
            return SMB_ERROR(ERRDOS,ERRbadfid);
            }

        if(SysGetFileInfo(pFile->hFile,&sInfo)<0)
            {
            return SMB_ERROR(ERRDOS,ERRnoaccess);
            }

           uTell=SysTell(pFile->hFile);
        if(uTell&0x80000000)
            {
            return SMB_ERROR(ERRDOS,ERRnoaccess);
            }
        }
    else{
        iInfoLevel = SVAL(pParamPtr,0);
        pName = pParamPtr+6;

        if(SmbPathName(pSession,cName,pName)<0)
            {
            PRINT_SMB_ERR(("SMB_ERROR wrong file: \"%s\"",pName))
            return SMB_ERROR(ERRDOS,ERRbadpath);
            }

            hFind=SysFindFirst(cName,&sInfo);
        if(!hFind)
            {
            return SMB_ERROR(ERRDOS,ERRnoaccess);
            }

        SysFindClose(hFind);
        uTell=0;
        }




       pDataPtr =  CharRealloc(*pData, iMaxDataBytes + 256+128);
    if(pDataPtr == NULL )
        {
        return SMB_ERROR(ERRDOS,ERRnomem);
        }

    memset(pDataPtr,0,iMaxDataBytes+256+128);
    *pData  = pDataPtr;
    iMode   = AttrSysToDos(sInfo.dwAttr);

    PRINT_SMB_MSG1((" level=%i",iInfoLevel))

    switch (iInfoLevel)
        {
    case SMB_INFO_STANDARD:
    case SMB_INFO_QUERY_EA_SIZE:

        iDataSize = (iInfoLevel==1)? 22:26;
        SysTimeConvertSD(sInfo.dwTimeCreate,(SysDW*)(pDataPtr+0));
        SysTimeConvertSD(sInfo.dwTimeAccess,(SysDW*)(pDataPtr+4));
        SysTimeConvertSD(sInfo.dwTimeWrite ,(SysDW*)(pDataPtr+8));
        SIVAL(pDataPtr,12, sInfo.dwSize);
        SIVAL(pDataPtr,16,(sInfo.dwSize+1023)&~1023);
        SSVAL(pDataPtr,20,iMode);
        SIVAL(pDataPtr,22,4);
        break;

    case SMB_INFO_QUERY_EAS_FROM_LIST:

        iDataSize = 24;

        SysTimeConvertSD(sInfo.dwTimeCreate,(SysDW*)(pDataPtr+0));
        SysTimeConvertSD(sInfo.dwTimeAccess,(SysDW*)(pDataPtr+4));
        SysTimeConvertSD(sInfo.dwTimeWrite ,(SysDW*)(pDataPtr+8));
        SIVAL(pDataPtr,12, sInfo.dwSize);
        SIVAL(pDataPtr,16,(sInfo.dwSize+1023)&~1023);
        SIVAL(pDataPtr,20,iMode);
        break;

    case SMB_INFO_QUERY_ALL_EAS:

        iDataSize = 4;
        SIVAL(pDataPtr,0,iDataSize);
        break;

    case 6:

        return SMB_ERROR(ERRDOS,ERRbadfunc);

    case SMB_FILE_BASIC_INFORMATION:
    case SMB_QUERY_FILE_BASIC_INFO:

        if (iInfoLevel==SMB_QUERY_FILE_BASIC_INFO)
            {
            iDataSize = 36;
            }
        else{
            iDataSize = 40;
            SIVAL(pDataPtr,36,0);
            }

        SysTimeConvertSF(sInfo.dwTimeCreate,(SysDW*)(pDataPtr+0));
        SysTimeConvertSF(sInfo.dwTimeAccess,(SysDW*)(pDataPtr+8));
        SysTimeConvertSF(sInfo.dwTimeWrite ,(SysDW*)(pDataPtr+16));
        SysTimeConvertSF(sInfo.dwTimeWrite ,(SysDW*)(pDataPtr+24));
        SIVAL(pDataPtr,32,iMode);
        break;

    case SMB_FILE_STANDARD_INFORMATION:
    case SMB_QUERY_FILE_STANDARD_INFO:

        iDataSize = 22;
        SIVAL(pDataPtr,0,sInfo.dwSize);
        SIVAL(pDataPtr,8,sInfo.dwSize);
        SIVAL(pDataPtr,16,0);
        SCVAL(pDataPtr,20,0);
        SCVAL(pDataPtr,21,(sInfo.dwAttr&SYS_DIR)? 1:0);
        break;

    case SMB_FILE_EA_INFORMATION:
    case SMB_QUERY_FILE_EA_INFO:

        iDataSize = 4;
        SIVAL(pDataPtr,0,0);
        break;

    case SMB_QUERY_FILE_ALT_NAME_INFO:

        #if SYS_HAS_SHORT_NAME
        iLen=strlen(sInfo.cShortName);
        iDataSize = 4+iLen+1;
        SIVAL(pDataPtr,0,iLen);
        memcpy(pDataPtr+4,sInfo.cShortName,iLen);
        #else
        iDataSize = 4+1;
        #endif
        break;

    case SMB_QUERY_FILE_NAME_INFO:

        iLen=strlen(sInfo.cName);
        iDataSize = 4+iLen+1;
        SIVAL(pDataPtr,0,iLen);
        memcpy(pDataPtr+4,sInfo.cName,iLen);
        break;

    case SMB_FILE_ALLOCATION_INFORMATION:
    case SMB_FILE_END_OF_FILE_INFORMATION:
    case SMB_QUERY_FILE_ALLOCATION_INFO:
    case SMB_QUERY_FILE_END_OF_FILEINFO:

        iDataSize = 8;
        SIVAL(pDataPtr,0,sInfo.dwSize);
        break;

    case SMB_QUERY_FILE_ALL_INFO:

        iLen=strlen(sInfo.cName);
        iDataSize = 100+iLen+1;
        SysTimeConvertSF(sInfo.dwTimeCreate,(SysDW*)(pDataPtr+0));
        SysTimeConvertSF(sInfo.dwTimeAccess,(SysDW*)(pDataPtr+8));
        SysTimeConvertSF(sInfo.dwTimeWrite ,(SysDW*)(pDataPtr+16));
        SysTimeConvertSF(sInfo.dwTimeWrite ,(SysDW*)(pDataPtr+24));
        SIVAL(pDataPtr,32,iMode);
        SIVAL(pDataPtr,40,sInfo.dwSize);
        SIVAL(pDataPtr,48,sInfo.dwSize);
        SIVAL(pDataPtr,56,0);
        SCVAL(pDataPtr,60,0);
        SCVAL(pDataPtr,61,(sInfo.dwAttr&SYS_DIR)? 1:0);;
        SIVAL(pDataPtr,76,(iMode&aRONLY)? 0xA9:0xD01BF);
        SIVAL(pDataPtr,80,uTell);  /* current offset */
        SIVAL(pDataPtr,88,iMode);   /* is this the right sort of iMode info? */
        SIVAL(pDataPtr,96,iLen);
        memcpy(pDataPtr+100,sInfo.cName,iLen);
        break;

    case SMB_FILE_INTERNAL_INFORMATION:

        iDataSize = 8;
        break;

    case SMB_FILE_ACCESS_INFORMATION:

        SIVAL(pDataPtr,0,0x12019F);
        iDataSize = 4;
        break;

    case SMB_FILE_NAME_INFORMATION:

        iLen=strlen(sInfo.cName);
        iDataSize = 4+iLen+1;
        SIVAL(pDataPtr,0,iLen);
        memcpy(pDataPtr+4,sInfo.cName,iLen);
        break;

    case SMB_FILE_DISPOSITION_INFORMATION:

        iDataSize = 1;
        SCVAL(pDataPtr,0,0);
        break;

    case SMB_FILE_POSITION_INFORMATION:

        iDataSize = 8;
        SIVAL(pDataPtr,0,uTell);
        break;

    case SMB_FILE_MODE_INFORMATION:

        iDataSize = 4;
        SIVAL(pDataPtr,0,iMode);
        break;

    case SMB_FILE_ALIGNMENT_INFORMATION:

        iDataSize = 4;
        SIVAL(pDataPtr,0,0);
        break;

    case SMB_FILE_ALTERNATE_NAME_INFORMATION:

        #if SYS_HAS_SHORT_NAME
        iLen=strlen(sInfo.cShortName);
        iDataSize = 4+iLen+1;
        SIVAL(pDataPtr,0,iLen);
        memcpy(pDataPtr+4,sInfo.cShortName,iLen);
        #else
        iDataSize = 4+1;
        #endif
        break;

    case SMB_FILE_COMPRESSION_INFORMATION:

        SIVAL(pDataPtr, 0,sInfo.dwSize);
        SIVAL(pDataPtr, 8,0);
        SIVAL(pDataPtr,12,0);
        iDataSize = 16;
        break;

    case SMB_FILE_NETWORK_OPEN_INFORMATION:

        SysTimeConvertSF(sInfo.dwTimeCreate,(SysDW*)(pDataPtr+0));
        SysTimeConvertSF(sInfo.dwTimeAccess,(SysDW*)(pDataPtr+8));
        SysTimeConvertSF(sInfo.dwTimeWrite ,(SysDW*)(pDataPtr+16));
        SysTimeConvertSF(sInfo.dwTimeWrite ,(SysDW*)(pDataPtr+24));
        SIVAL(pDataPtr,32,0x20);                    /* Allocation size. */
        SIVAL(pDataPtr,40,sInfo.dwSize);
        SIVAL(pDataPtr,48,iMode);
        SIVAL(pDataPtr,52,0);
        iDataSize = 56;
        break;

    case SMB_FILE_ATTRIBUTE_TAG_INFORMATION:

        SIVAL(pDataPtr,0,iMode);
        SIVAL(pDataPtr,4,0);
        iDataSize = 8;
        break;


    default:return SMB_ERROR(ERRDOS,ERRunknownlevel);
        }


    SSVAL(pParamPtr,0,0);
    SendTrans2Replies(pSession, pOut, iBuffSize, pParamPtr, 2, *pData, iDataSize);
    PRINT_SMB_MSG1((" <ok>"))


return 0;
}


//*****************************************************************************
//*
//*     Trans2QFilePathInfo
//*
//*****************************************************************************
//  Reply to a TRANS2_QFILEPATHINFO or TRANSACT2_QFILEINFO (
//  query file info by file name or file id.
static int Trans2SetFilePathInfo(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,
                                      int iBuffSize,char **pParam,char **pData)

{
char            cName[MAX_PATHNAME_SIZE];
char           *pName;
char           *pDataPtr;
char           *pParamPtr;
int             iNewSize=-1;
int             iMaxDataBytes;
int             iInfoLevel;
int             iTransCall;
int             iMode=-1;
unsigned short  wFid;
int             bError;
unsigned        dwTimeWrite=0;
unsigned        dwTimeAccess=0;
SmbFileEntry   *pFile;
SysFile         hFile;




    pDataPtr  = *pData;
    pParamPtr = *pParam;

    iMaxDataBytes = SVAL(pIn,smb_mdrcnt);
    iTransCall    = SVAL(pIn,smb_setup);




    if(iTransCall=TRANSACT2_SETFILEINFO)
        {
        wFid       = SVAL(pParamPtr,0);
        iInfoLevel = SVAL(pParamPtr,2);

            pFile  = SmbGetFile(pSession,wFid);
        if(!pFile || pFile->bType!=0)
            {
            return SMB_ERROR(ERRDOS,ERRbadfid);
            }
        }
    else{
        iInfoLevel = SVAL(pParamPtr,0);
        pName = pParamPtr+6;

        if(SmbPathName(pSession,cName,pName)<0)
            {
            PRINT_SMB_ERR(("SMB_ERROR wrong file: \"%s\"",pName))
            return SMB_ERROR(ERRDOS,ERRbadpath);
            }

        pFile=0;
        wFid=0;
        }

    if(pSession->pTree->bReadOnly)              // only read ?
        {
        return SMB_ERROR(ERRSRV,ERRaccess);
        }

//*****************************************************************************

    PRINT_SMB_MSG1((" level=%i",iInfoLevel))

    switch (iInfoLevel)
        {
    case SMB_INFO_STANDARD:
    case SMB_INFO_QUERY_EA_SIZE:

        SysTimeConvertDS(*(int*)(pDataPtr+4),&dwTimeAccess);
        SysTimeConvertDS(*(int*)(pDataPtr+8),&dwTimeWrite);
        iNewSize = IVAL(pDataPtr,12);
        iMode    = SVAL(pDataPtr,20);
        break;

    case SMB_INFO_QUERY_EAS_FROM_LIST:
    case SMB_INFO_QUERY_ALL_EAS:

        SysTimeConvertDS(*(int*)(pDataPtr+ 8),&dwTimeAccess);
        SysTimeConvertDS(*(int*)(pDataPtr+12),&dwTimeWrite);
        iNewSize = IVAL(pDataPtr,16);
        iMode    = SVAL(pDataPtr,24);
        break;

    case SMB_SET_FILE_BASIC_INFO:
    case 1004:

        SysTimeConvertFS(pDataPtr+ 8,&dwTimeAccess);
        SysTimeConvertFS(pDataPtr+16,&dwTimeWrite );
        iMode = IVAL(pDataPtr,32);
        break;

    case SMB_FILE_ALLOCATION_INFORMATION:
    case SMB_SET_FILE_ALLOCATION_INFO:
    case SMB_FILE_END_OF_FILE_INFORMATION:
    case SMB_SET_FILE_END_OF_FILE_INFO:

        iNewSize = IVAL(pDataPtr,0);
        if(IVAL(pDataPtr,4)!=0)
            {
            return SMB_ERROR(ERRDOS,ERRunknownlevel);
            }
        break;

    default:return SMB_ERROR(ERRDOS,ERRunknownlevel);
        }


//*****************************************************************************

    if(dwTimeWrite ==0xFFFFFFFF)dwTimeWrite =0;
    if(dwTimeAccess==0xFFFFFFFF)dwTimeAccess=0;

    if(pFile)                                           // handel or path
        {
        hFile=pFile->hFile;
        }
    else{
        if(iMode>=0)
        if(SysSetAttributes(cName,AttrDosToSys(iMode))<0)
            {
            return SMB_ERROR(ERRDOS,ERRaccess);
            }

        	hFile=SysOpen(cName,SYS_WRITE);
        if(!hFile)
            {
            return SMB_ERROR(ERRDOS,ERRaccess);
            }
        }


    bError=FALSE;                                       // change file

    if(dwTimeWrite||dwTimeAccess)
    if(SysSetFileTime(hFile,dwTimeWrite,0,dwTimeAccess)<0)bError=TRUE;
    if(iNewSize>=0)
    if(SysSetFileSize(hFile,iNewSize)<0)bError=TRUE;

    if(!pFile)SysClose(hFile);

    if(bError)
        {
        return SMB_ERROR(ERRDOS,ERRaccess);
        }


    SSVAL(pParamPtr,0,0);
    SendTrans2Replies(pSession, pOut, iBuffSize, pParamPtr, 2, *pData, 0);
    PRINT_SMB_MSG1((" <ok>"))



return 0;
}

//*****************************************************************************
//*
//*     Trans2FindNotifyFirst
//*
//*****************************************************************************
//  reply to a TRANS2_FINDNOTIFYFIRST
static int Trans2FindNotifyFirst(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut, int iBuffSize,char **pParam, char **pData)
{
static short    iHanlde=257;
char           *pParamPtr;
int             iInfoLevel;


    pParamPtr = *pParam;
    iInfoLevel = SVAL(pParamPtr,4);


    switch (iInfoLevel)
        {
    case 1:
    case 2: break;
    default:return SMB_ERROR(ERRDOS,ERRunknownlevel);
        }

       pParamPtr = CharRealloc(*pParam,6);
    if(pParamPtr == NULL)
        {
        return(SMB_ERROR(ERRDOS,ERRnomem));
        }
    *pParam = pParamPtr;


    SSVAL(pParamPtr,0,iHanlde);
    SSVAL(pParamPtr,2,0);
    SSVAL(pParamPtr,4,0);

    iHanlde++;

    if(iHanlde==0)iHanlde=257;

    SendTrans2Replies(pSession,pOut, iBuffSize, pParamPtr, 6, *pData, 0);
    PRINT_SMB_MSG1((" <ok>"))



return 0;
}

//*****************************************************************************
//*
//*     Trans2FindNotifyNext
//*
//*****************************************************************************
//  reply to a TRANS2_FINDNOTIFYNEXT
static int Trans2FindNotifyNext(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iBuffSize,char **pParam, char **pData)
{
char *pParamPtr = *pParam;


    pParamPtr = CharRealloc(*pParam,4);
    if(pParamPtr == NULL)
        {
        return SMB_ERROR(ERRDOS,ERRnomem);
        }
    *pParam = pParamPtr;

    SSVAL(pParamPtr,0,0);
    SSVAL(pParamPtr,2,0);

    SendTrans2Replies(pSession,pOut, iBuffSize, pParamPtr, 4, *pData, 0);
    PRINT_SMB_MSG1((" <ok>"))


return 0;
}

//*****************************************************************************
//*
//*     Trans2MakeDir
//*
//*****************************************************************************
//  reply to a TRANS2_MKDIR (make directory with extended attributes).
static int Trans2MakeDir(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut, int iBuffSize,char **pParam, char **pData)
{
char     cName[MAX_PATHNAME_SIZE];
char    *pParamPtr = *pParam;
char    *pName;




    if(pSession->pTree->bReadOnly)
        {
        return SMB_ERROR(ERRSRV,ERRaccess);
        }


    pName = pParamPtr+4;

    if(SmbPathName(pSession,cName,pName)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong path: \"%s\"",pName))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }


    if(SysMkdir(cName)<0)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong path=\"%s\"",cName))
        return SMB_ERROR(ERRDOS,ERRbadpath);
        }


    SSVAL(pParamPtr,0,0);
    SendTrans2Replies(pSession,pOut, iBuffSize, pParamPtr, 2, *pData, 0);
    PRINT_SMB_MSG1((" path=\"%s\" <ok>",cName))



return 0;
}


//*****************************************************************************
//*
//*     ReplyFindClose
//*
//*****************************************************************************
//  reply to a SMBfindclose
//  stop trans2 directory search.
int ReplyFindClose(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int iOutsize;


    if(pSession->pFile->bType!=1)
        {
        PRINT_SMB_ERR(("SMB_ERROR wrong FID type"))
        return SMB_ERROR(ERRSRV,ERRinvnid);
        }

    PRINT_SMB_MSG1((" FID=%i <ok>",pSession->wFid))
    SmbClearFile(pSession,pSession->wFid);
    iOutsize = SmbSetMessage(pOut,0,0,FALSE);


return  iOutsize;
}

//*****************************************************************************
//*
//*     ReplyFindNClose
//*
//*****************************************************************************
//  Reply to a SMBfindnclose (stop FINDNOTIFYFIRST directory search).
int ReplyFindNClose(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
int iOutsize;


    PRINT_SMB_MSG1((" <ok>"))
    iOutsize = SmbSetMessage(pOut,0,0,FALSE);


return iOutsize;
}

//*****************************************************************************
//*
//*     ReplyTranss2
//*
//*****************************************************************************
//  Reply to a SMBtranss2 - just ignore it!
int ReplyTranss2(SmbSession *pSession,unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)
{
    return 0;
}

//*****************************************************************************
//*
//*     ReplyTrans2
//*
//*****************************************************************************
//  reply to a SMBtrans2
int ReplyTrans2(SmbSession *pSession, unsigned char *pIn,unsigned char *pOut,int iSize,int iBuffSize)

{
int             iRet;
int             iFlags;
int             iOutsize;
int             iTotalParam;
int             iTotalData;
int             iMaxParamReply;
int             iMaxDataReply;
int             iMaxSeupReply;
int             iTotalSetup;
int             iTransCall;
int             iNumParam;
int             iNumData;
int             iNumParamSofar;
int             iNumDataSofar;
int             iTimeout;
int             bCloseTid;
int             bNoFinalResponse;
char           *pParam=NULL,*pData=NULL;
SmbTreeEntry   *pTree;



    iTotalParam     = SVAL(pIn, smb_tpscnt);
    iTotalData      = SVAL(pIn, smb_tdscnt);
    iTotalSetup     = SVAL(pIn, smb_suwcnt);
    iMaxParamReply  = SVAL(pIn, smb_mprcnt);
    iMaxDataReply   = SVAL(pIn, smb_mdrcnt);
    iMaxSeupReply   = SVAL(pIn, smb_msrcnt);
    iFlags          = SVAL(pIn, smb_flags );
    iTimeout        = IVAL(pIn, smb_timeout);
    iTransCall      = SVAL(pIn, smb_setup );

    bCloseTid       = iFlags&1;
    bNoFinalResponse= iFlags&2;


    pTree=pSession->pTree;


    if(pTree->iConnectType==1     &&
       iTransCall!=TRANSACT2_OPEN &&
       iTransCall!=TRANSACT2_GET_DFS_REFERRAL)
        {
        return SMB_ERROR(ERRSRV,ERRaccess);
        }

    iOutsize = SmbSetMessage(pOut,0,0,FALSE);

    if(iTotalSetup!=1)
        {
        return SMB_ERROR(ERRSRV,ERRerror);
        }


    if(iTotalParam>0)pParam = (char*)SmbAlloc(iTotalParam);
    if(iTotalData >0)pData  = (char*)SmbAlloc(iTotalData);

    if((iTotalParam && !pParam) || (iTotalData && !pData))
        {
        PRINT_SMB_ERRS(("SYSERROR out of memmory"))
        if(pParam)SmbFree(pParam);
        if(pData )SmbFree(pData);
        return SMB_ERROR(ERRDOS,ERRnomem);
        }

    iNumParam = iNumParamSofar = SVAL(pIn,smb_pscnt);
    iNumData  = iNumDataSofar  = SVAL(pIn,smb_dscnt);

    if(iNumParam>iTotalParam || iNumData>iTotalData)
        {
        PRINT_SMB_ERRS(("SYSERROR wrong parameter"))
        if(pParam)SmbFree(pParam);
        if(pData )SmbFree(pData);
        SmbSessionExit(pSession);
		return -1;
        }

    if(pParam)memcpy(pParam, smb_base(pIn)+SVAL(pIn,smb_psoff), iNumParam);
    if(pData )memcpy(pData , smb_base(pIn)+SVAL(pIn,smb_dsoff), iNumData);


//*****************************************************************************

    if(iNumDataSofar<iTotalData || iNumParamSofar<iTotalParam)
        {
        iOutsize = SmbSetMessage(pOut,0,0,FALSE);

        if(!TcpPut(pSession->hTcp,pOut,iOutsize))   // send interim message
            {
            PRINT_SMB_ERRS(("\nSMB SYSERROR  ReplyTrans2: send_smb failed."))
            if(pParam)SmbFree(pParam);
            if(pData )SmbFree(pData);
            SmbSessionExit(pSession);
			return -1;
            }

        while(iNumDataSofar<iTotalData || iNumParamSofar<iTotalParam)
            {
            iRet = SmbReadNextPacket(pSession->hTcp,pIn,pSession->iMaxResvSize,SMB_SECONDARY_WAIT);

            if(iRet<=0 || CVAL(pIn,smb_com)!=SMBtranss2)
                {
                iOutsize = SmbSetMessage(pOut,0,0,FALSE);
                PRINT_SMB_ERR(("\nERROR wrong ReplyTranss2 message"))

                if(pParam)SmbFree(pParam);
                if(pData )SmbFree(pData);

                return SMB_ERROR(ERRSRV,ERRerror);
                }

            pSession->iPacketCount++;

            /* Revise iTotalParam and iTotalData in case they have changed downwards */
            iTotalParam = SVAL(pIn, smb_tpscnt);
            iTotalData  = SVAL(pIn, smb_tdscnt);
            iNumParam   = SVAL(pIn, smb_spscnt);
            iNumData    = SVAL(pIn, smb_sdscnt);
            iNumParamSofar += iNumParam;
            iNumDataSofar  += iNumData;

            if(iNumParamSofar>iTotalParam || iNumDataSofar>iTotalData)
                {
                PRINT_SMB_ERRS(("\nSMB SYSERROR  overflow in in trans2"))
                if(pParam)SmbFree(pParam);
                if(pData )SmbFree(pData);
                SmbSessionExit(pSession);
				return -1;
                }

            memcpy(&pParam[SVAL(pIn,smb_spsdisp)],smb_base(pIn)+SVAL(pIn,smb_spsoff),iNumParam);
            memcpy(&pData [SVAL(pIn,smb_sdsdisp)],smb_base(pIn)+SVAL(pIn,smb_sdsoff),iNumData);
            }
        }

//*****************************************************************************

    if(pSession->iProtocol>=PROTOCOL_NT1)
        {
        SVAL(pOut,smb_flg2)|=0x40;
        }


    switch(iTransCall)
        {
    case TRANSACT2_OPEN:

        PRINT_SMB_MSG1((" \"OPEN\""))
        iOutsize = Trans2Open(pSession,pIn, pOut, iBuffSize,&pParam, &pData);
        break;

    case TRANSACT2_FINDFIRST:

        PRINT_SMB_MSG1((" \"FINDFIRST\""))
        iOutsize = Trans2FindFirst(pSession, pIn, pOut, iBuffSize, &pParam, &pData);
        break;

    case TRANSACT2_FINDNEXT:

        PRINT_SMB_MSG1((" \"FINDNEXT\""))
        iOutsize = Trans2FindNext(pSession, pIn, pOut, iBuffSize, &pParam, &pData);
        break;

    case TRANSACT2_QFSINFO:

        PRINT_SMB_MSG1((" \"QFSINFO\""))
        iOutsize = Trans2QFsInfo(pSession, pIn, pOut, iBuffSize, &pParam, &pData);
        break;

    case TRANSACT2_SETFSINFO:

        PRINT_SMB_MSG1((" \"SETFSINFO\""))
        iOutsize = Trans2SetFsInfo(pSession, pIn, pOut, iBuffSize, &pParam, &pData);
        break;

    case TRANSACT2_QPATHINFO:

        PRINT_SMB_MSG1((" \"QPATHINFO\""))
        iOutsize = Trans2QFilePathInfo(pSession, pIn, pOut, iBuffSize, &pParam, &pData);
        break;

    case TRANSACT2_QFILEINFO:

        PRINT_SMB_MSG1((" \"QFILEINFO\""))
        iOutsize = Trans2QFilePathInfo(pSession, pIn, pOut, iBuffSize, &pParam, &pData);
        break;

    case TRANSACT2_SETPATHINFO:

        PRINT_SMB_MSG1((" \"SETPATHINFO\""))
        iOutsize = Trans2SetFilePathInfo(pSession, pIn, pOut,iBuffSize, &pParam, &pData);
        break;

    case TRANSACT2_SETFILEINFO:

        PRINT_SMB_MSG1((" \"SETFILEINFO\""))
        iOutsize = Trans2SetFilePathInfo(pSession, pIn, pOut,iBuffSize, &pParam, &pData);
        break;

    case TRANSACT2_FINDNOTIFYFIRST:

        PRINT_SMB_MSG1((" \"FINDNOTIFYFIRST\""))
        iOutsize = Trans2FindNotifyFirst(pSession, pIn, pOut,iBuffSize, &pParam, &pData);
        break;

    case TRANSACT2_FINDNOTIFYNEXT:

        PRINT_SMB_MSG1((" \"FINDNOTIFYNEXT\""))
        iOutsize = Trans2FindNotifyNext(pSession, pIn, pOut,iBuffSize, &pParam, &pData);
        break;

    case TRANSACT2_MKDIR:

        PRINT_SMB_MSG1((" \"MKDIR\""))
        iOutsize = Trans2MakeDir(pSession, pIn, pOut, iBuffSize, &pParam, &pData);
        break;

    default:

        PRINT_SMB_ERR(("\nERROR Unknown request %02Xh in trans2 call\n",iTransCall));
        if(pParam)SmbFree(pParam);
        if(pData )SmbFree(pData);

        return SMB_ERROR(ERRSRV,ERRerror);
        }


    if(pParam)SmbFree(pParam);
    if(pData )SmbFree(pData);



return iOutsize;
}
