//*****************************************************************************
//*
//*
//*     BitUtility.h
//*
//*
//*****************************************************************************
#ifndef __BITUTILITY_H__
#define __BITUTILITY_H__


//if  defined(__GNUC__)
//#if !defined(SMB_NO_ASM)
//#if !defined(__i386__) && !defined(__x86_64__)
//#warning    "CPU not x86 - not using assembler"
//#define     SMB_NO_ASM
//#endif
//#endif 
//#endif 



       int bit_set        (      void *pMem,int iOffset);
       int bit_clear      (      void *pMem,int iOffset);
       int bit_read       (const void *pMem,int iOffset);
       int bit_find_0_next(const void *pMem,unsigned uSize,unsigned uOffset);
       int bit_find_1_next(const void *pMem,unsigned uSize,unsigned uOffset);
inline int bit_find_0     (const void *pMem,unsigned uSize                 ){return bit_find_0_next(pMem,uSize,0);}
inline int bit_find_1     (const void *pMem,unsigned uSize                 ){return bit_find_1_next(pMem,uSize,0);}



/*
#ifdef  linux
#ifndef LINUX
#define LINUX   1
#endif
#endif




//*****************************************************************************
//*
//*
//*     LINUX functions
//*
//*
//*****************************************************************************
#if defined(LINUX) && !defined(SMB_NO_ASM)


#if !defined(__i386__) && !defined(__x86_64__)
#error  Error wrong CPU type
#endif



//*****************************************************************************
//*
//*     bit_set
//*
//*****************************************************************************
//  sets a bit in a memory area
//  pMem    : pointer to the memory area
//  iBit    : is the bit offest in the memory area
//  returns -1 if the bit was set, or 0 if it wan't set.
static __inline int bit_set(void *pMem,int iBit)
{
int iRet;


    #ifdef  __i386__

    asm volatile (
        "movl      %1   ,%%eax  \n"
        "lock bts  %2,  (%%eax) \n"
        "sbb       %%eax,%%eax  \n"
        : "=a" (iRet)
        : "m"  (pMem) , "c" (iBit)
        );

    #else

    asm volatile (
        "movl      %1   ,%%rax  \n"
        "lock bts  %2,  (%%rax) \n"
        "sbb       %%eax,%%eax  \n"
        : "=a" (iRet)
        : "m"  (pMem) , "c" (iBit)
        );

    #endif


return  iRet;
}


//*****************************************************************************
//*
//*     bit_clear
//*
//*****************************************************************************
//  clears a bit in a memory area
//  pMem    : pointer to the memory area
//  iBit    : is the bit offest in the memory area
//  returns -1 if the bit was set, or 0 if it wan't set.
static __inline int bit_clear(void *pMem,int iBit)
{
int iRet;


    #ifdef  __i386__

    asm volatile (
        "movl      %1   ,%%eax  \n"
        "lock btr  %2,  (%%eax) \n"
        "sbb       %%eax,%%eax  \n"
        : "=a" (iRet)
        : "m"  (pMem) , "c" (iBit)
        );

    #else

    asm volatile (
        "movl      %1   ,%%rax  \n"
        "lock btr  %2,  (%%rax) \n"
        "sbb       %%eax,%%eax  \n"
        : "=a" (iRet)
        : "m"  (pMem) , "c" (iBit)
        );

    #endif


return  iRet;
}




//*****************************************************************************
//*
//*     bit_read
//*
//*****************************************************************************
//  reads a bit from a memory area
//  pMem    : pointer to the memory area
//  iBit    : is the bit offest in the memory area
//  returns -1 if the bit was set, or 0 if it wan't set.
static __inline int bit_read(const void *pMem,int iBit)
{
int iRet;


    #ifdef  __i386__

    asm volatile (
        "movl      %1   ,%%eax  \n"
        "bt        %2,  (%%eax) \n"
        "sbb       %%eax,%%eax  \n"
        : "=a" (iRet)
        : "m"  (pMem) , "c" (iBit)
        );

    #else

    asm volatile (
        "movl      %1   ,%%rax  \n"
        "bt        %2,  (%%rax) \n"
        "sbb       %%eax,%%eax  \n"
        : "=a" (iRet)
        : "m"  (pMem) , "c" (iBit)
        );

    #endif


return  iRet;
}


//*****************************************************************************
//*
//*     bit_find_0
//*
//*****************************************************************************
//  seaches for an 0 bit in a memory area
//  pMem    : pointer to the memory area
//  uSize   : is the size of the memory area in bits
//  returns the founded bit position or the area size
static __inline int bit_find_0(const void *pAddr, unsigned uSize)
{
int     iRet;



    #ifdef  __i386__

    asm volatile(
        "xorl   %%eax,%%eax     \n"
        "jmp    2f              \n"
        "1:                     \n"
        "addl   $4   ,%%ebx     \n"
        "addl   $32  ,%%eax     \n"
        "2:                     \n"
        "cmpl   %%edi,%%eax     \n"
        "jnb    3f              \n"
        "movl   (%%ebx),%%esi   \n"
        "notl   %%esi           \n"
        "bsfl   %%esi,%%ecx     \n"
        "jz     1b              \n"
        "add    %%ecx,%%eax     \n"
        "cmpl   %%edi,%%eax     \n"
        "jbe    4f              \n"
        "3:                     \n"
        "movl   %%edi,%%eax     \n"
        "4:                     \n"
        :"=a" (iRet)
        :"b" (pAddr), "D" (uSize)
        :"ecx","esi"
        );

    #else

    asm volatile(
        "xorl   %%eax,%%eax     \n"
        "jmp    2f              \n"
        "1:                     \n"
        "addq   $8   ,%%rbx     \n"
        "addl   $64  ,%%eax     \n"
        "2:                     \n"
        "cmpl   %%edi,%%eax     \n"
        "jnb    3f              \n"
        "movq   (%%rbx),%%rsi   \n"
        "notq   %%rsi           \n"
        "bsfl   %%rsi,%%rcx     \n"
        "jz     1b              \n"
        "add    %%ecx,%%eax     \n"
        "cmpl   %%edi,%%eax     \n"
        "jbe    4f              \n"
        "3:                     \n"
        "movl   %%edi,%%eax     \n"
        "4:                     \n"
        :"=a" (iRet)
        :"b" (pAddr), "D" (uSize)
        :"rcx","rsi"
        );

    #endif


    return iRet;

}



//*****************************************************************************
//*
//*     bit_find_0_next
//*
//*****************************************************************************
//  seaches for an 0 bit in a memory area
//  pMem    : pointer to the memory area
//  uSize   : is the size of the memory area in bits
//  uOffset : is the bit in the memory area where the seach beginns
//  returns the founded bit position or the area size
static __inline int bit_find_0_next(const void *pAddr,unsigned uSize,unsigned uOffset)
{
int     iRet;


    #ifdef  __i386__

    asm volatile(
        "movl   %%ebx,%%ecx     \n"
        "movl   %%ebx,%%eax     \n"
        "shrl   $5   ,%%ebx     \n"
        "andb   $31  ,%%cl      \n"
        "shll   $2   ,%%ebx     \n"
        "subb   %%cl ,%%al      \n"
        "addl   %1   ,%%ebx     \n"
        "cmpl   %%edi,%%eax     \n"
        "jnb    3f              \n"
        "movl   (%%ebx),%%esi   \n"
        "notl   %%esi           \n"
        "shrl   %%cl ,%%esi     \n"
        "shll   %%cl ,%%esi     \n"
        "bsfl   %%esi,%%ecx     \n"
        "jmp    2f              \n"
        "1:                     \n"
        "addl   $4   ,%%ebx     \n"
        "addl   $32  ,%%eax     \n"
        "cmpl   %%edi,%%eax     \n"
        "jnb    3f              \n"
        "movl   (%%ebx),%%esi   \n"
        "notl   %%esi           \n"
        "bsfl   %%esi,%%ecx     \n"
        "2:                     \n"
        "jz     1b              \n"
        "addl   %%ecx,%%eax     \n"
        "cmpl   %%edi,%%eax     \n"
        "jbe    4f              \n"
        "3:                     \n"
        "movl   %%edi,%%eax     \n"
        "4:                     \n"
        :"=a" (iRet)
        :"m" (pAddr), "D" (uSize), "b" (uOffset)
        :"ecx","esi"
        );

    #else

    asm volatile(
        "movl   %%ebx,%%ecx     \n"
        "movl   %%ebx,%%eax     \n"
        "shrl   $6   ,%%ebx     \n"
        "andb   $63  ,%%cl      \n"
        "shll   $3   ,%%ebx     \n"
        "subb   %%cl ,%%al      \n"
        "andq $0xFFFFFFFF,%%rbx \n"
        "addq   %1   ,%%rbx     \n"
        "cmpl   %%edi,%%eax     \n"
        "jnb    3f              \n"
        "movq   (%%rbx),%%rsi   \n"
        "notq   %%rsi           \n"
        "shrq   %%cl ,%%rsi     \n"
        "shlq   %%cl ,%%rsi     \n"
        "bsfq   %%rsi,%%ecx     \n"
        "jmp    2f              \n"
        "1:                     \n"
        "addq   $8   ,%%rbx     \n"
        "addl   $64  ,%%eax     \n"
        "cmpl   %%edi,%%eax     \n"
        "jnb    3f              \n"
        "movq   (%%rbx),%%rsi   \n"
        "notq   %%rsi           \n"
        "bsfq   %%rsi,%%rcx     \n"
        "2:                     \n"
        "jz     1b              \n"
        "addl   %%ecx,%%eax     \n"
        "cmpl   %%edi,%%eax     \n"
        "jbe    4f              \n"
        "3:                     \n"
        "movl   %%edi,%%eax     \n"
        "4:                     \n"
        :"=a" (iRet)
        :"m" (pAddr), "D" (uSize), "b" (uOffset)
        :"rcx","rsi"
        );

    #endif


    return iRet;

}


//*****************************************************************************
//*
//*     bit_find_1
//*
//*****************************************************************************
//  seaches for an 1 bit in a memory area
//  pMem    : pointer to the memory area
//  uSize   : is the size of the memory area in bits
//  returns the founded bit position or the area size
static __inline int bit_find_1(const void *pAddr, unsigned uSize)
{
int     iRet;


    #ifdef  __i386__


    asm volatile(
        "xorl   %%eax,%%eax     \n"
        "jmp    2f              \n"
        "1:                     \n"
        "addl   $4   ,%%ebx     \n"
        "addl   $32  ,%%eax     \n"
        "2:                     \n"
        "cmpl   %%edi,%%eax     \n"
        "jnb    3f              \n"
        "bsfl   (%%ebx),%%ecx   \n"
        "jz     1b              \n"
        "add    %%ecx,%%eax     \n"
        "cmpl   %%edi,%%eax     \n"
        "jbe    4f              \n"
        "3:                     \n"
        "movl   %%edi,%%eax     \n"
        "4:                     \n"
        :"=a" (iRet)
        :"b" (pAddr), "D" (uSize)
        :"ecx"
        );

    #else

    asm volatile(
        "xorl   %%eax,%%eax     \n"
        "jmp    2f              \n"
        "1:                     \n"
        "addq   $8   ,%%rbx     \n"
        "addl   $64  ,%%eax     \n"
        "2:                     \n"
        "cmpl   %%edi,%%eax     \n"
        "jnb    3f              \n"
        "bsfl   (%%rbx),%%rcx   \n"
        "jz     1b              \n"
        "add    %%ecx,%%eax     \n"
        "cmpl   %%edi,%%eax     \n"
        "jbe    4f              \n"
        "3:                     \n"
        "movl   %%edi,%%eax     \n"
        "4:                     \n"
        :"=a" (iRet)
        :"b" (pAddr), "D" (uSize)
        :"ecx"
        );

    #endif


    return iRet;

}


//*****************************************************************************
//*
//*     bit_find_1_next
//*
//*****************************************************************************
//  seaches for an 1 bit in a memory area
//  pMem    : pointer to the memory area
//  uSize   : is the size of the memory area in bits
//  uOffset : is the bit in the memory area where the seach beginns
//  returns the founded bit position or the area size
static __inline int bit_find_1_next(const void *pAddr, unsigned uSize,unsigned uOffset)
{
int     iRet;


    #ifdef  __i386__

    asm volatile(
        "movl   %%ebx,%%ecx     \n"
        "movl   %%ebx,%%eax     \n"
        "shrl   $5   ,%%ebx     \n"
        "andb   $31  ,%%cl      \n"
        "shll   $2   ,%%ebx     \n"
        "subb   %%cl ,%%al      \n"
        "addl   %1   ,%%ebx     \n"
        "cmpl   %%edi,%%eax     \n"
        "jnb    3f              \n"
        "movl   (%%ebx),%%esi   \n"
        "shrl   %%cl ,%%esi     \n"
        "shll   %%cl ,%%esi     \n"
        "bsfl   %%esi,%%ecx     \n"
        "jmp    2f              \n"
        "1:                     \n"
        "addl   $4   ,%%ebx     \n"
        "addl   $32  ,%%eax     \n"
        "cmpl   %%edi,%%eax     \n"
        "jnb    3f              \n"
        "bsfl   (%%ebx),%%ecx   \n"
        "2:                     \n"
        "jz     1f              \n"
        "addl   %%ecx,%%eax     \n"
        "cmpl   %%edi,%%eax     \n"
        "jbe    4f              \n"
        "3:                     \n"
        "movl   %%edi,%%eax     \n"
        "4:                     \n"
        :"=a" (iRet)
        :"m" (pAddr), "D" (uSize), "b" (uOffset)
        :"ecx","esi"
        );

    #else

    asm volatile(
        "movl   %%ebx,%%ecx     \n"
        "movl   %%ebx,%%eax     \n"
        "shrl   $6   ,%%ebx     \n"
        "andb   $63  ,%%cl      \n"
        "shll   $3   ,%%ebx     \n"
        "subb   %%cl ,%%al      \n"
        "andq $0xFFFFFFFF,%%rbx \n"
        "addq   %1   ,%%rbx     \n"
        "cmpl   %%edi,%%eax     \n"
        "jnb    3f              \n"
        "movq   (%%rbx),%%rsi   \n"
        "shrq   %%cl ,%%rsi     \n"
        "shlq   %%cl ,%%rsi     \n"
        "bsfq   %%rsi,%%rcx     \n"
        "jmp    2f              \n"
        "1:                     \n"
        "addq   $8   ,%%rbx     \n"
        "addl   $64  ,%%eax     \n"
        "cmpl   %%edi,%%eax     \n"
        "jnb    3f              \n"
        "bsfq   (%%rbx),%%rcx   \n"
        "2:                     \n"
        "jz     1f              \n"
        "addl   %%ecx,%%eax     \n"
        "cmpl   %%edi,%%eax     \n"
        "jbe    4f              \n"
        "3:                     \n"
        "movl   %%edi,%%eax     \n"
        "4:                     \n"
        :"=a" (iRet)
        :"m" (pAddr), "D" (uSize), "b" (uOffset)
        :"rcx","rsi"
        );

    #endif


return iRet;
}



#endif




#if  defined(_WIN32) || defined(_WIN64)
#if !defined(SMB_NO_ASM)

#if _MSC_VER >= 1000
#pragma once
#endif

#ifdef  _MSC_VER
#pragma warning( disable :4035 )
#endif



//*****************************************************************************
//*
//*     bit_set
//*
//*****************************************************************************
//  sets a bit in a memory area
//  pMem    : pointer to the memory area
//  iBit    : is the bit offest in the memory area
//  returns -1 if the bit was set, or 0 if it wan't set.
static __inline int bit_set(void *pMem,int iBit)
{

    #ifndef _WIN64

    _asm{
        mov  eax,pMem
        mov  ebx,iBit
        lock bts [eax],ebx
        sbb  eax,eax
        }

    #else

    _asm{
        mov  rax,pMem
        mov  ebx,iBit
        lock bts [rax],ebx
        sbb  eax,eax
        }

    #endif

}

//*****************************************************************************
//*
//*     bit_clear
//*
//*****************************************************************************
//  clears a bit in a memory area
//  pMem    : pointer to the memory area
//  iBit    : is the bit offest in the memory area
//  returns -1 if the bit was set, or 0 if it wan't set.
static __inline int bit_clear(void *pMem,int iBit)
{

    #ifndef _WIN64

    _asm{
        mov  eax,pMem
        mov  ebx,iBit
        lock btr [eax],ebx
        sbb  eax,eax
        }

    #else

    _asm{
        mov  rax,pMem
        mov  ebx,iBit
        lock btr [rax],ebx
        sbb  eax,eax
        }

    #endif

}

//*****************************************************************************
//*
//*     bit_read
//*
//*****************************************************************************
//  reads a bit from a memory area
//  pMem    : pointer to the memory area
//  iBit    : is the bit offest in the memory area
//  returns -1 if the bit was set, or 0 if it wan't set.
static __inline int bit_read(const void *pMem,int iBit)
{
    #ifndef _WIN64

    _asm{
        mov     eax,pMem
        mov     ebx,iBit
        bt      [eax],ebx
        sbb     eax,eax
        }

    #else

    _asm{
        mov     rax,pMem
        mov     ebx,iBit
        bt      [rax],ebx
        sbb     eax,eax
        }

    #endif
}






//*****************************************************************************
//*
//*     bit_find_0
//*
//*****************************************************************************
//  seaches for an 0 bit in a memory area
//  pMem    : pointer to the memory area
//  uSize   : is the size of the memory area in bits
//  returns the founded bit position or the area size
static __inline int bit_find_0(const void *pAddr, unsigned uSize)
{

    #ifndef _WIN64

    _asm{
        mov     ebx,pAddr       ;EBX = Adresse
        xor     eax,eax         ;EAX = Position
        mov     edi,uSize       ;EDI = Anzahl
        jmp     start1

    loop1:
        add     ebx,4           ;Die nchsten 32-Bit
        add     eax,32          ;       *
    start1:
        cmp     eax,edi         ;       *
        jnb     end0a           ;berlauf ?

        mov     esi,[ebx]       ;32-Bit laden
        not     esi             ;Invertieren
        bsf     ecx,esi         ;Suche Bit
        jz      loop1           ;       *

        add     eax,ecx         ;Ergebnis berechen
        cmp     eax,edi         ;       *
        jbe     end0b
    end0a:
        mov     eax,edi         ;berlauf
    end0b:
        }

    #else

    _asm{
        mov     rbx,pAddr       ;EBX = Adresse
        xor     eax,eax         ;EAX = Position
        mov     edi,uSize       ;EDI = Anzahl
        jmp     start1

    loop1:
        add     rbx,8           ;Die nchsten 32-Bit
        add     eax,64          ;       *
    start1:
        cmp     eax,edi         ;       *
        jnb     end0a           ;berlauf ?

        mov     rsi,[rbx]       ;32-Bit laden
        not     rsi             ;Invertieren
        bsf     rcx,rsi         ;Suche Bit
        jz      loop1           ;       *

        add     eax,ecx         ;Ergebnis berechen
        cmp     eax,edi         ;       *
        jbe     end0b
    end0a:
        mov     eax,edi         ;berlauf
    end0b:
        }

    #endif

}

//*****************************************************************************
//*
//*     bit_find_0_next
//*
//*****************************************************************************
//  seaches for an 0 bit in a memory area
//  pMem    : pointer to the memory area
//  uSize   : is the size of the memory area in bits
//  uOffset : is the bit in the memory area where the seach beginns
//  returns the founded bit position or the area size
static __inline int bit_find_0_next(const void *pAddr,unsigned uSize,unsigned uOffset)
{

    #ifndef _WIN64

    _asm{
        mov     ebx,uOffset     ;Offset laden
        mov     ecx,ebx         ;       *
        mov     eax,ebx         ;       *

        shr     ebx,5           ;EDI = Byte-Offset vom Start-Bit
        and     cl, 1Fh         ;ESI = Start-Bit    auf 32 gerundet
        mov     edi,uSize       ;EDI = Bit-Anzahl
        shl     ebx,2           ;EDI = Byte-Offset vom Start-Bit
        sub     al ,cl          ;EAX = Bit-Position auf 32 gerundet
        add     ebx,pAddr       ;EBX = Byte-Adresse

        cmp     eax,edi         ;berlauf ?
        jnb     end0a           ;       *
        mov     esi,[ebx]       ;Die ersten 32-Bit laden
        not     esi             ;       *
        shr     esi,cl          ;       *
        shl     esi,cl          ;       *
        bsf     ecx,esi         ;Suche Bit
        jmp     start1          ;       *

    loop1:
        add     ebx,4           ;Die nchsten 32-Bit
        add     eax,32          ;   *
        cmp     eax,edi         ;   *
        jnb     end0a           ;berlauf ?
        mov     esi,[ebx]       ;Suche Bit
        not     esi             ;       *
        bsf     ecx,esi         ;Suche Bit
    start1:
        jz      loop1

        add     eax,ecx         ;Ergebnis berechen
        cmp     eax,edi         ;   *
        jbe     end0b           ;Gab es einen berlauf

    end0a:
        mov     eax,edi         ;berlauf
    end0b:
        }

    #else

    _asm{
        mov     ebx,uOffset     ;Offset laden
        mov     ecx,ebx         ;       *
        mov     eax,ebx         ;       *

        shr     ebx,6           ;EDI = Byte-Offset vom Start-Bit
        and     cl, 3Fh         ;ESI = Start-Bit    auf 32 gerundet
        mov     edi,uSize       ;EDI = Bit-Anzahl
        shl     ebx,3           ;EDI = Byte-Offset vom Start-Bit
        sub     al ,cl          ;EAX = Bit-Position auf 32 gerundet
        anl     rbx,0FFFFFFFFh  ;       *
        add     rbx,pAddr       ;EBX = Byte-Adresse

        cmp     eax,edi         ;berlauf ?
        jnb     end0a           ;       *
        mov     rsi,[rbx]       ;Die ersten 32-Bit laden
        not     rsi             ;       *
        shr     rsi,cl          ;       *
        shl     rsi,cl          ;       *
        bsf     rcx,rsi         ;Suche Bit
        jmp     start1          ;       *

    loop1:
        add     rbx,8           ;Die nchsten 32-Bit
        add     eax,64          ;   *
        cmp     eax,edi         ;   *
        jnb     end0a           ;berlauf ?
        mov     rsi,[rbx]       ;Suche Bit
        not     rsi             ;       *
        bsf     rcx,rsi         ;Suche Bit
    start1:
        jz      loop1

        add     eax,ecx         ;Ergebnis berechen
        cmp     eax,edi         ;   *
        jbe     end0b           ;Gab es einen berlauf

    end0a:
        mov     eax,edi         ;berlauf
    end0b:
        }

    #endif
}

//*****************************************************************************
//*
//*     bit_find_1
//*
//*****************************************************************************
//  seaches for an 1 bit in a memory area
//  pMem    : pointer to the memory area
//  uSize   : is the size of the memory area in bits
//  returns the founded bit position or the area size
static __inline int bit_find_1(const void *pAddr, unsigned uSize)
{

    #ifndef _WIN64

    _asm{
        mov     ebx,pAddr       ;EBX = Adresse
        xor     eax,eax         ;EAX = Position
        mov     edi,uSize       ;EDI = Anzahl
        jmp     start1

    loop1:
        add     ebx,4           ;Die nchsten 32-Bit
        add     eax,32          ;       *
    start1:
        cmp     eax,edi         ;       *
        jnb     end0a           ;berlauf ?
        bsf     ecx,[ebx]       ;Suche Bit
        jz      loop1           ;       *

        add     eax,ecx         ;Ergebnis berechen
        cmp     eax,edi         ;       *
        jbe     end0b
    end0a:
        mov     eax,edi         ;berlauf
    end0b:
        }

    #else

    _asm{
        mov     rbx,pAddr       ;EBX = Adresse
        xor     eax,eax         ;EAX = Position
        mov     edi,uSize       ;EDI = Anzahl
        jmp     start1

    loop1:
        add     rbx,8           ;Die nchsten 32-Bit
        add     eax,64          ;       *
    start1:
        cmp     eax,edi         ;       *
        jnb     end0a           ;berlauf ?
        bsf     rcx,[rbx]       ;Suche Bit
        jz      loop1           ;       *

        add     eax,ecx         ;Ergebnis berechen
        cmp     eax,edi         ;       *
        jbe     end0b
    end0a:
        mov     eax,edi         ;berlauf
    end0b:
        }

    #endif
}

//*****************************************************************************
//*
//*     bit_find_1_next
//*
//*****************************************************************************
//  seaches for an 1 bit in a memory area
//  pMem    : pointer to the memory area
//  uSize   : is the size of the memory area in bits
//  uOffset : is the bit in the memory area where the seach beginns
//  returns the founded bit position or the area size
static __inline int bit_find_1_next(const void *pAddr,unsigned uSize,unsigned uOffset)
{

    #ifndef _WIN64

    _asm{
        mov     ebx,uOffset     ;Offset laden
        mov     ecx,ebx         ;       *
        mov     eax,ebx         ;       *

        shr     ebx,5           ;EDI = Byte-Offset vom Start-Bit
        and     cl ,1Fh         ;ESI = Start-Bit    auf 32 gerundet
        mov     edi,uSize       ;EDI = Bit-Anzahl
        shl     ebx,2           ;EDI = Byte-Offset vom Start-Bit
        sub     al ,cl          ;EAX = Bit-Position auf 32 gerundet
        add     ebx,pAddr       ;EBX = Byte-Adresse

        cmp     eax,edi         ;berlauf ?
        jnb     end0a           ;       *
        mov     esi,[ebx]       ;Die ersten 32-Bit laden
        shr     esi,cl          ;       *
        shl     esi,cl          ;       *
        bsf     ecx,esi         ;Suche Bit
        jmp     start1          ;       *

    loop1:
        add     ebx,4           ;Die nchsten 32-Bit
        add     eax,32          ;   *
        cmp     eax,edi         ;   *
        jnb     end0a           ;berlauf ?
        bsf     ecx,[ebx]       ;Suche Bit
    start1:
        jz      loop1

        add     eax,ecx         ;Ergebnis berechen
        cmp     eax,edi         ;   *
        jbe     end0b           ;Gab es einen berlauf

    end0a:
        mov     eax,edi         ;berlauf
    end0b:
        }

    #else

    _asm{
        mov     ebx,uOffset     ;Offset laden
        mov     ecx,ebx         ;       *
        mov     eax,ebx         ;       *

        shr     ebx,6           ;EDI = Byte-Offset vom Start-Bit
        and     cl ,3Fh         ;ESI = Start-Bit    auf 32 gerundet
        mov     edi,uSize       ;EDI = Bit-Anzahl
        shl     ebx,3           ;EDI = Byte-Offset vom Start-Bit
        anl     rbx,0FFFFFFFFh  ;       *
        sub     al ,cl          ;EAX = Bit-Position auf 32 gerundet
        add     rbx,pAddr       ;EBX = Byte-Adresse

        cmp     eax,edi         ;berlauf ?
        jnb     end0a           ;       *
        mov     rsi,[rbx]       ;Die ersten 32-Bit laden
        shr     rsi,cl          ;       *
        shl     rsi,cl          ;       *
        bsf     rcx,rsi         ;Suche Bit
        jmp     start1          ;       *

    loop1:
        add     rbx,8           ;Die nchsten 32-Bit
        add     eax,64          ;   *
        cmp     eax,edi         ;   *
        jnb     end0a           ;berlauf ?
        bsf     rcx,[rbx]       ;Suche Bit
    start1:
        jz      loop1

        add     eax,ecx         ;Ergebnis berechen
        cmp     eax,edi         ;   *
        jbe     end0b           ;Gab es einen berlauf

    end0a:
        mov     eax,edi         ;berlauf
    end0b:
        }

    #endif
}



#ifdef  _MSC_VER
#pragma warning( default :4035 )
#endif

#endif
#endif



*/
#endif

