//*****************************************************************************
//*
//*
//*     BitUtility.cpp
//*
//*
//*****************************************************************************
//
//  Copyright  2003    Anton Zechner
//
//  AzSmb is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use AzSmb must be published. Commercial users
//  must published their code too, or make an licence agreement with me.
//
//
//  AzSmb wird unter GNU GENERAL PUBLIC LICENSE (GPL) vertreiben.
//  Sourcecode welcher AzSmb verwendet muss verffentlicht werden.
//  Kommerzielle Nutzer mssen ihren Code ebenfalls verffentlichen, oder
//  eine Nutzungsvereinbarung mit mir treffen.
//
//  az_software@inode.at
//






static  unsigned char   ucBitOffset[256] = 
    {
    8,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    7,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    6,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    5,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    4,0,1,0,2,0,1,0,3,0,1,0,2,0,1,0,
    };


//*****************************************************************************
//*
//*     bit_set
//*
//*****************************************************************************
//  sets a bit in a memory area
//  pMem    : pointer to the memory area
//  iOffset : is the bit offest in the memory area
//  returns -1 if the bit was set, or 0 if it wan't set.
int bit_set(void *pMem,int iOffset)
{
char   *pPtr=(char*)pMem;
char    cBit;
int     iRet;


    pPtr += iOffset>>3;
    cBit  = 1<<(iOffset&7);

    if(*pPtr&cBit)
        {
        iRet   = -1;
        }
    else{
        *pPtr |= cBit;
        iRet   = 0;
        }


return 0;
}


//*****************************************************************************
//*
//*     bit_clear
//*
//*****************************************************************************
//  clears a bit in a memory area
//  pMem    : pointer to the memory area
//  iOffset : is the bit offest in the memory area
//  returns -1 if the bit was set, or 0 if it wan't set.
int bit_clear(void *pMem,int iOffset)
{
char   *pPtr=(char*)pMem;
char    cBit;
int     iRet;


    pPtr += iOffset>>3;
    cBit  = 1<<(iOffset&7);

    if(*pPtr&cBit)
        {
        *pPtr &= ~cBit;
        iRet   = -1;
        }
    else{
        iRet   = 0;
        }


return 0;
}



//*****************************************************************************
//*
//*     bit_read
//*
//*****************************************************************************
//  reads a bit from a memory area
//  pMem    : pointer to the memory area
//  iOffset : is the bit offest in the memory area
//  returns -1 if the bit was set, or 0 if it wan't set.
int bit_read(const void *pMem,int iOffset)
{

    return (((char*)pMem)[iOffset>>3]&(1<<(iOffset&7)))? -1:0;

}


//*****************************************************************************
//*
//*     bit_find_0_next
//*
//*****************************************************************************
//  seaches for an 0 bit in a memory area
//  pMem    : pointer to the memory area
//  uCount  : is the size of the memory area in bits
//  uOffset : is the bit in the memory area where the seach beginns
//  returns the founded bit position or the area size
int bit_find_0_next(const void *pMem,unsigned uCount,unsigned uOffset)
{
unsigned   *pPtr=(unsigned*)pMem;
unsigned    uBits;
unsigned    uPos;
unsigned    uMax;


    uPos   =  uOffset&~0x1F;
    uMax   =  uCount &~0x1F;
    pPtr  +=  uPos;
    uBits  =~*pPtr;
    uBits &=  0xFFFFFFFF<<(uOffset&0x1F);


    for(;uPos<uMax;uPos+=32,pPtr++,uBits=~*pPtr)    // Durchsuche 32 Bitpakete
        {
        if(!uBits)continue;

        if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
           uBits>>=8;
        if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
           uBits>>=8;
        if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
           uBits>>=8;
                      return uPos+ucBitOffset[uBits&0xFF];
        }


    if(uCount&0x1F)                                 // Durchsuche die letzen Bits
        {
        uBits  = ~*pPtr;
        uBits |=   0xFFFFFFFF<<(uCount&0x1F);

        if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
           uBits>>=8;
        if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
           uBits>>=8;
        if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
           uBits>>=8;
                      return uPos+ucBitOffset[uBits&0xFF];
        }


return uCount;
}


//*****************************************************************************
//*
//*     bit_find_1_next
//*
//*****************************************************************************
//  seaches for an 0 bit in a memory area
//  pMem    : pointer to the memory area
//  uCount  : is the size of the memory area in bits
//  uOffset : is the bit in the memory area where the seach beginns
//  returns the founded bit position or the area size
int bit_find_1_next(const void *pMem,unsigned uCount,unsigned uOffset)
{
unsigned   *pPtr=(unsigned*)pMem;
unsigned    uBits;
unsigned    uPos;
unsigned    uMax;


    uPos   =  uOffset&~0x1F;
    uMax   =  uCount &~0x1F;
    pPtr  +=  uPos;
    uBits  = *pPtr;
    uBits &=  0xFFFFFFFF<<(uOffset&0x1F);


    for(;uPos<uMax;uPos+=32,pPtr++,uBits=*pPtr)     // Durchsuche 32 Bitpakete
        {
        if(!uBits)continue;

        if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
           uBits>>=8;
        if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
           uBits>>=8;
        if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
           uBits>>=8;
                      return uPos+ucBitOffset[uBits&0xFF];
        }


    if(uCount&0x1F)                                 // Durchsuche die letzen Bits
        {
        uBits  = *pPtr;
        uBits |=  0xFFFFFFFF<<(uCount&0x1F);

        if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
           uBits>>=8;
        if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
           uBits>>=8;
        if(uBits&0xFF)return uPos+ucBitOffset[uBits&0xFF];
           uBits>>=8;
                      return uPos+ucBitOffset[uBits&0xFF];
        }


return uCount;
}


 

