//*****************************************************************************
//*
//*
//*      SmbReply.h
//*
//*
//*****************************************************************************
//
//  Copyright  2007    Anton Zechner
//
//  AzSmb is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use AzSmb must be published. Commercial users
//  must published their code too, or make an licence agreement with me.
//
//
//  AzSmb wird unter GNU GENERAL PUBLIC LICENSE (GPL) vertreiben.
//  Sourcecode welcher AzSmb verwendet muss verffentlicht werden.
//  Kommerzielle Nutzer mssen ihren Code ebenfalls verffentlichen, oder
//  eine Nutzungsvereinbarung mit mir treffen.
//
//  az_software@inode.at
//
#ifndef     __SMBUTILITY_H__
#define     __SMBUTILITY_H__


#include    "Smb.h"


    extern          SmbUserEntry    sUserEntry    [];
    extern          char            cUserEntryBits[];

    // memory functions 

    extern          SysHeap         hSmbHeap;

    #define         SmbReAlloc(p,s) SysHeapReAlloc(hSmbHeap,p,s)
    #define         SmbAlloc(s)     SysHeapAlloc(hSmbHeap,s)
    #define         SmbFree(p)      SysHeapFree(hSmbHeap,p)


    int             SmbInit();
    int             SmbExit();

    unsigned short  SmbCreateFile   (SmbSession *pSession,void *hHandle,int iType);
    unsigned short  SmbCreateTree   (SmbSession *pSession);
    unsigned short  SmbCreateUser   (SmbSession *pSession);
    unsigned short  SmbFindUser     (SmbSession *pSession,const char *pUsername);
                            
    void            SmbClearFile    (SmbSession *pSession,unsigned uPos);
    void            SmbClearTree    (SmbSession *pSession,unsigned uPos);
    void            SmbClearUser    (SmbSession *pSession,unsigned uPos);
                            
    unsigned long   SmbGetSessionId ();
    int             SmbPathName     (SmbSession *pSession,char *pName,const char *pSource);  
    void            SmbSessionInit  (SmbSession *pSession);
    void            SmbSessionExit  (SmbSession *pSession);
                                    
    SmbBase         SmbBaseFirst    (SmbSession *pSession,const char *pFilter,SysFindStruct *pFind);
    int             SmbBaseNext     (SmbSession *pSession,SmbBase     hHandle,SysFindStruct *pFind);
    int             SmbBaseClose    (SmbSession *pSession,SmbBase     hHandle);
                            
    int             SmbNewProcess   ();
    int             SmbDelProcess   (unsigned uNumber);
    int             SmbSessionLock  (unsigned uNumber);
    int             SmbSessionUnlock(unsigned uNumber);


//******************** inline functions ***************************************


    inline SmbFileEntry *SmbGetFile(SmbSession *pSession,unsigned uPos)
        {
        SmbTreeEntry *pTree;
        uPos--;
        if(uPos>MAX_FILE_ENTRIES)return 0;
            pTree=pSession->pTree;
        if(!pTree)return 0;
        if(!bit_read(pTree->cFileEntryBits,uPos))return 0;
        return       pTree->sFileEntry+uPos;
        }

    inline SmbTreeEntry *SmbGetTree(SmbSession *pSession,unsigned uPos)
        {
        uPos--;
        if(uPos>MAX_TREE_ENTRIES)return 0;
        if(!bit_read(pSession->cTreeEntryBits,uPos))return 0;
        return       pSession->sTreeEntry+uPos;
        }

    inline SmbUserEntry *SmbGetUser(SmbSession *pSession,unsigned uPos)
        {
        uPos--;
        if(uPos>MAX_USER_ENTRIES)return 0;
        if(!bit_read(pSession->cUserEntryBits,uPos))return 0;
        return pSession->sUserEntry+uPos;
        }



#endif 
