//*****************************************************************************
//*
//*
//*     SmbLanman.cpp
//*
//*
//*****************************************************************************
//
//  Copyright  2003    Anton Zechner
//
//
//  AzSmb is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use AzSmb must be published. Commercial users
//  must published their code too, or make an licence agreement with me.
//
//
//  AzSmb wird unter GNU GENERAL PUBLIC LICENSE (GPL) vertreiben.
//  Sourcecode welcher AzSmb verwendet muss verffentlicht werden.
//  Kommerzielle Nutzer mssen ihren Code ebenfalls verffentlichen, oder
//  eine Nutzungsvereinbarung mit mir treffen.
//
//  az_software@inode.at
//
//
#include "SmbInclude.h"
#include "SmbServer.h"
#include "SmbMisc.h"
#include "Smb.h"

#ifdef  MIN
#undef  MIN
#endif
#define MIN(a,b) ((a)<(b)?(a):(b))




#define     NERR_Success                0
#define     NERR_badpass                86
#define     NERR_notsupported           50

#define     NERR_BASE                   (2100)
#define     NERR_BufTooSmall            (NERR_BASE+23)
#define     NERR_JobNotFound            (NERR_BASE+51)
#define     NERR_DestNotFound           (NERR_BASE+52)

#define     ACCESS_READ                 0x01
#define     ACCESS_WRITE                0x02
#define     ACCESS_CREATE               0x04

#define     VERSION_MAJOR               1
#define     VERSION_MINOR               0

// server types

#define     SV_TYPE_WORKSTATION         0x00000001
#define     SV_TYPE_SERVER              0x00000002
#define     SV_TYPE_SQLSERVER           0x00000004
#define     SV_TYPE_DOMAIN_CTRL         0x00000008
#define     SV_TYPE_DOMAIN_BAKCTRL      0x00000010
#define     SV_TYPE_TIME_SOURCE         0x00000020
#define     SV_TYPE_AFP                 0x00000040
#define     SV_TYPE_NOVELL              0x00000080
#define     SV_TYPE_DOMAIN_MEMBER       0x00000100
#define     SV_TYPE_PRINTQ_SERVER       0x00000200
#define     SV_TYPE_DIALIN_SERVER       0x00000400
#define     SV_TYPE_XENIX_SERVER        0x00000800
#define     SV_TYPE_NT                  0x00001000
#define     SV_TYPE_WFW                 0x00002000
#define     SV_TYPE_SERVER_NT           0x00008000
#define     SV_TYPE_POTENTIAL_BROWSER   0x00010000
#define     SV_TYPE_BACKUP_BROWSER      0x00020000
#define     SV_TYPE_MASTER_BROWSER      0x00040000
#define     SV_TYPE_DOMAIN_MASTER       0x00080000
#define     SV_TYPE_LOCAL_LIST_ONLY     0x40000000
#define     SV_TYPE_DOMAIN_ENUM         0x80000000

// share types

#define     STYPE_DISKTREE              0               // Disk drive
#define     STYPE_PRINTQ                1               // Spooler queue
#define     STYPE_DEVICE                2               // Serial device
#define     STYPE_IPC                   3               // Interprocess communication (IPC)
#define     STYPE_HIDDEN                0x80000000      // share is a hidden one (ends with $)

#define     SHPWLEN                     8               // share password length

//*****************************************************************************
//*
//*     CharRealloc
//*
//*****************************************************************************
inline char *CharRealloc(void *pMem,int iSize)
{
void    *pNewMem;


    if(pMem)pNewMem=SmbReAlloc(pMem,iSize);
    else    pNewMem=SmbAlloc(iSize);

    if(!pNewMem)
        {
        PRINT_SMB_ERRS(("\nSYSERROR out of memory (size=%i)",iSize));
        SmbFree(pMem);
        return 0;
        }

return (char*)pNewMem;
}

//*****************************************************************************
//*
//*     SetMessage
//*
//*****************************************************************************
//  setup the word iCount and byte iCount for a smb message
inline int SetMessage(unsigned char *pBuffer,int iNumWords,int iNumBytes,int  bZero)
{
union
    {
    int     i;
    char    c[4];
    }num;


    if (bZero)memset(pBuffer + smb_size,'\0',iNumWords*2 + iNumBytes);


    CVAL (pBuffer,smb_wct)= iNumWords;

    iNumWords<<=1;

    SSVAL(pBuffer,smb_vwv + iNumWords , iNumBytes);
    num.i = (smb_size + iNumWords + iNumBytes - 4)&0x1FFFF;

    pBuffer[0] = 0;
    pBuffer[1] = num.c[2];
    pBuffer[2] = num.c[1];
    pBuffer[3] = num.c[0];

    SIVAL(pBuffer,4,SMB_BASE);


return num.i+4;
}


//*****************************************************************************
//*
//*     CopyTransData
//*
//*****************************************************************************
//  copies parameters and data, as needed, into the smb buffer
//
//   *both* the data and params sections should be aligned.  this
//   is fudged in the rpc pipes by
//   at present, only the data section is.  this may be a possible
//   cause of some of the ipc problems being experienced.  lkcl26dec97
inline void CopyTransData(
                unsigned char *pOut, int iAlign,
                char *pRParam, int iParamLen,
                char *pRData , int iDataLen)
{
unsigned char *pPtr = smb_buf(pOut)+1;


    if(iParamLen<0)iParamLen = 0;
    if(iDataLen <0)iDataLen  = 0;

    if(iParamLen)memcpy(pPtr, pRParam, iParamLen);

    pPtr += iParamLen+iAlign;

    if(iDataLen )memcpy(pPtr, pRData, iDataLen);
}

//*****************************************************************************
//*
//*     SendTransReply
//*
//*****************************************************************************
void SendTransReply(     SmbSession      *pSession,
                         unsigned char   *pOut,
                         char *pRParam   ,int iRParamLen,
                         char *pRData    ,int iRDataLen)
{
int     iThisDataLen;
int     iThisParamLen;
int     iTotalDataSent;
int     iTotalParamSent;
int     iAlign;
int     iDataLen;
int     iParamLen;



    iDataLen  = (pRData )? iRDataLen :0;
    iParamLen = (pRParam)? iRParamLen:0;


    iThisParamLen = MIN(iParamLen,pSession->iMaxResvSize -  500);
    iThisDataLen  = MIN(iDataLen ,pSession->iMaxResvSize - (500+iThisParamLen));

    iAlign = (iThisParamLen)&3;

    SetMessage(pOut,10,1+iAlign+iThisDataLen+iThisParamLen,TRUE);
    CopyTransData(pOut,iAlign,pRParam,iThisParamLen,pRData,iThisDataLen);


    SSVAL(pOut,smb_vwv0,iParamLen);
    SSVAL(pOut,smb_vwv1,iDataLen);
    SSVAL(pOut,smb_vwv3,iThisParamLen);
    SSVAL(pOut,smb_vwv4,smb_offset(smb_buf(pOut)+1,pOut));
    SSVAL(pOut,smb_vwv5,0);
    SSVAL(pOut,smb_vwv6,iThisDataLen);
    SSVAL(pOut,smb_vwv7,smb_offset(smb_buf(pOut)+1+iThisParamLen+iAlign,pOut));
    SSVAL(pOut,smb_vwv8,0);
    SSVAL(pOut,smb_vwv9,0);

    if(!TcpPut(pSession->hTcp,pOut,smb_len(pOut)+4))
        {
        PRINT_SMB_LERR(("\nLAN ERROR: TcpPut error"))
        if(pRParam)SmbFree(pRParam);
        if(pRData )SmbFree(pRData );
        SmbSessionExit(pSession);
        }

    iTotalDataSent  = iThisDataLen;
    iTotalParamSent = iThisParamLen;

                                             // send next data packets
    while(iTotalDataSent<iDataLen || iTotalParamSent<iParamLen)
        {
        iThisParamLen = MIN(iParamLen-iTotalParamSent, pSession->iMaxResvSize -  500);
        iThisDataLen  = MIN(iDataLen -iTotalDataSent , pSession->iMaxResvSize - (500+iThisParamLen));

        if(iThisParamLen<0)iThisParamLen = 0;
        if(iThisDataLen <0)iThisDataLen  = 0;

        iAlign = (iThisParamLen%4);
        SetMessage(pOut,10,1+iThisDataLen+iThisParamLen+iAlign,FALSE);

        CopyTransData(  pOut,    iAlign,
                        pRParam+iTotalParamSent, iThisParamLen,
                        pRData +iTotalDataSent , iThisDataLen);

        SSVAL(pOut,smb_vwv3,iThisParamLen);
        SSVAL(pOut,smb_vwv4,smb_offset(smb_buf(pOut)+1,pOut));
        SSVAL(pOut,smb_vwv5,iTotalParamSent);
        SSVAL(pOut,smb_vwv6,iThisDataLen);
        SSVAL(pOut,smb_vwv7,smb_offset(smb_buf(pOut)+1+iThisParamLen+iAlign,pOut));
        SSVAL(pOut,smb_vwv8,iTotalDataSent);
        SSVAL(pOut,smb_vwv9,0);

        if(!TcpPut(pSession->hTcp,pOut,smb_len(pOut)+4))
            {
            PRINT_SMB_LERR(("\nLAN ERROR: TcpPut error"))
            if(pRParam)SmbFree(pRParam);
            if(pRData )SmbFree(pRData );
            SmbSessionExit(pSession);
            }

        iTotalDataSent  += iThisDataLen;
        iTotalParamSent += iThisParamLen;
        }
}


//*****************************************************************************
//*
//*     FindService
//*
//*****************************************************************************
static int FindService(SmbSession *pSession,const char *pNetName)
{
SmbUserEntry    *pUser;
int              i;


        pUser=pSession->pUser;
    if(!pUser)return -1;

    if(!StrCmpI(pNetName,"IPC$"))return pUser->iCount;

    for(i=0;i<pUser->iCount;i++)
        {
        if(!StrCmpI(pNetName,pUser->pService[i]))return i;
        }

return -1;
}

//*****************************************************************************
//*
//*     FillShareInfo
//*
//*****************************************************************************
static int FillShareInfo(  SmbSession *pSession  ,int  iNr, int iLevel,
                           char      **pBuffer   ,int *pBufLen,
                           char      **pStringBuf,int *pStringLen,
                           char       *pBasePtr)
{
SmbUserEntry    *pUser;
const char      *pService,*pComment;
char            *p,*p2;
int              iStructLen;
int              i,l2,iLen,iType;



        pUser=pSession->pUser;
    if(!pUser)return -1;

    switch(iLevel)
        {
    case  0: iStructLen = 13; break;
    case  1: iStructLen = 20; break;
    case  2: iStructLen = 40; break;
    case 91: iStructLen = 68; break;
    default: return -1;
        }

    if(iNr>=pUser->iCount)
        {
        pService="IPC$";
        pComment="Remote-IPC";
        }
    else{
            pService=pUser->pService[iNr];
            pComment=pUser->pComment[iNr];
        if(!pComment)pComment="";
        }

    if(!pBuffer)
        {
        iLen = 0;
        if(iLevel>0)iLen += strlen(pComment)+1; // comment mit %S Service
        if(iLevel>1)iLen += strlen(pService)+1;
        if(pBufLen   )*pBufLen    = iStructLen;
        if(pStringLen)*pStringLen = iLen;

        return iStructLen + iLen;
        }

    iLen =  iStructLen;
    p    = *pBuffer;

    if(*pBufLen<iStructLen)return -1;

    if(pStringBuf)
        {
        p2 = *pStringBuf;
        l2 = *pStringLen;
        }
    else{
        p2 =  p       + iStructLen;
        l2 = *pBufLen - iStructLen;
        }

    if(!pBasePtr)pBasePtr = p;

    strncpy(p,pService,13);

    if(iLevel>0)
        {
        iType = STYPE_DISKTREE;
        //if(lp_print_ok(iNr))iType = STYPE_PRINTQ;
        if(!strcmp("IPC$",pService))iType = STYPE_IPC;

        SCVAL(p,13,0);
        SSVAL(p,14,iType);                  // device iType
        SIVAL(p,16,PTR_DIFF(p2,pBasePtr));
        strcpy(p2,pComment);
        i=strlen(p2)+1;
        iLen += i;
        p2   += i;
        }

    if(iLevel>1)
        {
        SSVAL (p,20,ACCESS_READ|ACCESS_WRITE|ACCESS_CREATE); // permissions
        SSVALS(p,22,-1);                    // max uses
        SSVAL (p,24, 1);                    // current uses
        SIVAL (p,26,PTR_DIFF(pBasePtr,p2)); // local pathname

        strcpy(p2,pService);                // copy comment
        i=strlen(p2)+1;
        iLen += i;
        p2  += i;

        memset(p+30,0,SHPWLEN+2);           // passwd (reserved), pad field
        }

    if(iLevel > 2)
        {
        memset(p+40,0,SHPWLEN+2);
        SSVAL(p,50,0);
        SIVAL(p,52,0);
        SSVAL(p,56,0);
        SSVAL(p,58,0);
        SIVAL(p,60,0);
        SSVAL(p,64,0);
        SSVAL(p,66,0);
        }

    if(pStringBuf)
        {
        *pBuffer      = p + iStructLen;
        *pBufLen     -= iStructLen;
        *pStringBuf   = p2;
        *pStringLen   = l2;
        }
    else{
        *pBuffer      = p2;
        *pBufLen     -= iLen;
        }

return iLen;
}

//*****************************************************************************
//*
//*     ApiTooSmall
//*
//*****************************************************************************
//  the buffer was too small
static int  ApiTooSmall(    SmbSession *pSession        ,unsigned short   wUid,
                            char       *pParam          ,char  *pData,
                            int         iMaxDataReturn  ,int    iMaxParamReturn,
                            char      **pRData          ,char **pRParam,
                            int        *iRDataLen       ,int   *iRParamLen)
{


    PRINT_SMB_LERR(("\nLAN ERROR: Supplied buffer too small in API command\n"))

        *iRParamLen = MIN(*iRParamLen,iMaxParamReturn);
        *pRParam    = CharRealloc(*pRParam,*iRParamLen);
    if(!*pRParam)return FALSE;
        *iRDataLen  = 0;

    SSVAL(*pRParam,0,NERR_BufTooSmall);



return TRUE;
}



//*****************************************************************************
//*
//*     ApiRNetShareEnum
//*
//*****************************************************************************
//  view list of shares available
//
//  parameter format:
//      unsigned short      return status
//      unsigned short      converter word
//      unsigned short      incuded number of entries
//      unsigned short      iTotal number of entries
//
//  data format:
//      char[13]    network name
//      char        pad                                         : level>0
//      unsigned short      type  (0=disk 1=printer 2=comm 3=ipc)
//      unsigned int        offset to comment
//      unsigned short      permissions (ACCESS_READ ACCESS_WRITE ...)  : level>1
//      unsigned short      max uses (-1)
//      unsigned short      current uses (1)
//      unsigned int        offset to local pathname
//      char[10]    password
//      unsigned char[28]   ???  (set to zero)                          : level>2
//
//      char[]      comments,local pathname,...
//
//  return TRUE if all ok
static int  ApiRNetShareEnum(   SmbSession *pSession        ,unsigned short   wUid,
                                char       *pParam          ,char  *pData,
                                int         iMaxDataReturn  ,int    iMaxParamReturn,
                                char      **pRData          ,char **pRParam,
                                int        *iRDataLen       ,int   *iRParamLen)
{
SmbUserEntry   *pUser;
char           *pStr1,*pStr2,*p,*p2;
int             iLevel,iBufLen,iCount;
int             iTotal=0,iCounted=0;
int             iDataLen,iFixedLen;
int             iStringLen;
int             iLenF,iLenS,i;
int             bMissed = FALSE;



        pUser=pSession->pUser;
    if(!pUser)return FALSE;

    pStr1    = pParam+2;
    pStr2    = pStr1+strlen(pStr1)+1;
    p       = pStr2+strlen(pStr2)+1;
    iLevel  = SVAL(p,0);
    iBufLen = SVAL(p,2);
    iCount  = pUser->iCount;

    if(!iCount)return FALSE;

    if(strncmp(pStr1,"WrLeh",5))return FALSE;

    switch(iLevel)
        {
    case 0: if(strcmp(pStr2,"B13"                    ))return FALSE; break;
    case 1: if(strcmp(pStr2,"B13BWz"                 ))return FALSE; break;
    case 2: if(strcmp(pStr2,"B13BWzWWWzB9B"          ))return FALSE; break;
    case 91:if(strcmp(pStr2,"B13BWzWWWzB9BB9BWzWWzWW"))return FALSE; break;
    default:                                           return FALSE;
        }

    iDataLen    = 0;
    iFixedLen   = 0;
    iStringLen  = 0;

    for(i=0;i<=iCount;i++)                      // calc buffer size
        {
        iTotal++;
        iLenF = 0;
        iLenS = 0;
        iDataLen += FillShareInfo(pSession,i,iLevel,0,&iLenF,0,&iLenS,0);

        if(iDataLen <= iBufLen)
            {
            iCounted++;
            iFixedLen  += iLenF;
            iStringLen += iLenS;
            }
        else{
            bMissed = TRUE;
            }

            *iRDataLen = iFixedLen + iStringLen;
            *pRData = CharRealloc(*pRData,*iRDataLen);
        if(!*pRData)return FALSE;
        memset(*pRData,0,*iRDataLen);
        }

    p2 = *pRData + iFixedLen;                   // auxillery data will go here
    p  = *pRData;

    iLenF = iFixedLen;
    iLenS = iStringLen;

    for(i=0;i<=iCount;i++)                      // copy data
        {
        if(FillShareInfo(pSession,i,iLevel,&p,&iLenF,&p2,&iLenS,*pRData)<0)break;
        }

        *iRParamLen = 8;
        *pRParam    = CharRealloc(*pRParam,8);
    if(!*pRParam)return FALSE;

    SSVAL(*pRParam,0,bMissed ? ERRmoredata : NERR_Success);
    SSVAL(*pRParam,2,0);
    SSVAL(*pRParam,4,iCounted);
    SSVAL(*pRParam,6,iTotal);

    PRINT_SMB_LANM(("\nLAN NetShareEnum gave %d entries of %d (%d %d %d %d)\n",iCounted,iTotal,iLevel,iBufLen,*iRDataLen,iMaxDataReturn))



return TRUE;
}


//*****************************************************************************
//*
//*     ApiNetWkstaGetInfo
//*
//*****************************************************************************
//  get info about the server
//
//  parameter format:
//      unsigned short  return status
//      unsigned short  converter word
//      unsigned short  iTotal number of databytes
//
//  data format:
//      unsigned int    offset computer name
//      unsigned int    offset user name
//      unsigned int    offset langroup
//      unsigned char   major version
//      unsigned char   minor version
//      unsigned int    offset login domin
//      unsigned int    offset computer domin
//
//  return TRUE if all ok
static int  ApiNetWkstaGetInfo( SmbSession *pSession        ,unsigned short   wUid,
                                char       *pParam          ,char  *pData,
                                int         iMaxDataReturn  ,int    iMaxParamReturn,
                                char      **pRData          ,char **pRParam,
                                int        *iRDataLen       ,int   *iRParamLen)
{
char    *pStr1,*pStr2,*p,*p2;
int      iLevel;


    pStr1   = pParam+2;
    pStr2   = pStr1+strlen(pStr1)+1;
    p      = pStr2+strlen(pStr2)+1;
    iLevel = SVAL(p,0);

    PRINT_SMB_LANM(("\nLAN NetWkstaGetInfo iLevel %d\n",iLevel))

        *iRParamLen = 6;
        *pRParam    = CharRealloc(*pRParam,6);
    if(!*pRParam)return FALSE;


                                            // check it's a supported varient
    if(iLevel!=10 || strcmp(pStr1,"WrLh") || strcmp(pStr2,"zzzBBzz"))
        {
        return FALSE;
        }

        *iRDataLen = iMaxDataReturn + 1024;
        *pRData    = CharRealloc(*pRData,*iRDataLen);
    if(!*pRData)return -1;

    SSVAL(*pRParam,0,NERR_Success);
    SSVAL(*pRParam,2,0);

    p  = *pRData;
    p2 =  p + 22;

    SIVAL(p,0,PTR_DIFF(p2,*pRData));        // host name
    strcpy(p2,pSession->cLocalMachine);
    StrUpper(p2);

    p2 += strlen(p2)+1;
    p  += 4;

    SIVAL(p,0,PTR_DIFF(p2,*pRData));        // user name
    strcpy(p2,(pSession->pUser->cUsername)? pSession->pUser->cUsername:"");

    p2 += strlen(p2)+1;
    p  += 4;

    SIVAL(p,0,PTR_DIFF(p2,*pRData));        // login domain
    strcpy(p2,cMyWorkgroup);
    StrUpper(p2);

    p2 += strlen(p2)+1;
    p  += 4;


    SCVAL(p,0,VERSION_MAJOR);               // system version - e.g 4 in 4.1
    SCVAL(p,1,VERSION_MINOR);
    p += 2;

    SIVAL(p,0,PTR_DIFF(p2,*pRData));
    strcpy(p2,cMyWorkgroup);                // don't know.  login domain??
    p2 += strlen(p2)+1;
    p  += 4;

    SIVAL(p,0,PTR_DIFF(p2,*pRData));        // don't know
    strcpy(p2,"");
    p2 += strlen(p2)+1;
    p  += 4;


    *iRDataLen = PTR_DIFF(p2,*pRData);
    SSVAL(*pRParam,4,*iRDataLen);


return TRUE;
}


//*****************************************************************************
//*
//*     ApiRNetShareGetInfo
//*
//*****************************************************************************
//  get info about a share entry
//
//  parameter format:
//      unsigned short      return status
//      unsigned short      zero
//      unsigned short      iTotal number of databytes
//
//  data format:
//      char[16]    server name
//      unsigned char       major version                   : level >1
//      unsigned char       minor version
//      unsigned int        server type
//      unsigned int        offset to comment
//
//  return TRUE if all ok
static int  ApiRNetShareGetInfo(SmbSession *pSession        ,unsigned short   wUid,
                                char       *pParam          ,char            *pData,
                                int         iMaxDataReturn  ,int              iMaxParamReturn,
                                char      **pRData          ,char           **pRParam,
                                int        *iRDataLen       ,int             *iRParamLen)
{
char    *pStr1,*pStr2,*pNet,*p,*p2;
int      iLevel,iFLen,iSLen,iLen,i=0;



    pStr1   = pParam+2;
    pStr2   = pStr1+strlen(pStr1)+1;
    pNet    = pStr2+strlen(pStr2)+1;
    p       = pNet +strlen(pNet )+1;
    iLevel  = SVAL(p,0);

    PRINT_SMB_LANM(("\nLAN RNetShareGetInfo iLevel %d \"%s\"\n",iLevel,pNet))

       i= FindService(pSession,pNet);
    if(i<0)
        return FALSE;

    if(strcmp(pStr1,"zWrLh"))
        return FALSE;

    switch(iLevel)
        {
    case 0: if(strcmp(pStr2,"B13"                    ))return FALSE;break;
    case 1: if(strcmp(pStr2,"B13BWz"                 ))return FALSE;break;
    case 2: if(strcmp(pStr2,"B13BWzWWWzB9B"          ))return FALSE;break;
    case 91:if(strcmp(pStr2,"B13BWzWWWzB9BB9BWzWWzWW"))return FALSE;break;
    default: return FALSE;
        }

    iFLen = 0;
    iSLen = 0;
    iLen  = FillShareInfo(pSession,i,iLevel,0,&iFLen,0,&iSLen,0);

        *iRDataLen = iLen;
        *pRData = CharRealloc(*pRData,*iRDataLen);
    if(!*pRData)
        return FALSE;
    memset(*pRData,0,iLen);

    p2 = *pRData + iFLen;
    p  = *pRData;

       iLen=FillShareInfo(pSession,i,iLevel,&p,&iFLen,&p2,&iSLen,*pRData);
    if(iLen<0)
        {
        return FALSE;
        }


        *iRParamLen = 6;
        *pRParam    = CharRealloc(*pRParam,6);
    if(!*pRParam)
        return FALSE;

        *iRDataLen  = iLen;
        *pRData     = CharRealloc(*pRData,iLen);
    if(!*pRData)
        return FALSE;

    SSVAL(*pRParam,0,NERR_Success);
    SSVAL(*pRParam,2,0);
    SSVAL(*pRParam,4,*iRDataLen);



return TRUE;
}

//*****************************************************************************
//*
//*     ApiRNetServerGetInfo
//*
//*****************************************************************************/
//  get info about the server
//
//  parameter format:
//      unsigned short      return status
//      unsigned short      zero
//      unsigned short      iTotal number of databytes
//
//  data format:
//      char[16]    server name
//      unsigned char       major version                   : level >1
//      unsigned char       minor version
//      unsigned int        server type
//      unsigned int        offset to comment
//
//  return TRUE if all ok
static int  ApiRNetServerGetInfo(SmbSession *pSession       ,unsigned short   wUid,
                                char       *pParam          ,char  *pData,
                                int         iMaxDataReturn  ,int    iMaxParamReturn,
                                char      **pRData          ,char **pRParam,
                                int        *iRDataLen       ,int   *iRParamLen)
{
char    *pStr1,*pStr2,*p,*p2;
int      iStructLen;
int      iLevel;



    pStr1  = pParam+2;
    pStr2  = pStr1+strlen(pStr1)+1;
    p      = pStr2+strlen(pStr2)+1;
    iLevel = SVAL(p,0);

    PRINT_SMB_LANM(("\nLAN RNetServerGetInfo iLevel %d\n",iLevel))


    if(strcmp(pStr1,"WrLh")) return FALSE;

    switch( iLevel )
        {
    case 0: if(strcmp(pStr2,"B16"))return FALSE;
            iStructLen = 16;
            break;

    case 1: if(strcmp(pStr2,"B16BBDz"))return FALSE;
            iStructLen = 26;
            break;

    default: return FALSE;
        }


        *iRDataLen = iMaxDataReturn;
        *pRData    = CharRealloc(*pRData,*iRDataLen);
    if(!*pRData)return FALSE;

    p  = *pRData;
    p2 = p + iStructLen;

    strncpy (p,pSession->cLocalMachine,16);
    StrUpper(p);

    p += 16;

    if(iLevel>0)
        {
        SCVAL(p,0,VERSION_MAJOR);
        SCVAL(p,1,VERSION_MINOR);
        SIVAL(p,2,SV_TYPE_WORKSTATION);

        if(iMaxDataReturn == iStructLen)
            {
            SIVAL(p,6,0);
            }
        else{
            SIVAL(p,6,PTR_DIFF(p2,*pRData));        // comment
            p2[0]=0;
            p2++;
            }
        }

    if(iLevel>1)
        {
        return FALSE;                               // not yet implemented
        }

        *iRDataLen  = PTR_DIFF(p2,*pRData);
        *iRParamLen = 6;
        *pRParam    = CharRealloc(*pRParam,*iRParamLen);
    if(!*pRParam)return FALSE;

    SSVAL(*pRParam,0,NERR_Success);
    SSVAL(*pRParam,2,0);                            // converter word
    SSVAL(*pRParam,4,*iRDataLen);



return TRUE;
}


//*****************************************************************************
//*
//*     ApiNetRemoteTOD
//*
//*****************************************************************************
//  get the time of day info
static int  ApiNetRemoteTOD(SmbSession *pSession        ,unsigned short   wUid,
                            char       *pParam          ,char  *pData,
                            int         iMaxDataReturn  ,int    iMaxParamReturn,
                            char      **pRData          ,char **pRParam,
                            int        *iRDataLen       ,int   *iRParamLen)
{
SysTimeStruct   sData;
SysTime         uTime;
char           *pPtr;




        *iRParamLen = 4;
        *pRParam    = CharRealloc(*pRParam,4);
    if(!*pRParam)return FALSE;
        *iRDataLen  = 21;
        *pRData     = CharRealloc(*pRData,21);
    if(!*pRData)return FALSE;

    SSVAL(*pRParam,0,NERR_Success);
    SSVAL(*pRParam,2,0);

    pPtr  = *pRData;
    uTime = SysTimeGet();
    SysTimeToStruct(&sData,uTime,0);
    

    SIVAL(pPtr, 4,0);               // msecs ?
    SCVAL(pPtr, 8,sData.ucHour  );
    SCVAL(pPtr, 9,sData.ucMinute);
    SCVAL(pPtr,10,sData.ucSecond);
    SCVAL(pPtr,11,0);               // hundredths of seconds
    SSVAL(pPtr,12,0);               // timezone in minutes from GMT
    SSVAL(pPtr,14,10000);           // timer interval in 0.0001 of sec
    SCVAL(pPtr,16,sData.ucDay   );
    SCVAL(pPtr,17,sData.ucMonth );
    SSVAL(pPtr,18,sData.usYear  );
    SCVAL(pPtr,20,SysTimeToWeekday(uTime));



return TRUE;
}

//*****************************************************************************
//*
//*     ApiUnsupported
//*
//*****************************************************************************
//  The request is not supported
static int  ApiUnsupported(SmbSession *pSession     ,unsigned short   wUid,
                            char       *pParam          ,char  *pData,
                            int         iMaxDataReturn  ,int    iMaxParamReturn,
                            char      **pRData          ,char **pRParam,
                            int        *iRDataLen       ,int   *iRParamLen)
{

    PRINT_SMB_LERR(("\nLAN ERROR Unsupported API command\n"))

        *iRParamLen = 4;
        *pRParam    = CharRealloc(*pRParam,4);
    if(!*pRParam)return FALSE;
        *iRDataLen  = 0;

    SSVAL(*pRParam,0,NERR_notsupported);
    SSVAL(*pRParam,2,0);        /* converter word */


return  TRUE;
}




typedef struct
    {
    const char *pName;
    int         iId;
    int       (*pProc)(SmbSession *,unsigned short,char *,char *,int,int,char **,char **,int *,int *);
    int         iFlags;
    }LanApiCommand;


#define     L_API(a,b,c,d)  {a,b,c,d}
#define     LxAPI(a,b,c,d)  {a,b,NULL,d}

unsigned char ucLanApiMatrix[256]=
    {
    /* 000 */   0x01,0x02,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 010 */   0x00,0x00,0x00,0x03,0x00,   0x00,0x00,0x00,0x00,0x13,
    /* 020 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 030 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 040 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 050 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 060 */   0x00,0x00,0x00,0x07,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 070 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 080 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 090 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 100 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 110 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 120 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 130 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 140 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 150 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 160 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 170 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 180 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 190 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 200 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 210 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 220 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 230 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 240 */   0x00,0x00,0x00,0x00,0x00,   0x00,0x00,0x00,0x00,0x00,
    /* 250 */   0x00,0x00,0x00,0x00,0x00,   0x00
    };


LanApiCommand sApiCommands[] =
    {
    /* 00 */    L_API(NULL,                    -1,      ApiUnsupported          ,0),
    /* 01 */    L_API("NetShareEnum",           0,      ApiRNetShareEnum        ,0),
    /* 02 */    L_API("NetShareGetInfo",        1,      ApiRNetShareGetInfo     ,0),
    /* 03 */    L_API("NetServerGetInfo",       13,     ApiRNetServerGetInfo    ,0),
    /* 04 */    LxAPI("NetGroupGetUsers",       52,     ApiRNetGroupGetUsers    ,0),
    /* 05 */    LxAPI("NetUserGetInfo",         56,     ApiRNetUserGetInfo      ,0),
    /* 06 */    LxAPI("NetUserGetGroups",       59,     ApiNetUserGetGroups     ,0),
    /* 07 */    L_API("NetWkstaGetInfo",        63,     ApiNetWkstaGetInfo      ,0),
    /* 08 */    LxAPI("DosPrintQEnum",          69,     ApiDosPrintQEnum        ,0),
    /* 09 */    LxAPI("DosPrintQGetInfo",       70,     ApiDosPrintQGetInfo     ,0),
    /* 0A */    LxAPI("WPrintQueuePause",       74,     ApiWPrintQueueCtrl      ,0),
    /* 0B */    LxAPI("WPrintQueueResume",      75,     ApiWPrintQueueCtrl      ,0),
    /* 0C */    LxAPI("WPrintJobEnumerate",     76,     ApiWPrintJobEnumerate   ,0),
    /* 0D */    LxAPI("WPrintJobGetInfo",       77,     ApiWPrintJobGetInfo     ,0),
    /* 0E */    LxAPI("RDosPrintJobDel",        81,     ApiRDosPrintJobDel      ,0),
    /* 0F */    LxAPI("RDosPrintJobPause",      82,     ApiRDosPrintJobDel      ,0),
    /* 10 */    LxAPI("RDosPrintJobResume",     83,     ApiRDosPrintJobDel      ,0),
    /* 11 */    LxAPI("WPrintDestEnum",         84,     ApiWPrintDestEnum       ,0),
    /* 12 */    LxAPI("WPrintDestGetInfo",      85,     ApiWPrintDestGetInfo    ,0),
    /* 13 */    L_API("NetRemoteTOD",           91,     ApiNetRemoteTOD         ,0),
    /* 14 */    LxAPI("WPrintQueuePurge",       103,    ApiWPrintQueueCtrl      ,0),
    /* 15 */    LxAPI("NetServerEnum",          104,    ApiRNetServerEnum       ,0),
    /* 16 */    LxAPI("WAccessGetUserPerms",    105,    ApiWAccessGetUserPerms  ,0),
    /* 17 */    LxAPI("SetUserPassword",        115,    ApiSetUserPassword      ,0),
    /* 18 */    LxAPI("WWkstaUserLogon",        132,    ApiWWkstaUserLogon      ,0),
    /* 19 */    LxAPI("PrintJobInfo",           147,    ApiPrintJobInfo         ,0),
    /* 1A */    LxAPI("WPrintDriverEnum",       205,    ApiWPrintDriverEnum     ,0),
    /* 1B */    LxAPI("WPrintQProcEnum",        206,    ApiWPrintQProcEnum      ,0),
    /* 1C */    LxAPI("WPrintPortEnum",         207,    ApiWPrintPortEnum       ,0),
    /* 1D */    LxAPI("SamOEMChangePassword",   214,    ApiSamOEMChangePassword ,0),
    };


//*****************************************************************************
//*
//*     LanReply
//*
//*****************************************************************************/
int LanReply(   SmbSession     *pSession,
                unsigned short  wUid,
                unsigned char  *pOut,
                char           *pData,
                char           *pParam,
                int             iTotalDataCount,
                int             iTotalParamCount,
                int             iMaxDataReturn,
                int             iMaxParamReturn)
{
int     iCommand;
int     iMatrix     = 0;
char   *pRData      = NULL;
char   *pRParam     = NULL;
int     bRebly      = FALSE;
int     iRDataLen   = 0;
int     iRParamLen  = 0;



    if(!pParam)
        {
        PRINT_SMB_LERR(("\nLAN ERROR: NULL param in LanReply()"))
        return 0;
        }

       iCommand = SVAL(pParam,0);
    if(iCommand<=0xFF)iMatrix = ucLanApiMatrix[iCommand];

    PRINT_SMB_LANM(("\nLAN %i  (%i)\t",iCommand,iTotalParamCount))

    #if PRINT_SMB_LANM_ON
    int i;

    for(i=0;i<iTotalParamCount;i++)
        {
        if(i>=24)break;
        PRINT_SMB_LANM(("%s%02X ",(i&3)? "":" ",pParam[i]&0xFF))
        }

    for(i=0;i<iTotalParamCount;i++)
        {
        if(i>=24)break;
        PRINT_SMB_LANM(("%s%c",(i&3)? "":" ",(pParam[i]>=' ')? pParam[i]:'.'))
        }

    PRINT_SMB_LANM(("\n    data:(%i)\t",iTotalDataCount))

    for(i=0;i<iTotalDataCount;i++)
        {
        if(i>=24)break;
        PRINT_SMB_LANM(("%s%02X ",(i&3)? "":" ",pData[i]&0xFF))
        }

    for(i=0;i<iTotalDataCount;i++)
        {
        if(i>=24)break;
        PRINT_SMB_LANM(("%s%c",(i&3)? "":" ",(pData[i]>=' ')? pData[i]:'.'))
        }
    #endif


        pRData = (char *)SmbAlloc(1024);
    if(!pRData)return -1;

        pRParam = (char *)SmbAlloc(1024);
    if(!pRParam){SmbFree(pRData);return -1;}


    bRebly = sApiCommands[iMatrix].pProc(pSession,wUid ,pParam,pData,
                                         iMaxDataReturn,iMaxParamReturn,
                                         &pRData       ,&pRParam,
                                         &iRDataLen    ,&iRParamLen);

    #if PRINT_SMB_LANM_ON
    if(!bRebly)
        {
        if(pData)
        PRINT_SMB_LANM(("%s%c",(i&3)? "":" ",(pData[i]>=' ')? pData[i]:'.'))
        PRINT_SMB_LANM(("\n\treturn FALSE %s",sApiCommands[iMatrix].pName));
        }
    #endif

    if(iRDataLen>iMaxDataReturn || iRParamLen>iMaxParamReturn)
        {
        bRebly = ApiTooSmall(   pSession,wUid,pParam,pData,
                                iMaxDataReturn,iMaxParamReturn,
                                &pRData,&pRParam,
                                &iRDataLen,&iRParamLen);
        }

    if(!bRebly)                             // actually unsupported
        {
        ApiUnsupported(         pSession,wUid,pParam,pData,
                                iMaxDataReturn,iMaxParamReturn,
                                &pRData,&pRParam,
                                &iRDataLen,&iRParamLen);
        }

    SendTransReply(pSession,pOut,pRParam,iRParamLen,pRData,iRDataLen);

    if(pRData )SmbFree(pRData);
    if(pRParam)SmbFree(pRParam);



return 0;
}

