//*****************************************************************************
//*
//*
//*      SmbInline.h
//*
//*
//*****************************************************************************
//
//  Copyright  2007    Anton Zechner
//
//  AzSmb is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use AzSmb must be published. Commercial users
//  must published their code too, or make an licence agreement with me.
//
//
//  AzSmb wird unter GNU GENERAL PUBLIC LICENSE (GPL) vertreiben.
//  Sourcecode welcher AzSmb verwendet muss verffentlicht werden.
//  Kommerzielle Nutzer mssen ihren Code ebenfalls verffentlichen, oder
//  eine Nutzungsvereinbarung mit mir treffen.
//
//  az_software@inode.at
//

#ifndef __SMBINLINE_H__
#define __SMBINLINE_H__

#include "SmbInclude.h"
#include "Smb.h"


#if     SMB_PRINT_ERR
int     ErrorPacket(unsigned char *pOut,int iErrorClass,unsigned iErrorCode,int iLine,const char *pFile,const char *pError);
#define SMB_ERROR(cls,x)        ErrorPacket(pOut,cls,x,__LINE__,__FILE__,#x)
#else 
#define SMB_ERROR(cls,x)        ErrorPacket(pOut,cls,x)
int     ErrorPacket(unsigned char *pOut,int iErrorClass,unsigned iErrorCode);
#endif 



//*****************************************************************************
//*
//*      SmbSetMessage
//*
//*****************************************************************************
//  setup the word count and byte count for a smb message
inline int SmbSetMessage(unsigned char *pMem,int iNumWords,int iNumBytes,int iZero)
{
union
    {
    int     i;
    char    c[4];
    }sData;


    if(iZero)memset(pMem + smb_size,'\0',iNumWords*2 + iNumBytes);


    CVAL(pMem,smb_wct)= iNumWords;

    iNumWords<<=1;

    SSVAL(pMem,smb_vwv  + iNumWords , iNumBytes);  
    sData.i = (smb_size + iNumWords + iNumBytes - 4)&0x1FFFF;

    pMem[0] = 0; 
    pMem[1] = sData.c[2]; 
    pMem[2] = sData.c[1];
    pMem[3] = sData.c[0];

    SIVAL(pMem,4,SMB_BASE);


return sData.i+4;
}

//*****************************************************************************
//*
//*      SmbSetLen1
//*
//*****************************************************************************
//  set the iSize 
inline void SmbSetLen1(unsigned char *pMem,int iLen)
{
union
    {
    int     i;
    char    c[4];
    }sData;

    sData.i=iLen&0x1FFFF;

    pMem[0] = 0; 
    pMem[1] = sData.c[2]; 
    pMem[2] = sData.c[1];
    pMem[3] = sData.c[0];

}

//*****************************************************************************
//*
//*      SmbSetLen
//*
//*****************************************************************************
//  set the iSize and marker of an smb packet
inline void SmbSetLen(unsigned char *pMem,int iLen)
{
union
    {
    int     i;
    char    c[4];
    }sData;

    sData.i=iLen&0x1FFFF;

    pMem[0] = 0; 
    pMem[1] = sData.c[2]; 
    pMem[2] = sData.c[1];
    pMem[3] = sData.c[0];

    SIVAL(pMem,4,SMB_BASE);
}


//*****************************************************************************
//*
//*      AttrSysToDos
//*
//*****************************************************************************
inline int AttrSysToDos(unsigned uAttr)
{
int iMode;


    iMode=(uAttr&SYS_WRITE)?  0:aRONLY;

    if(uAttr&SYS_HIDDEN )iMode|=aHIDDEN;
    if(uAttr&SYS_SYSTEM )iMode|=aSYSTEM;
    if(uAttr&SYS_ARCHIVE)iMode|=aARCH;
    if(uAttr&SYS_VOLUME )iMode|=aVOLID;
    if(uAttr&SYS_DIR    )iMode|=aDIR;


return iMode;
}


//*****************************************************************************
//*
//*      AttrDosToSys
//*
//*****************************************************************************
inline unsigned AttrDosToSys(int iMode)
{
int uAttr;


    uAttr=(iMode&aRONLY)? SYS_READ:SYS_READ|SYS_WRITE;

    if(iMode&aHIDDEN)uAttr|=SYS_HIDDEN;
    if(iMode&aSYSTEM)uAttr|=SYS_SYSTEM; 
    if(iMode&aARCH  )uAttr|=SYS_ARCHIVE;
    if(iMode&aVOLID )uAttr|=SYS_VOLUME;
    if(iMode&aDIR   )uAttr|=SYS_DIR;


return uAttr;
}



//*****************************************************************************
//*
//*      AttrSysToWin
//*
//*****************************************************************************
inline int AttrSysToWin(unsigned uAttr)
{
int iMode;


    iMode=(uAttr&SYS_WRITE)?  0x0000:0x0001;

    if(uAttr&SYS_HIDDEN )iMode|=0x0002;
    if(uAttr&SYS_SYSTEM )iMode|=0x0004;
    if(uAttr&SYS_ARCHIVE)iMode|=0x0020;
    if(uAttr&SYS_VOLUME )iMode|=0x0010;
    if(uAttr&SYS_DIR    )iMode|=0x0010;

    if(iMode==0)iMode=0x0080;



return iMode;
}

#endif 
