//*****************************************************************************
//*
//*
//*      NmbServer.cpp
//*
//*
//*****************************************************************************
//
//  Copyright  2003    Anton Zechner
//
//  AzSmb is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use AzSmb must be published. Commercial users
//  must published their code too, or make an licence agreement with me.
//
//
//  AzSmb wird unter GNU GENERAL PUBLIC LICENSE (GPL) vertreiben.
//  Sourcecode welcher AzSmb verwendet muss verffentlicht werden.
//  Kommerzielle Nutzer mssen ihren Code ebenfalls verffentlichen, oder
//  eine Nutzungsvereinbarung mit mir treffen.
//
//  az_software@inode.at
//
//  Netbiosnamen
//
//      <00>      Existenz des Rechners
//      <00>    G Arbeitsgruppe
//      <20>      Datei und Drucker Server
//      <03>      Komandoserver fr Nachrichten
//      <1B>    G Domain Master
//      <1C>    G Domainlogon Server
//      <1D>    G Local Master
//      <1E>    G Wahl fr Local Master
//
#include "SmbMisc.h"
#include "DgrServer.h"
#include "NmbInclude.h"
#include "NmbServer.h"
#include "NameDb.h"


#define     MAX_SYCNCH_BLOCKS   32
#define     MAX_RESIVE_BLOCKS   32
#define     BLOCK_SIZE          600
#define     SYCNCH_MASK         (MAX_SYCNCH_BLOCKS-1)

#define     ADD_TIMEOUT         500
#define     REF_TIMEOUT         500
#define     QUERY_TIMEOUT       500

#define     SETW(p,o,v)         *(unsigned short*)(((char*)(p))+(o))=(short)(v)
#define     SETD(p,o,v)         *(unsigned int  *)(((char*)(p))+(o))=(int  )(v)
#define     GETW(p,o)           *(unsigned short*)(((char*)(p))+(o))
#define     GETD(p,o)           *(unsigned int  *)(((char*)(p))+(o))


#if         SU_USE_IPV6
#define     SETA(p,o,v)     SETD(p,o,((v).uAddr[1]))
static      IpAddr          NULL_IP={SU_IPV4_ID,0,0,0};
#define     GETA(p,o,v)     (v).uAddr[1]=GETD(p,o);(v).uAddr[0]=SU_IPV4_ID
#else
#define     SETA(p,o,v)     SETD(p,o,v)
#define     GETA(p,o,v)     v=GETD(p,o)
#define     NULL_IP         0
#endif

#if NMB_PRINT
    #define     NMB_PRINT_PACKET
    #define     NMB_PACKET(a)       smb_printf a
    #define     NMB_MESSAGE(a)      smb_printf a
    #define     NMB_ERR_MESSAGE(a)  smb_printf a
    #define     NMB_PRINT_LOCK()    smb_plock()
    #define     NMB_PRINT_UNLOCK()  smb_punlock()
#else
    #define     NMB_PACKET(a)
    #define     NMB_MESSAGE(a)
    #define     NMB_ERR_MESSAGE(a)  default_printf a
    #define     NMB_PRINT_LOCK()
    #define     NMB_PRINT_UNLOCK()
#endif

#define         NMB_API             extern "C"
#define         DRG_ELREFRESH       (15*60*1000)
#define         DRG_REFRESH         (1*60*1000)
#define         LIVETIME            (5*60*1000)
#define         SSWAP(l)            ((((l)>> 8)&0x000000FF)|(((l)<<8)&0x0000FF00))
#define         LSWAP(l)            ((((l)>>24)&0x000000FF)|(((l)>>8)&0x0000FF00)|  \
                                    (( (l)<<24)&0xFF000000)|(((l)<<8)&0x00FF0000))

typedef struct
    {
    UdpHandle           hNmb;
    IpAddr              ipSocket;
    IpAddr              ipBroadcast;
    int                 bRun;
    }NmbInterface;

typedef struct
    {
    SysSemaphore        hSema;
    int                 iBlock;
    unsigned short      uMsgId;
    unsigned short      uPos;
    }NmbSynch;

typedef struct
    {
    SysSemaphore        hSem;
    const char         *pName;
    const char         *pDomain;
    int                 bGroup;
    }AddNameStruct;

static  unsigned char   ucResiveBlock[ MAX_RESIVE_BLOCKS][BLOCK_SIZE];
static  unsigned char   ucResiveBits [(MAX_RESIVE_BLOCKS+7)/3];
static  unsigned char   ucSynchBits  [(MAX_SYCNCH_BLOCKS+7)/3];
static  NmbSynch        nsSynchBlock [ MAX_SYCNCH_BLOCKS];
static  NmbConfigData   sConfig;


static  NmbInterface    sUdpInterface;
static  int             bNmbIsStarted=0;
static  int             bNmbRunRefresh=0;
static  int             bCrateTempDb=0;
static  SysSemaphore    hBlockSema=0;
static  SysSemaphore    hSynchSema=0;
static  SysSemaphore    hSyBlkSema=0;
static  SysSemaphore    hSyUdpSema=0;

static int      NmbResiveReq    (unsigned char *pBlock,int iBlock,IpAddr *pFrom,unsigned short usPort);
int             NmbRefreshName  (const    char *pName,const char *pDomain,int bGroup);
int             NmbAddName      (const    char *pName,const char *pDomain,int bGroup);
void            NmbAddNameNoWait(const    char *pName,const char *pDomain,int bGroup);
int             NmbOverwriteName(const    char *pName,const char *pDomain,int bGroup);

char            cMyName     [16];
char            cMyWorkgroup[16];
unsigned        uNmbSendPackets=0;
unsigned        uNmbResvPackets=0;





//*****************************************************************************
//*
//*      NmbPrintPacket
//*
//*****************************************************************************
#ifdef  NMB_PRINT_PACKET
void NmbPrintPacket(const void *pPacketPtr,int iSize)
{
unsigned char  *pPacket=(unsigned char*)pPacketPtr;
char            cBuffer[256];
int             iTtl,iQc,iAc,iNc,iRc,i,j;
static   char   *pNmbTypes[]=
                    {    /*  0 */  "query",
                         /*  1 */  "???",
                         /*  2 */  "???",
                         /*  3 */  "???",
                         /*  4 */  "???",
                         /*  5 */  "registration",
                         /*  6 */  "release",
                         /*  7 */  "WACK",
                         /*  8 */  "refresh",
                         /*  9 */  "???",
                         /* 10 */  "???",
                         /* 11 */  "???",
                         /* 12 */  "???",
                         /* 13 */  "???",
                         /* 14 */  "???",
                         /* 15 */  "???"
                    };


    NMB_PACKET(("\tSize:%i",iSize));

    if(iSize<12)
        {
        NMB_PACKET(("\tERROR"));
        return;
        }


    NMB_PACKET(("\n\tType: \"%s\"",pNmbTypes[(pPacket[2]>>3)&15]));
    NMB_PACKET(("\n\tID=%04X  %04X",*(unsigned short*)pPacket,*(unsigned short*)(pPacket+2)));
    NMB_PACKET(("\n\tOP=%i RC=%i",(pPacket[2]>>3)&15,pPacket[3]&15));

    if(pPacket[2]&0x04)NMB_PACKET(("\tAA"));
    if(pPacket[2]&0x02)NMB_PACKET(("\tTC"));
    if(pPacket[2]&0x01)NMB_PACKET(("\tRD"));
    if(pPacket[3]&0x20)NMB_PACKET(("\tRA"));
    if(pPacket[3]&0x10)NMB_PACKET(("\tBCAST"));
    iQc=pPacket[4 ]*256+pPacket[5 ];
    iAc=pPacket[6 ]*256+pPacket[7 ];
    iNc=pPacket[8 ]*256+pPacket[9 ];
    iRc=pPacket[10]*256+pPacket[11];
    NMB_PACKET(("\n\tQC=%i\tAC=%i\tNC=%i\tRC=%i",iQc,iAc,iNc,iRc));

    pPacket+=12;

    if(iQc)
        {
        NMB_PACKET(("\n\tname='"));
        while(i=*pPacket)
            {
            memcpy(cBuffer,pPacket+1,i);
            cBuffer[i]=0;
            if(iQc)
                {
                for(j=0;j<32;j++)cBuffer[j]-='A';
                for(j=0;j<16;j++)cBuffer[j] =(cBuffer[j*2]<<4)+cBuffer[j*2+1];
                sprintf(cBuffer+15,"<%02X>",cBuffer[15]&0xFF);
                iQc=0;
                }

            NMB_PACKET(("%s",cBuffer));
            pPacket+=i+1;
            if(*pPacket)NMB_PACKET(("."));
            }
        pPacket++;
        NMB_PACKET(("'\t %04X %04X",*(unsigned short*)pPacket,*(unsigned short*)(pPacket+2)));
        pPacket+=4;
        }

    if(iNc)return;

    if(iRc||iAc)
        {
        iRc=1;
        NMB_PACKET(("\n\tname='"));
        while(i=*pPacket)
            {
            if(*pPacket==0xC0)
                {
                NMB_PACKET(("C0-0C              "));
                pPacket++;
                break;
                }

            memcpy(cBuffer,pPacket+1,i);
            cBuffer[i]=0;
            if(iRc)
                {
                for(j=0;j<32;j++)cBuffer[j]-='A';
                for(j=0;j<16;j++)cBuffer[j] =(cBuffer[j*2]<<4)+cBuffer[j*2+1];
                sprintf(cBuffer+15,"<%02X>",cBuffer[15]&0xFF);
                iRc=0;
                }
            NMB_PACKET(("%s",cBuffer));
            pPacket+=i+1;
            if(*pPacket)NMB_PACKET(("."));
            }
        pPacket++;
        NMB_PACKET(("'\t %04X %04X",*(unsigned short*)pPacket,*(unsigned short*)(pPacket+2)));
        pPacket+=4;
        iTtl =pPacket[0]*256*256*256;
        iTtl+=pPacket[1]*256*256;
        iTtl+=pPacket[2]*256;
        iTtl+=pPacket[3];
        i    =pPacket[4]*256;
        i   +=pPacket[5];
        NMB_PACKET(("\n\tTTL=%i SIZE=%i FLAG=%04X IP=%i.%i.%i.%i\n",iTtl,i,*(unsigned short*)(pPacket+6),pPacket[8],pPacket[9],pPacket[10],pPacket[11]));

        pPacket+=12;
        }


}
#else
#define     NmbPrintPacket(p,s)
#endif

//*****************************************************************************
//*
//*      NmbGetBlock
//*
//*****************************************************************************
//  coverts a name in upper cases
inline void NmbNameUpper(char *pName,int iSize)
{
    while(iSize>0)
        {
        if(*pName>='a' && *pName<='z')*pName+='A'-'a';
        pName++;
        iSize--;
        }

}

//*****************************************************************************
//*
//*      NmbGetBlock
//*
//*****************************************************************************
//  get the number of a packet buffer and lock it
//  block pointer = ucResiveBlock[i]
inline int NmbGetBlock()
{
int iBlock;


    SysSemaphoreLock(hBlockSema);

    iBlock=bit_find_0(ucResiveBits,MAX_RESIVE_BLOCKS);
    bit_set(ucResiveBits,iBlock);

    SysSemaphoreUnlock(hBlockSema);


return iBlock;
}

//*****************************************************************************
//*
//*      NmbFreeBlock
//*
//*****************************************************************************
//  unlock a packet buffer
inline void NmbFreeBlock(int iBlock)
{

    bit_clear(ucResiveBits,iBlock);

}

//*****************************************************************************
//*
//*      NmbGetSynch
//*
//*****************************************************************************
//  get a synch structer and lock it
static NmbSynch *NmbGetSynch(int bLock)
{
static int  iNextId=0;
static int  iStart=0;
int         iPos,iId;
NmbSynch   *pSynch;


    SysSemaphoreLock(hSynchSema);

    do  {                                               // find empty block
           iPos=bit_find_0_next(ucSynchBits,MAX_SYCNCH_BLOCKS,iStart);
        if(iPos<MAX_SYCNCH_BLOCKS)break;
           iPos=bit_find_0(ucSynchBits,iStart);
        }while(iPos>=iStart);


    iId=iNextId;
    iNextId++;
    iStart++;

    pSynch=nsSynchBlock+iPos;                           // init block
    pSynch->iBlock=-1;
    pSynch->uMsgId=(iId*MAX_SYCNCH_BLOCKS)+iPos;
    pSynch->uPos=iPos;
    pSynch->hSema=SysSemaphoreCreate();

    if(bLock)SysSemaphoreLock(pSynch->hSema);

    bit_set(ucSynchBits,iPos);

    SysSemaphoreUnlock(hSynchSema);



return pSynch;
}

//*****************************************************************************
//*
//*      NmbAddSynch
//*
//*****************************************************************************
//  assert a packet buffer to a synch structure
static int  NmbAddSynch(NmbSynch *pSynch,int iBlock)
{

    SysSemaphoreLock(hSyBlkSema);

    if(!bit_read(ucSynchBits,pSynch->uPos))
        {
        SysSemaphoreUnlock(hSyBlkSema);
        return FALSE;
        }

    if(pSynch->iBlock!=-1)
        {
        SysSemaphoreUnlock(hSyBlkSema);
        return FALSE;
        }

    pSynch->iBlock=iBlock;

    SysSemaphoreUnlock(hSyBlkSema);


return TRUE;
}

//*****************************************************************************
//*
//*      NmbFreeSynch
//*
//*****************************************************************************
//  release a synch structure
static void NmbFreeSynch(NmbSynch *pSynch)
{

    SysSemaphoreLock(hSyBlkSema);

    if(pSynch->iBlock>=0)
        {
        NmbFreeBlock(pSynch->iBlock);
        pSynch->iBlock=-1;
        }

    SysSemaphoreDelete(pSynch->hSema);
    pSynch->hSema=0;
    bit_clear(ucSynchBits,pSynch->uPos);

    SysSemaphoreUnlock(hSyBlkSema);
}


//*****************************************************************************
//*
//*      NmbRestartInterface
//*
//*****************************************************************************
static void NmbRestartInterface()
{
    NMB_ERR_MESSAGE(("\nRestart NMB Interface"));
    NmbStopDaemon();
    NmbDaemon(&sConfig);
    SysThreadExit();
}

//*****************************************************************************
//*
//*      NmbResive
//*
//*****************************************************************************
//  resive function for nmb packets
static void NmbResive(void *pParam)
{
unsigned short   wId;
IpAddr           iFrom;
NmbSynch        *pSynch;
unsigned char   *pBlock=0;
unsigned short   usPort;
int              iBlock=-1;
int              iError=0;
int              iSize;


    #if NMB_PRINT
    IpAddr iAddr;
    UdpGetAddr(sUdpInterface.hNmb,&iAddr);
    NMB_MESSAGE(("\nNmbResive on %u.%u.%u.%u\n",GetIpV4(&iAddr)&0xFF,(GetIpV4(&iAddr)>>8)&0xFF,(GetIpV4(&iAddr)>>16)&0xFF,(GetIpV4(&iAddr)>>24)&0xFF));
    #endif

    sUdpInterface.bRun=TRUE;

    while(bNmbIsStarted)
        {
        if(iBlock==-1)
            {
            iBlock=NmbGetBlock();
            pBlock=ucResiveBlock[iBlock];
            }

            iSize=UdpGet(sUdpInterface.hNmb,&iFrom,pBlock,BLOCK_SIZE,&usPort);
        if( iSize<6)
            {
            if(iSize<0)iError++;
            if(iError>4)NmbRestartInterface();
            SysSleep(50);
            continue;
            }

        uNmbResvPackets++;

        iError=0;

        #ifdef NMB_PRINT_RESV
        NMB_PRINT_LOCK();
        NMB_MESSAGE(("\nNmbResive: on %u.%u.%u.%u --->",GetIpV4(&iFrom)&0xFF,(GetIpV4(&iFrom)>>8)&0xFF,(GetIpV4(&iFrom)>>16)&0xFF,(GetIpV4(&iFrom)>>24)&0xFF));
        NmbPrintPacket(pBlock,iSize);
        NMB_PRINT_UNLOCK();
        #endif

        if(pBlock[2]&0x80)                              // check response flag 
           {
               wId=*(unsigned short*)pBlock;
               pSynch=nsSynchBlock+(wId&SYCNCH_MASK);
            if(pSynch->uMsgId!=wId)continue;
            if(!NmbAddSynch(pSynch,iBlock))continue;

            SysSemaphoreLock(hSyBlkSema);
            if(pSynch->hSema)SysSemaphoreUnlock(pSynch->hSema);
            SysSemaphoreUnlock(hSyBlkSema);

            iBlock=-1;
            continue;
            }

        if(NmbResiveReq(pBlock,iBlock,&iFrom,usPort))iBlock=-1;
        }

    if(iBlock!=-1)NmbFreeBlock(iBlock);
    sUdpInterface.bRun=FALSE;

}

//*****************************************************************************
//*
//*      NmbRefresh
//*
//*****************************************************************************
//  resive function for nmb names
static void NmbRefresh(void *pParam)
{
SysTime ulLastRefresh,ulNow,ulLastElection,ulLastQuery;
IpAddr  ipAddr;
int     bOk;


    bNmbRunRefresh=TRUE;

    sConfig.cHostname [15]=0x00;NmbAddNameNoWait(sConfig.cHostname ,sConfig.cDomain,0);
    sConfig.cHostname [15]=0x03;NmbAddNameNoWait(sConfig.cHostname ,sConfig.cDomain,0);
    sConfig.cHostname [15]=0x20;NmbAddNameNoWait(sConfig.cHostname ,sConfig.cDomain,0);
    sConfig.cWorkgroup[15]=0x00;NmbAddNameNoWait(sConfig.cWorkgroup,sConfig.cDomain,1);
    sConfig.cWorkgroup[15]=0x1E;NmbAddNameNoWait(sConfig.cWorkgroup,sConfig.cDomain,1);

    SysSleep(ADD_TIMEOUT*4);
    sConfig.cHostname [15]=0x00;
    sConfig.cWorkgroup[15]=0x1D;
    DgrAnnounce(sConfig.cHostname,sConfig.cDomain,0,sConfig.cWorkgroup);
    SysSleep(ADD_TIMEOUT);

    sConfig.cWorkgroup[15]=0x00;
    sConfig.cWorkgroup[15]=0x1E;
    DgrElectionStart(sConfig.cHostname,sConfig.cDomain,0,sConfig.cWorkgroup);

    ulLastRefresh=ulLastQuery=SysTickCount();

    while(bNmbIsStarted)
        {
        SysSleep(2000);
        ulNow=SysTickCount();
        if(ulNow-ulLastRefresh<DRG_REFRESH)continue;

        ulLastElection=DgrLastElection();

        if(ulNow-ulLastQuery>DRG_REFRESH*2)             // is local master presend 
            {
            sConfig.cWorkgroup[15]=0x1D;
            bOk=NmbQueryName(sConfig.cWorkgroup,0,&ipAddr);
            if(!bOk)ulLastElection=0;
            ulLastQuery=ulNow;
            }

        if(!ulLastElection || ulNow-ulLastElection>DRG_ELREFRESH)
            {
            NMB_MESSAGE(("\nNmbRefresh Election"));
            sConfig.cHostname [15]=0x00;NmbAddNameNoWait(sConfig.cHostname ,sConfig.cDomain,0);
            sConfig.cHostname [15]=0x03;NmbAddNameNoWait(sConfig.cHostname ,sConfig.cDomain,0);
            sConfig.cHostname [15]=0x20;NmbAddNameNoWait(sConfig.cHostname ,sConfig.cDomain,0);
            sConfig.cWorkgroup[15]=0x00;NmbAddNameNoWait(sConfig.cWorkgroup,sConfig.cDomain,1);
            sConfig.cWorkgroup[15]=0x1E;NmbAddNameNoWait(sConfig.cWorkgroup,sConfig.cDomain,1);

            SysSleep(ADD_TIMEOUT*4);
            sConfig.cHostname [15]=0x00;
            sConfig.cWorkgroup[15]=0x1D;
            DgrAnnounce(sConfig.cHostname,sConfig.cDomain,0,sConfig.cWorkgroup);
            SysSleep(ADD_TIMEOUT);

            sConfig.cWorkgroup[15]=0x00;
            sConfig.cWorkgroup[15]=0x1E;
            DgrElectionStart(sConfig.cHostname,sConfig.cDomain,0,sConfig.cWorkgroup);
            ulLastQuery=ulLastRefresh=SysTickCount();
            continue;
            }


        NMB_MESSAGE(("\nNmbRefresh Announce"));
        sConfig.cHostname [15]=0x00;
        sConfig.cWorkgroup[15]=0x1D;
        DgrAnnounce(sConfig.cHostname,sConfig.cDomain,0,sConfig.cWorkgroup);
        ulLastRefresh=SysTickCount();
        }

    bNmbRunRefresh=FALSE;

}

//*****************************************************************************
//*
//*      NmbPutName
//*
//*****************************************************************************
//  save a netbios name in a buffer
//  pBuffer : pointer to buffer (min size 256 byte)
//  pName   : pointer to windows name (15 byte name + 1 byte type)
//  pDomain : pointer to the domain name
//  return the written byte into the buffer
int NmbPutName(char *pBuffer,const char *pName,const char *pDomain)
{
int             iSize,iLen;
char           *pStr,*pNext;
unsigned char   c;



    for(iSize=0;iSize<16;iSize++)
        {
        c=pName[iSize];
        pBuffer[iSize*2+1] = 'A' + (c>>4 );
        pBuffer[iSize*2+2] = 'A' + (c&0xF);
        }

    pBuffer[0]  = 32;
    pBuffer[33] = 0;
    iSize=34;

    if(pDomain && *pDomain)                                 // add domain name 
        {
        iLen=strlen(pDomain)+1;
        iSize+=iLen;
        memcpy(pBuffer+34,pDomain,iLen);
        pStr=pBuffer+34;

        while(pNext=strchr(pStr,'.'))
            {
            pStr[-1]=pNext-pStr;
            pStr    =pNext+1;
            }

        pStr[-1]=strlen(pStr);
        }




return iSize;
}

//*****************************************************************************
//*
//*      NmbNameSize
//*
//*****************************************************************************
//  return the name lenght in a buffer
static int  NmbNameSize(unsigned char *pName)
{
int iSize;

    if((pName[0]&0xC0)==0xC0)return 2;
    for(iSize=0;pName[iSize];iSize+=pName[iSize]+1);

return iSize+1;
}

//*****************************************************************************
//*
//*      NmbGetName
//*
//*****************************************************************************
//  save a netbios name from a buffer
//  pName   : pointer to the name in a Block
//  pWinName: buffer for 16 byte windows name
//  pBuffer : pointer to buffer (min size 256 byte)
//  iSize   : the size of the buffer
//  return thename length
int  NmbGetName(unsigned char *pName,char *pWinName,char *pPuffer,int iSize)
{
int             i,iPos=0,iAnz;
unsigned char  *pStart=pName;



    if(pName[0]!=32)
        {
        pName[0]=0;
        return 0;
        }

    pName++;

    for(i=0;i<16;i++)
        {
        pWinName[i]=((pName[i<<1]-'A')<<4)|(pName[(i<<1)+1]-'A');
        }

    iPos=0;
    pName+=32;

    while(*pName)
        {
        iAnz=*pName;
        pName++;

        if(iPos+iAnz+2>=iSize)
            {
            pName[0]=0;
            return 0;
            }

        pPuffer[iPos]='.';
        iPos++;
        memcpy(pPuffer+iPos,pName,iAnz);
        pName+=iAnz;
        }


    pPuffer[iPos]=0;


return pName-pStart+1;
}

//*****************************************************************************
//*
//*      NmbAddNameNoWait
//*
//*****************************************************************************
//  adds a new name in the network wtih out waiting
//  pName   : 16 Byte long hostname, byte 15 is the type,
//            the rest must be filled with spaces
//  pDomain : is the domain name (zero or "" for none)
//  bGroup  : is the name is a groub
static void _cdecl NmbAddNameNoWait1(void *pParam)
{
AddNameStruct   *pAdd=(AddNameStruct*)pParam;
char             cName[1024];
int              iLen=0;
int              bGroup;



    if(pAdd->pDomain)
        {
        iLen=strlen(pAdd->pDomain)+1;
        if(iLen>sizeof(cName)-16)return;
        memcpy(cName+16,pAdd->pDomain,iLen);
        }
    else{
        cName[16]=0;
        }

    memcpy(cName,pAdd->pName,16);
    bGroup=pAdd->bGroup;
    SysSemaphoreUnlock(pAdd->hSem);

    NmbAddName(cName,cName+16,bGroup);

}

NMB_API void NmbAddNameNoWait(const char *pName,const char *pDomain,int  bGroup)
{
AddNameStruct   sAdd;


    sAdd.pName   = pName;
    sAdd.pDomain = pDomain;
    sAdd.bGroup  = bGroup;
    sAdd.hSem    = SysSemaphoreCreate();

    SysSemaphoreLock(sAdd.hSem);
    SysThreadStart(NmbAddNameNoWait1,0x4000,&sAdd,-4,"NMB Add Name");
    SysSemaphoreLock(sAdd.hSem);
    SysSemaphoreDelete(sAdd.hSem);



}

//*****************************************************************************
//*
//*      NmbAddName
//*
//*****************************************************************************
//  adds a new name in the network
//  pName   : 16 Byte long hostname, byte 15 is the type,
//            the rest must be filled with spaces
//  pDomain : is the domain name (zero or "" for none)
//  bGroup  : is the name is a groub
//  returns TRUE if the name was added
NMB_API int NmbAddName(const char *pName,const char *pDomain,int  bGroup)
{
char            cBuffer[600];
int             iPos,iSize,i;
NmbSynch       *pSynch;
NameDbEntry     sDbEntry;








    SETW(cBuffer,2,0x1029);                         // build NAME REGISTRATION REQUEST packet
    SETD(cBuffer,4,0x00000100);
    SETD(cBuffer,8,0x01000000);

    iSize=NmbPutName(cBuffer+12,pName,pDomain);
    iPos=12+iSize;
    SETD(cBuffer,iPos,0x01002000);                      iPos+=4;
    SETW(cBuffer,iPos,0x0CC0);                          iPos+=2;
    SETD(cBuffer,iPos,0x01002000);                      iPos+=4;
    SETD(cBuffer,iPos,LSWAP(LIVETIME));                 iPos+=4;
    SETD(cBuffer,iPos,(bGroup)? 0x00800600:0x00000600); iPos+=4;
    SETA(cBuffer,iPos,sUdpInterface.ipSocket);          iPos+=4;

    pSynch=NmbGetSynch(1);
    SETW(cBuffer,0,pSynch->uMsgId);

    #ifdef NMB_PRINT_SEND
    NmbPrintPacket(cBuffer,iPos+4);
    #endif


    for(i=0;i<3;i++)                                // send packets
        {
        if(UdpPut(sUdpInterface.hNmb,&sUdpInterface.ipBroadcast,cBuffer,iPos)>0)uNmbSendPackets++;
        if(SysSemaphoreLockWait(pSynch->hSema,ADD_TIMEOUT))break;
        }


    if(i>=3)
        {
        NmbFreeSynch(pSynch);
                                                    // broadcast NAME UPDATE REQUEST packet
        cBuffer[2]=0x28;
        NMB_MESSAGE(("\n NAME UPDATE REQUEST  \"%-15.15s<%02X>\"",pName,pName[15]));
        #ifdef NMB_PRINT_SEND
        NmbPrintPacket(cBuffer,iPos+4);
        #endif

        if(UdpPut(sUdpInterface.hNmb,&sUdpInterface.ipBroadcast,cBuffer,iPos)>0)uNmbSendPackets++;

        sDbEntry.wGroup   = (bGroup)? 1:0;
        sDbEntry.cType    = DB_LOCAL;
        sDbEntry.ipAddr   = NULL_IP;
        sDbEntry.tTimeout = LIVETIME;
        memcpy(sDbEntry.cName,pName,sizeof(sDbEntry.cName));

        if(pDomain && *pDomain)
            {
            strncpy (cBuffer,pDomain,sizeof(cBuffer));
            StrUpper(cBuffer);
            pDomain=cBuffer;
            }

        NmbNameUpper(sDbEntry.cName,15);
        DbAddEntry(&sDbEntry,pDomain);

        return TRUE;
        }

    NMB_MESSAGE(("\nNAME UPDATE REQUEST  fails"));

    /*
    if(pSynch->iBlock>=0)
        {
        pBlock=ucResiveBlock[pSynch->iBlock];
        // NEGATIVE NAME REGISTRATION RESPONSE
        } */

    NmbFreeSynch(pSynch);



return FALSE;
}


//*****************************************************************************
//*
//*      NmbOverwriteName
//*
//*****************************************************************************
//  overwrite an existing name in the network
//  pName   : 16 Byte long hostname, byte 15 is the type,
//            the rest must be filled with spaces
//  pDomain : is the domain name (zero or "" for none)
//  bGroup  : is the name is a groub
//  returns TRUE if the name was added
NMB_API int  NmbOverwriteName(const char *pName,const char *pDomain,int  bGroup)
{
char            cBuffer[600];
int             iPos,iSize,i;
NmbSynch       *pSynch;
NameDbEntry     sDbEntry;






    SETW(cBuffer,2,0x1028);                         // build NAME OVERWRITE REQUEST packet
    SETD(cBuffer,4,0x00000100);
    SETD(cBuffer,8,0x01000000);

    iSize=NmbPutName(cBuffer+12,pName,pDomain);
    iPos=12+iSize;
    SETD(cBuffer,iPos,0x01002000);                      iPos+=4;
    SETW(cBuffer,iPos,0x0CC0);                          iPos+=2;
    SETD(cBuffer,iPos,0x01002000);                      iPos+=4;
    SETD(cBuffer,iPos,LSWAP(LIVETIME));                 iPos+=4;
    SETD(cBuffer,iPos,(bGroup)? 0x00800600:0x00000600); iPos+=4;
    SETA(cBuffer,iPos,sUdpInterface.ipSocket);          iPos+=4;

    pSynch=NmbGetSynch(1);
    SETW(cBuffer,0,pSynch->uMsgId);

    #ifdef NMB_PRINT_SEND
    NmbPrintPacket(cBuffer,iPos+4);
    #endif

    for(i=0;i<3;i++)                                // send packets
        {
        if(UdpPut(sUdpInterface.hNmb,&sUdpInterface.ipBroadcast,cBuffer,iPos)>0)uNmbSendPackets++;
        if(SysSemaphoreLockWait(pSynch->hSema,ADD_TIMEOUT))break;
        }


    if(i>=3)
        {
        NmbFreeSynch(pSynch);

                                                    // broadcast NAME OVERWRITE REQUEST packet
        cBuffer[2]=0x28;
        NMB_MESSAGE(("\nNAME OVERWRITE REQUEST  \"%-15.15s<%02X>\"",pName,pName[15]));
        #ifdef NMB_PRINT_SEND
        NmbPrintPacket(cBuffer,iPos+4);
        #endif

        if(UdpPut(sUdpInterface.hNmb,&sUdpInterface.ipBroadcast,cBuffer,iPos)>0)uNmbSendPackets++;

        sDbEntry.wGroup   = (bGroup)? 1:0;
        sDbEntry.cType    = DB_LOCAL;
        sDbEntry.ipAddr   = NULL_IP;
        sDbEntry.tTimeout = LIVETIME;
        memcpy(sDbEntry.cName,pName,sizeof(sDbEntry.cName));

        if(pDomain && *pDomain)
            {
            strncpy (cBuffer,pDomain,sizeof(cBuffer));
            StrUpper(cBuffer);
            pDomain=cBuffer;
            }

        NmbNameUpper(sDbEntry.cName,15);
        DbAddEntry(&sDbEntry,pDomain);

        return TRUE;
        }

    NMB_MESSAGE(("\nNAME UPDATE REQUEST  fails"));

    /*
    if(pSynch->iBlock>=0)
        {
        pBlock=ucResiveBlock[pSynch->iBlock];
        // NEGATIVE NAME REGISTRATION RESPONSE
        } */

    NmbFreeSynch(pSynch);



return FALSE;
}

//*****************************************************************************
//*
//*      NmbRefreshName
//*
//*****************************************************************************
//  refresh a name in the network
//  pName   : 16 Byte long hostname, byte 15 is the type,
//            the rest must be filled with spaces
//  pDomain : is the domain name (zero or "" for none)
//  bGroup  : is the name is a groub
//  returns TRUE if the name was refreshed
NMB_API int  NmbRefreshName(const char *pName,const char *pDomain,int bGroup)
{
char            cBuffer[600];
int             iPos,iSize,i;
NmbSynch       *pSynch;
NameDbEntry     sDbEntry;






    SETW(cBuffer,2,0x1049);                         // build NAME REFRESH REQUEST packet
    SETD(cBuffer,4,0x00000100);
    SETD(cBuffer,8,0x01000000);

    iSize=NmbPutName(cBuffer+12,pName,pDomain);
    iPos=12+iSize;
    SETD(cBuffer,iPos,0x01002000);                      iPos+=4;
    SETW(cBuffer,iPos,0x0CC0);                          iPos+=2;
    SETD(cBuffer,iPos,0x01002000);                      iPos+=4;
    SETD(cBuffer,iPos,LSWAP(LIVETIME));                 iPos+=4;
    SETD(cBuffer,iPos,(bGroup)? 0x00800600:0x00000600); iPos+=4;
    SETA(cBuffer,iPos,sUdpInterface.ipSocket);          iPos+=4;

    pSynch=NmbGetSynch(1);
    SETW(cBuffer,0,pSynch->uMsgId);

    #ifdef NMB_PRINT_SEND
    NmbPrintPacket(cBuffer,iPos+4);
    #endif

    for(i=0;i<3;i++)                                // send packets
        {
        if(UdpPut(sUdpInterface.hNmb,&sUdpInterface.ipBroadcast,cBuffer,iPos)>0)uNmbSendPackets++;
        if(SysSemaphoreLockWait(pSynch->hSema,REF_TIMEOUT))break;
        }

    if(i>=3)
        {
        NmbFreeSynch(pSynch);

                                                    // broadcast NAME UPDATE REQUEST packet
        cBuffer[2]=0x28;
        NMB_MESSAGE(("\nNAME UPDATE REQUEST"));
        #ifdef NMB_PRINT_SEND
        NmbPrintPacket(cBuffer,iPos+4);
        #endif

        if(UdpPut(sUdpInterface.hNmb,&sUdpInterface.ipBroadcast,cBuffer,iPos)>0)uNmbSendPackets++;

        sDbEntry.wGroup   = (bGroup)? 1:0;
        sDbEntry.cType    = DB_LOCAL;
        sDbEntry.ipAddr   = NULL_IP;
        sDbEntry.tTimeout = LIVETIME;
        memcpy(sDbEntry.cName,pName,sizeof(sDbEntry.cName));

        if(pDomain && *pDomain)
            {
            strncpy (cBuffer,pDomain,sizeof(cBuffer));
            StrUpper(cBuffer);
            pDomain=cBuffer;
            }

        NmbNameUpper(sDbEntry.cName,15);
        DbAddEntry(&sDbEntry,pDomain);

        return TRUE;
        }

    /*
    if(pSynch->iBlock>=0)
        {
        pBlock=ucResiveBlock[pSynch->iBlock];
        // NEGATIVE NAME REGISTRATION RESPONSE
        } */

    NmbFreeSynch(pSynch);



return FALSE;
}

//*****************************************************************************
//*
//*      NmbResiveReq
//*
//*****************************************************************************
//  Handles a revived packet
//  pBlock      : pointer to the 
//  iBlock      : number of the packet buffer
//  pFrom       : pointer to the incomming ip address
//  usPort      : incomming UDP port
//  Retuns TRUE if the packet was taken.
static int NmbResiveReq(unsigned char *pBlock,int iBlock,IpAddr *pFrom,unsigned short usPort)
{
int             iType,iSize;
char            cName[256];
unsigned char  *pPtr,*pNew;
NameDbEntry    *pNameDb,sDbName;
IpAddr          ipResv;



    iType=(pBlock[2]>>3)&15;


    switch(iType)
        {
    case 5:                         // NAME REGISTRATION REQUEST

        if(GETD(pBlock,4)!=0x00000100)return FALSE;
        if(GETD(pBlock,8)!=0x01000000)return FALSE;

        pPtr =pBlock+12;
        iSize=NmbGetName(pPtr,sDbName.cName,cName,sizeof(cName));
        if(!iSize)return FALSE;
        pPtr+=iSize;
        if(GETD(pPtr,0)!=0x01002000)return FALSE;
        pPtr+=4;
        pPtr+=NmbNameSize(pPtr);
        if(GETD(pPtr,0)!=0x01002000)return FALSE;
        pPtr+=4;
        if(GETW(pPtr,4)!=0x0600)return FALSE;
        GETA(pPtr,8,ipResv);

        StrUpper(cName);
        NmbNameUpper(sDbName.cName,15);

        if(pPtr[6]&0x80)            // group name
            {
            pNameDb=DbFindEntry(&sDbName,cName,0);
            if(!pNameDb)return FALSE;
            if( pNameDb->cType!=DB_LOCAL){DbUnlock();return FALSE;}
            if( pNameDb->wGroup         ){DbUnlock();return FALSE;}
            SETW(pBlock,2,0x87AD);
            DbUnlock();
            }
        else{                       // unique name
                pNameDb=DbFindEntry(&sDbName,cName,0);
            if(!pNameDb)return FALSE;
            if( pNameDb->cType!=DB_LOCAL){DbUnlock();return FALSE;}
            SETW(pBlock,2,0x86AD);
            DbUnlock();
            }

        SETD(pBlock,4,0x01000000);
        SETD(pBlock,8,0x00000000);

        pNew=pBlock+12+iSize+4;
        memcpy(pNew,pPtr,8);
        SETA(pNew,8,sUdpInterface.ipSocket);
        pNew+=12;

                                    // send NEGATIVE NAME REGISTRATION RESPONSE
        #ifdef NMB_PRINT_SEND
        NMB_PRINT_LOCK();
        NMB_MESSAGE(("\nNEGATIVE NAME REGISTRATION RESPONSE:"));
        NmbPrintPacket(pBlock,pNew-pBlock);
        NMB_PRINT_UNLOCK();
        #endif

        if(UdpPutTo(sUdpInterface.hNmb,&ipResv,pBlock,pNew-pBlock,usPort)>0)
            {
            uNmbSendPackets++;
            }

        if(usPort!=NMB_PORT)
        if(UdpPutTo(sUdpInterface.hNmb,&ipResv,pBlock,pNew-pBlock,NMB_PORT)>0)
            {
            uNmbSendPackets++;
            }

        return FALSE;

    case 0:                         // NAME QUERY REQUEST

        if(GETD(pBlock,4)!=0x00000100)return FALSE;
        if(GETD(pBlock,8)!=0x00000000)return FALSE;

        pPtr =pBlock+12;
        iSize=NmbGetName(pPtr,sDbName.cName,cName,sizeof(cName));
        if(!iSize)return FALSE;
        pPtr+=iSize;
        if(GETD(pPtr,0)!=0x01002000)return FALSE;

        sDbName.wGroup=0;
        sDbName.ipAddr=NULL_IP;

        StrUpper(cName);
        NmbNameUpper(sDbName.cName,15);

            pNameDb=DbFindEntry(&sDbName,cName,1);
        if(!pNameDb)return FALSE;
        if( pNameDb->cType!=DB_LOCAL){DbUnlock();return FALSE;}


        SETW(pBlock,2,0x0085);
        SETD(pBlock,4,0x01000000);
        SETD(pBlock,8,0x00000000);
        SETD(pPtr, 4,LSWAP(LIVETIME));
        SETD(pPtr, 8,(pNameDb->wGroup)? 0x00800600:0x00000600);
        SETA(pPtr,12,sUdpInterface.ipSocket);
        pPtr+=16;
        DbUnlock();
                                    // send POSITIVE NAME QUERY RESPONSE
        #ifdef NMB_PRINT_SEND
        NMB_PRINT_LOCK();
        NMB_MESSAGE(("\nPOSITIVE NAME QUERY RESPONSE:"));
        NmbPrintPacket(pBlock,pPtr-pBlock);
        NMB_PRINT_UNLOCK();
        #endif

        if(UdpPutTo(sUdpInterface.hNmb,pFrom,pBlock,pPtr-pBlock,usPort)>0)
            {
            uNmbSendPackets++;
            }

        if(usPort!=NMB_PORT)
        if(UdpPutTo(sUdpInterface.hNmb,pFrom,pBlock,pPtr-pBlock,NMB_PORT)>0)
            {
            uNmbSendPackets++;
            }

        return FALSE;

    case 6:                         // NAME RELEASE REQUEST

        if(GETD(pBlock,4)!=0x00000100)return FALSE;
        if(GETD(pBlock,8)!=0x01000000)return FALSE;


        pPtr=pBlock+12;
        iSize=NmbGetName(pPtr,sDbName.cName,cName,sizeof(cName));
        if(!iSize)return FALSE;
        pPtr+=iSize;
        if(GETD(pPtr,0)!=0x01002000)return FALSE;
        pPtr+=4;
        pPtr+=NmbNameSize(pPtr);
        if(GETD(pPtr,0)!=0x01002000)return FALSE;
        pPtr+=4;
        if(GETW(pPtr,4)!=0x0600)return FALSE;
        GETA(pPtr,8,ipResv);

        sDbName.ipAddr=ipResv;

        StrUpper(cName);
        NmbNameUpper(sDbName.cName,15);

            pNameDb=DbFindEntry(&sDbName,cName,1);
        if(!pNameDb)return FALSE;
        if( pNameDb->cType==DB_LOCAL){DbUnlock();return FALSE;}

        DbUnlock();
        DbDelEntry(pNameDb,cName);

        return FALSE;
        }



return FALSE;
}



//*****************************************************************************
//*
//*      NmbExit
//*
//*****************************************************************************
//  Disconnets the nmb server.
NMB_API int NmbStopDaemon()
{
int     i;
int     bOk;


    if(!bNmbIsStarted)return NMB_ERR_ISNOTRUNNING;

    bNmbIsStarted=FALSE;
    UdpClose(sUdpInterface.hNmb);
    sUdpInterface.hNmb=0;
    bOk=DgrStopDaemon();

    if(bCrateTempDb && DbIsOpen())                  // close the database
        {
        bCrateTempDb=FALSE;
        DbClose();
        }

    for(i=0;i<16;i++)
        {
        if(!sUdpInterface.bRun && bNmbRunRefresh)break;
        SysSleep(200);
        if(i==15)
            {
            bNmbIsStarted=TRUE;
            return NMB_ERR_ISRUNNING;
            }
        }

    SysSemaphoreDelete(hBlockSema);hBlockSema=0;
    SysSemaphoreDelete(hSynchSema);hSynchSema=0;
    SysSemaphoreDelete(hSyBlkSema);hSynchSema=0;
    SysSemaphoreDelete(hSyUdpSema);hSyUdpSema=0;



return (bOk)? NMB_ERR_NONE:NMB_ERR_DGRAM;
}

//*****************************************************************************
//*
//*      NmbQueryName
//*
//*****************************************************************************
//  Query in the net for a computer.
//  pName   : 16 Byte long hostname, byte 15 is the type,
//            the rest must be filled with spaces
//  pDomain : is the domain name (zero or "" for none)
//  pIpAddr : if the computer was found there will save the ip-addres
//  returns TRUE if the the computer was found
NMB_API int NmbQueryName(const char *pName,const char *pDomain,IpAddr *pIpAddr)
{
unsigned char  *pBlock;
char            cBuffer[600];
int             iPos,iSize,iFlags,i;
int             iLivetime,iType;
NmbSynch       *pSynch;
int             bOk;





    *pIpAddr=NULL_IP;                               // build NAME QUERY REQUEST packet

    SETW(cBuffer,2,0x1001);
    SETD(cBuffer,4,0x00000100);
    SETD(cBuffer,8,0x00000000);

    iSize=NmbPutName(cBuffer+12,pName,pDomain);
    iPos=12+iSize;
    SETD(cBuffer,iPos,0x01002000);
    iPos+=4;

    pSynch=NmbGetSynch(1);
    SETW(cBuffer,0,pSynch->uMsgId);



    for(i=0;i<3;i++)                                // send packets
        {
        if(UdpPut(sUdpInterface.hNmb,&sUdpInterface.ipBroadcast,cBuffer,iPos)>0)
            {
            uNmbSendPackets++;
            }

        if(SysSemaphoreLockWait(pSynch->hSema,QUERY_TIMEOUT))break;
        }

    if(i>=3)                                        // no response
        {
        NmbFreeSynch(pSynch);
        return FALSE;
        }


    pBlock=ucResiveBlock[pSynch->iBlock];
    bOk=TRUE;

    if(GETW(pBlock,2)!=0x0085    )bOk=FALSE;
    if(GETD(pBlock,4)!=0x01000000)bOk=FALSE;
    if(GETD(pBlock,8)!=0x00000000)bOk=FALSE;

    if(bOk)
        {
        iPos = NmbNameSize(pBlock+12)+12;
        iType     = GETD(pBlock,iPos);
        iLivetime = GETD(pBlock,iPos+4);
        iSize     = GETW(pBlock,iPos+8);
        iFlags    = GETW(pBlock,iPos+10);

        if(iType!=0x01002000)bOk=FALSE;
        if(iSize!=0x0600    )bOk=FALSE;

        if(bOk)GETA(pBlock,iPos+12,*pIpAddr);
        }

    NmbFreeSynch(pSynch);


return bOk;
}

//*****************************************************************************
//*
//*      NmbDaemon
//*
///*****************************************************************************
//  Starts the NetBios name server.
NMB_API int NmbDaemon(NmbConfigData *pConfig)
{
IpAddr          ipBroadcast,ipSocket;
UdpHandle       hNmb;
int             iLen;



    if(bNmbIsStarted)return NMB_ERR_ISRUNNING;


    if(!DbIsOpen())                                 // open the database
        {
        bCrateTempDb=TRUE;
        DbOpen(0,0,0);
        }


    memcpy(&sConfig,pConfig,sizeof(sConfig));

    if(!IpAddress(&ipSocket,sConfig.cIpAddress,0))
        {
        return NMB_ERR_WRONGIP;
        }

    if(!IpAddress(&ipBroadcast,sConfig.cIpAddress,sConfig.cSubNetMask))
        {
        return NMB_ERR_WRONGNET;
        }


    if(IsIpV6(&ipSocket   ))return NMB_ERR_IPV6;    // ipv6 not allowed
    if(IsIpV6(&ipBroadcast))return NMB_ERR_IPV6;


        hNmb = UdpOpen(&ipSocket,NMB_PORT,TRUE,FALSE);
    if(!hNmb)
        {
        return NMB_ERR_SOCKET;;
        }

    sUdpInterface.hNmb        = hNmb;
    sUdpInterface.ipSocket    = ipSocket;
    sUdpInterface.ipBroadcast = ipBroadcast;
    sUdpInterface.bRun        = 0;


    if(!DgrDaemon(sUdpInterface.ipSocket,sUdpInterface.ipBroadcast,sConfig.iPriority))
        {
        UdpClose(sUdpInterface.hNmb);
        return NMB_ERR_DGRAM;
        }

    bNmbIsStarted=1;                                // init all struchtures

    memset(ucResiveBits,0,sizeof(ucResiveBits));
    memset(ucSynchBits ,0,sizeof(ucSynchBits ));

    hBlockSema = SysSemaphoreCreate();
    hSynchSema = SysSemaphoreCreate();
    hSyBlkSema = SysSemaphoreCreate();
    hSyUdpSema = SysSemaphoreCreate();

    if(!hBlockSema || !hSynchSema || !hSyBlkSema)
        {
        return NMB_ERR_INIT;
        }


       iLen=strlen(sConfig.cHostname);
    if(iLen>15)iLen=15;
    memset(sConfig.cHostname+iLen,' ',16-iLen);
    memcpy(cMyName,sConfig.cHostname,iLen);
    cMyName[iLen]=0;

       iLen=strlen(sConfig.cWorkgroup);
    if(iLen>15)iLen=15;
    memset(sConfig.cWorkgroup+iLen,' ',16-iLen);
    memcpy(cMyWorkgroup,sConfig.cWorkgroup,iLen);
    cMyWorkgroup[iLen]=0;

                                                    // start recieve thread
    SysThreadStart(NmbResive ,0x2000,0,sConfig.iPriority|SYS_GLOBAL,"NMB Revive");
    SysThreadStart(NmbRefresh,0x2000,0,sConfig.iPriority|SYS_GLOBAL,"NMB Refresh");


    NMB_MESSAGE(("\nNmbDaemon() is started"));


return  NMB_ERR_NONE;
}

