//*****************************************************************************
//*
//*
//*      NameDb.h
//*
//*
//*****************************************************************************
#ifndef     __NAMEDB_H__
#define     __NAMEDB_H__


#include    "System/SocketUtility.h"
#include    "System/System.h"
#include    <time.h>

#define     DB_NAME_SIZE        16
#define     DB_DOMAIN_SIZE      (256-DB_NAME_SIZE*2)


// Values for NameDbEntry.cType 

#define     DB_LOCAL            0
#define     DB_EXTERN           1


// Error codes 

#define     DB_ERR_NONE         0           // No error 
#define     DB_ERR_ISOPEN       1           // Database is allready open 
#define     DB_ERR_OPEN         2           // Database couln't open 
#define     DB_ERR_WRITE        3           // Cant't write into database 
#define     DB_ERR_READ         4           // Cant't read from database 
#define     DB_ERR_FILE         5           // Wrong database file 
#define     DB_ERR_MEM          6           // Not enougth memory 
#define     DB_ERR_EXIST        7           // Entry exist 
#define     DB_ERR_DOMAIN       8           // Wrong domain name 
#define     DB_ERR_NOTEXIST     9           // Entry doesn't exist 
#define     DB_ERR_LOCK         10          // Entry is locked 
#define     DB_ERR_INIT         11          // Database is not initialiced  
#define     DB_ERR_ISFILE       12          // Database is in a file 

typedef     time_t        TimeDb;

extern int  iDbError;

typedef struct
    {
    char            cName[DB_NAME_SIZE];    // Windos name 
    unsigned        uDomain;                // Index for the domain name 
    IpAddr          ipAddr;                 // Target address of the entry 
    TimeDb          tTimeout;               // Time for entry reload 
    unsigned short  wGroup;                 // Is name a groupname 0=unique 1=group 
    char            cType;                  // Address type DB_LOCAL,DB_EXTERN... 
    }NameDbEntry;


    int             DbOpen       (const char *pDbName,const char *pDbDomain,int bFile);
    int             DbClose      ();
    int             DbFlush      ();
    int             DbIsOpen     ();
                 
    int             DbAddEntry   (const NameDbEntry *pEntry,const char *pDomain);
    int             DbDelEntry   (const NameDbEntry *pEntry,const char *pDomain);
    NameDbEntry    *DbFindEntry  (const NameDbEntry *pEntry,const char *pDomain,int bUseIp);


    inline int      DbError      (){return iDbError;} 
    NameDbEntry    *DbIndexEntry (unsigned  uIndex);
    const char     *DbDomainName (unsigned  uIndex);
    unsigned        DbIndexMax   ();
    void            DbUnlock     ();
    void            DbLock       ();




#endif 

