//*****************************************************************************
//*
//*
//*     SmbDemo.cpp
//*
//*
//*****************************************************************************
//
//  this is a demo for an smb server for OnTime RTOS
//
//
//  Copyright  2007    Anton Zechner
//
//  AzSmb is distributed under the GNU GENERAL PUBLIC LICENSE (GPL)
//  Sourcecode which use AzSmb must be published. Commercial users
//  must published their code too, or make an licence agreement with me.
//
//
//  AzSmb wird unter GNU GENERAL PUBLIC LICENSE (GPL) vertreiben.
//  Sourcecode welcher AzSmb verwendet muss verffentlicht werden.
//  Kommerzielle Nutzer mssen ihren Code ebenfalls verffentlichen, oder
//  eine Nutzungsvereinbarung mit mir treffen.
//
//  az_software@inode.at
//
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>


#include <rttarget.h>
#include <rtksys.h>
#include <rtk32.h>
#include <clock.h>
#include <socket.h>
#include <rtfiles.h>


#include "NetCfg.h"
#include "NmbServer.h"
#include "SmbServer.h"
#include "DgrServer.h"


char    SERVERIP  [32];
char    SUBNETMASK[32];

#define SHARE               1
#define USE_RAMDISK         1
#define RTF_MAX_DRIVES      4
#define RTF_MAX_FILES     128
#define RTF_MAX_BUFFERS   256



#include <Rtfdata.c>




#if     USE_RAMDISK

static  RTFDrvFLPYData sNullDriveAData = {0};
static  RTFDrvFLPYData sNullDriveBData = {0};
static  RTFDrvRAMData  sRamDriveCData  = {0};


RTFDevice RTFDeviceList[] =
    {
        { RTF_DEVICE_FLOPPY, 0, 0, &RTFDrvNULL, &sNullDriveAData },
        { RTF_DEVICE_FLOPPY, 1, 0, &RTFDrvNULL, &sNullDriveBData },
        { RTF_DEVICE_FLOPPY, 0, 0, &RTFDrvRAM,  &sRamDriveCData  },
        { 0 }
    };

#endif



//*****************************************************************************
//*
//*     Error
//*
//*****************************************************************************
//  RtTarget errrors
void Error(const char * Msg)
{
   printf("%s, error code: %s\n", Msg, xn_geterror_string(WSAGetLastError()));
   exit(1);
}



//*****************************************************************************
//*
//*     NetInitialize
//*
//*****************************************************************************
//  Initializes the network card
void NetInitialize(void)
{
int     iResult;
int     iInterface;




    sprintf(SERVERIP  ,"%i.%i.%i.%i",bTargetIP[0],bTargetIP[1],bTargetIP[2],bTargetIP[3]);
    sprintf(SUBNETMASK,"%i.%i.%i.%i",bNetMask [0],bNetMask [1],bNetMask [2],bNetMask [3]);


    RTKConfig.Flags|=RF_IRQDISABLE|RF_TCPUTIME;


    RTKernelInit(3);                        // Get the kernel going

    if(!RTKDebugVersion())                  // Switch of all diagnostics and error messages of RTIP-32
        {
        xn_callbacks()->cb_wr_screen_string_fnc = NULL;
        }

    CLKSetTimerIntVal(10*1000);             // 10 millisecond tick
    RTKDelay(1);
    RTCMOSSetSystemTime();                  // get the right time-of-day
    RTKPreemptionsON();


    iResult = xn_rtip_init();               // Initialize the RTIP stack

    if(iResult == SOCKET_ERROR)
        {
        Error("xn_rtip_init failed");
        }

    iResult = BIND_DRIVER(MINOR_0);         // Tell RTIP what Ethernet driver we want (see netcfg.h)

    if(iResult == SOCKET_ERROR)
        {
        Error("driver initialization failed");
        }

                                            // Open the interface

       iInterface = xn_interface_open_config(DEVICE_ID,MINOR_0,ED_IO_ADD,ED_IRQ,ED_MEM_ADD);
    if(iInterface == SOCKET_ERROR)
        {
        Error("xn_interface_open_config failed");
        }

                                            // Set the IP address and iInterface

    printf("Using static IP address %i.%i.%i.%i\n", bTargetIP[0], bTargetIP[1], bTargetIP[2], bTargetIP[3]);
    iResult = xn_set_ip(iInterface, bTargetIP, bNetMask);

                                            // Define default gateway and DNS server

    xn_rt_add(RT_DEFAULT, ip_ffaddr, bDefaultGateway, 1, iInterface, RT_INF);
    xn_set_server_list((DWORD*)bDnsServer, 1);

    if(iResult != 0)
        {
        Error("TCP/IP stack initialization failed");
        }
}


//*****************************************************************************
//*
//*     GetPassword
//*
//*****************************************************************************
//  callback to get the password vor a user
//  pUser       : is the user name
//  pPassword   : buffer for the password
//  iSize       : is the buffer size in bytes
//  returns the size of the saved password or 0 if the password
//  for this user should not be ckecked, or 10000 for an invalid user
int GetPassword(const char *pUser,char *pPassword,int iSize)
{

    printf("Password:    %s \n",pUser);

    #if SHARE
    pPassword[0] = 0;
    return 0;                                   // all other user didn't need a password
    #else

    if(!stricmp(pUser,"guest"))                 // a guest user
        {
        strncpy(pPassword,"abc123",iSize);
        return strlen("abc123");
        }

    if(!stricmp(pUser,"Anton Zechner"))                 // a guest user
        {
        strncpy(pPassword,"hallo",iSize);
        return strlen("hallo");
        }

    if(!strnicmp(pUser,"user",4) && pUser[4]>='0' && pUser[4]<='9'&& pUser[5]==0)
        {
        strncpy(pPassword,"xyz0",iSize);
        pPassword[3] = pUser[4];
        return strlen("xyz0");
        }

    pPassword[0] = '#';                         // create a dummy password
    pPassword[1] =  0;

    return 10000;
    #endif
}

//*****************************************************************************
//*
//*     UserLogon
//*
//*****************************************************************************
//  callback for user logons
//  pTree   : pointer to the tree data, here you can insert seveal paths
//  pUser   : is the user name
//  returns TRUE if the userer is valid, or FALSE if a wrong user was logged on.
int _cdecl UserLogon(void *pTree,const char *pUser)
{


    printf("UserLogon:   %s \n",pUser);

    #if SHARE

    SmbInsertTreeEntry(pTree,"C:","C_Drive" ,"This share is writable" ,SMB_MODE_READWRITE ,NULL);
    SmbInsertTreeEntry(pTree,"C:","C_Mirror","This share is read only",SMB_MODE_READONLY  ,NULL);

    return TRUE;

    #else
    char   *pMem;
    char    cPath[256];
    int     iLen;


    if(stricmp (pUser,"guest"))             // check the user, only guest and user0...9 are allowed
    if(strnicmp(pUser,"user",4) || pUser[4]<'0' || pUser[4]>'9'|| pUser[5]!=0)
        {
        return FALSE;
        }


    SmbInsertTreeEntry(pTree,"C:","C_Drive" ,"This share is writable" ,SMB_MODE_READWRITE ,NULL);
    SmbInsertTreeEntry(pTree,"C:","C_Mirror","This share is read only",SMB_MODE_READONLY  ,NULL);


    if(stricmp(pUser,"guest"))              // add a user depenting directory
        {
        iLen = sprintf(cPath,"C:\\Users\\%s",pUser)+1;
        pMem = (char*)SmbMemAlloc(iLen);

        if(!pMem)return FALSE;

        RTFCreateDir(cPath);
        memcpy(pMem,cPath,iLen);
        SmbInsertTreeEntry(pTree,pMem,"Own","User depent directory",SMB_MODE_READWRITE,pMem);
        }



    return TRUE;

    #endif
}

//*****************************************************************************
//*
//*     TreeCheck
//*
//*****************************************************************************
//  callback to check the access attributs of trees
//  return: -4 unknown error
//          -3 wrong server name
//          -2 wrong path
//          -1 wrong username/pasword
//           0 connect with common access
//           1 connect with readonly access
int _cdecl TreeCheck(const SmbTreeData *pData)
{


    printf("TreeCheck:   %s : %s\n",pData->cUsername,pData->cService);

    #if SHARE

    return 0;

    #else

    if(!stricmp(pData->cService,"C_Drive"))
        {
        if(!stricmp(pData->cUsername,"unknown"))
            {
            return 1;                       // this user has read only access on C_Drive
            }
        }

    #endif


return 0;
}

//*****************************************************************************
//*
//*     main
//*
//*****************************************************************************
int main(void)
{
SmbConfigData   sSmbConfig;
NmbConfigData   sNmbConfig;
int             iErr;

    RTIdleHandler = (void(*)(void))RTHaltCPL3;
    NetInitialize();                            // Initialize the TCP/IP stack
//  vf_init();                                  // Initialize RTIP-32 vitual file system
    CLKSetTimerIntVal(10000);                   // 10 millisecond timer tick

#ifdef  USE_RAMDISK
    {
    FILE *f;

    f=fopen("C:\\ReadMe.txt","w");
    fprintf(f,"This is a Ram-Disk.");
    fclose(f);

    RTFCreateDir("C:\\Users");                  // path for user directories
    }
#endif

    memset(&sSmbConfig,0,sizeof(sSmbConfig));
    memset(&sNmbConfig,0,sizeof(sNmbConfig));

    strcpy(sSmbConfig.cIpAddress,SERVERIP);
    sSmbConfig.pGetPassword     = GetPassword;
    sSmbConfig.pUserLogon       = UserLogon;
    sSmbConfig.pTreeCheck       = TreeCheck;
    sSmbConfig.iMaxBufferSize   = 0xFFFF;
    sSmbConfig.iSecurityMode    = SMB_USER;
    sSmbConfig.iPriority        = PRIOTASK_NORMAL*4;

    strncpy(sNmbConfig.cIpAddress ,SERVERIP   ,sizeof(sNmbConfig.cIpAddress ));
    strncpy(sNmbConfig.cSubNetMask,SUBNETMASK ,sizeof(sNmbConfig.cSubNetMask));
    strncpy(sNmbConfig.cHostname  ,"RtClient" ,sizeof(sNmbConfig.cHostname  ));
    strncpy(sNmbConfig.cWorkgroup ,"WORKGROUP",sizeof(sNmbConfig.cWorkgroup ));
//  strncpy(sNmbConfig.cWorkgroup ,"ANTONSCLUSTER",sizeof(sNmbConfig.cWorkgroup ));
            sNmbConfig.iPriority = PRIOTASK_NORMAL*4;

       iErr=NmbDaemon(&sNmbConfig);
    if(iErr!=NMB_ERR_NONE)
        {
        printf("\nNMB-Error: %i",iErr);
        SmbStopDaemon();
        NmbStopDaemon();
        DgrStopDaemon();
        return -1;
        }

       iErr=SmbDaemon(&sSmbConfig);
    if(iErr!=SMB_ERR_NONE)
        {
        printf("\nSMB-Error: %i",iErr);
        SmbStopDaemon();
        NmbStopDaemon();
        DgrStopDaemon();
        return -1;
        }

    for(;;)
        {
        RTKDelay(200);
        }

    SmbStopDaemon();
    NmbStopDaemon();
    DgrStopDaemon();


return 0;
}
