// -*- coding: utf-8; -*-
// (c) Copyright 2009, Nikolay Slobodskoy
// This file is part of Timeshop.
//
// Timeshop is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Timeshop is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Timeshop.  If not, see <http://www.gnu.org/licenses/>.
//
#ifndef TIMESHOP_INTERNAL_HPP
#define TIMESHOP_INTERNAL_HPP
#include <QFileDialog>
#ifdef TIMESHOP_INHIBIT_SCREENSAVER
#include <QSystemScreenSaver>
#endif // TIMESHOP_INHIBIT_SCREENSAVER
#include "timeshop.hpp"
namespace Ui
{
  class TimerFingerDialog;
}
namespace Timeshop
{
  class TIMESHOP_CLASS FileSaveDialog
  {
  public:
    FileSaveDialog( const QString& FileName0 = QString() );
    virtual void add_filter( const QString& Name, const QString& Mask = QString(), const QString& DefaultSuffix = QString() );
    virtual bool exec() = 0;
    QString file_name() const { return FileName; }
    int filter_index() const { return FilterIndex; }
  protected:
    QString FileName;
    int FilterIndex;
    QStringList Filters;
    QStringList Suffixes;
  }; // FileSaveDialog
  class TIMESHOP_CLASS QtFileSaveDialog : public QObject, public FileSaveDialog
  {
    Q_OBJECT
    public:
    QtFileSaveDialog( const QString& Caption0, const QString& FileName0 = QString(), QWidget* Parent0 = 0 );
    bool exec();
  protected slots:
    void filter_changed( const QString& NewFilter );
  protected:
    QFileDialog Dlg;
  }; // QtFileSaveDialog
  class TIMESHOP_CLASS NativeFileSaveDialog : public FileSaveDialog
  {
  public:
    NativeFileSaveDialog( const QString& Caption0, const QString& FileName0 = QString(), QWidget* Parent0 = 0 );
    bool exec();
  protected:
    QString Caption;
    QWidget* Parent;
  }; // NativeFileSaveDialog

#if 1 //def TIMESHOP_FINGER_FRIENDLY
  // Finger-friendly time selection dialog.
  class TIMESHOP_CLASS TimerFingerDialog : public QDialog
  {
    Ui::TimerFingerDialog* UI;
  public:
    enum Action { DoNothing, StartTimer, RestartTimer };
    TimerFingerDialog( time_t Seconds = 0, QWidget* Parent = 0, bool TimeOnly = false );
    ~TimerFingerDialog();
    time_t time() const;
    void time( time_t Seconds );
#ifdef TIMESHOP_INHIBIT_SCREENSAVER
    bool inhibit_screensaver() const;
    void inhibit_screensaver( bool Inhibit );
#endif // TIMESHOP_INHIBIT_SCREENSAVER
    Action on_done() const;
    void on_done( Action NewAction );
  }; // TimerFingerDialog
#endif // TIMESHOP_FINGER_FRIENDLY

#ifdef TIMESHOP_INHIBIT_SCREENSAVER
  class ScreenController : public QObject
  {
    Q_OBJECT
  public:
    ScreenController();
    ~ScreenController();
    void inhibit_screensaver( bool Inhibit );
  public slots:
    void screen_state_changed( SystemServices::Display::State NewMode );
  protected:
    QtMobility::QSystemScreenSaver* ScreenSaver;
  }; // ScreenController
#endif // TIMESHOP_INHIBIT_SCREENSAVER
} // Timeshop
#endif // TIMESHOP_INTERNAL_HPP
