// -*- coding: utf-8; -*-
// (c) Copyright 2009, Nikolay Slobodskoy
// This file is part of Timeshop.
//
// Timeshop is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Timeshop is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Timeshop.  If not, see <http://www.gnu.org/licenses/>.
//
#include "timeshop.hpp"
#ifdef Q_WS_MAEMO_5
#ifdef TIMESHOP_USE_MAFW
#include "mafw_alarm.hpp"
#endif // TIMESHOP_USE_MAFW
#include <libosso.h>
#include <QDebug>

namespace Timeshop
{
  class TIMESHOP_CLASS FremantleServices : public SystemServices
  {
    static void display_state_callback( osso_display_state_t State, gpointer Data );
  public:
    FremantleServices();
    ~FremantleServices();
  protected:
    virtual void display_state_handler( Display::State NewState );
    osso_context_t* OSSO;
  }; // FremantleServices

  void FremantleServices::display_state_callback( osso_display_state_t StateOSSO, gpointer Data )
  {
    FremantleServices& This = *static_cast<FremantleServices*>( Data );
    Display::State NewState = Display::Off;
    switch( StateOSSO )
    {
    case OSSO_DISPLAY_ON: NewState = Display::On; break;
    case OSSO_DISPLAY_OFF: NewState = Display::Off; break;
    case OSSO_DISPLAY_DIMMED: NewState = Display::Dimmed; break;
    }
    This.display_state_handler( NewState );
  } // display_state_callback( osso_display_state_t, gpointer )
  void FremantleServices::display_state_handler( Display::State NewState )
  {
    qDebug() << "Display state changed to" << NewState;
    emit display_state_changed( NewState );
  } // display_state_handler( Display::State )
  
  FremantleServices::FremantleServices() : OSSO( 0 )
  {
#ifdef TIMESHOP_USE_MAFW
    MAFWAlarm::init();
#endif // TIMESHOP_USE_MAFW
    OSSO = osso_initialize( "Time Workshop", "0.3.2", false, 0 );
    if( OSSO )
    {
      if( osso_hw_set_display_event_cb( OSSO, display_state_callback, this ) != OSSO_OK )
	qDebug() << "Can't set display state callback.";
    }
    else
      qDebug() << "Can't initialize OSSO.";
  }; // FremantleServices()
  FremantleServices::~FremantleServices()
  {
    if( OSSO )
    {
      osso_deinitialize( OSSO );
      OSSO = 0;
    }
#ifdef TIMESHOP_USE_MAFW
    MAFWAlarm::cleanup();
#endif // TIMESHOP_USE_MAFW
  } // ~FremantleServices()

  // Redefine parent's static function.
  SystemServices& SystemServices::get()
  {
    if( !Object ) Object = new FremantleServices;
    return *Object;
  } // get()
} // Timeshop
#endif // Q_WS_MAEMO_5
