# (c) Copyright 2010, Николай Слободской (Nick Slobodsky)
# This file is part of Timeshop.
#
# Timeshop is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# Timeshop is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeshop.  If not, see <http://www.gnu.org/licenses/>.
#
VERSION = 0.3.2

TEMPLATE = lib
TARGET = timeshop
win32 {
  TARGET_EXT = -$${VERSION}.dll
}
android {
  CONFIG += staticlib
  DEFINES += TIMESHOP_NO_SOUND TIMESHOP_STATIC
}
else: !maemo5 {
  QT += phonon
}
symbian {
#  CONFIG += staticlib
staticlib {
  DEFINES += TIMESHOP_STATIC
}
else {
# Dynamic lib
  BLD_INF_RULES.prj_exports += timeshop.hpp timeshop_internal.hpp
  MMP_RULES += EXPORTUNFROZEN
  DEFINES += TIMESHOP_LIB_SHARED
  TARGET.EPOCALLOWDLLDATA = 1
  CONFIG += localize_deployment
  TRANSLATIONS += symbian/libtimeshop_package_ru.ts
  QMAKE_CLEAN += symbian/libtimeshop_package_ru.qm
  DEPLOYMENT.display_name = "Time Workshop library"
  libtimeshop.sources = timeshop.dll
  libtimeshop.path = /sys/bin
  DEPLOYMENT += libtimeshop
}
  LRELEASE = lrelease
}
else {
!android {
  CONFIG += shared
  DEFINES += TIMESHOP_LIB_SHARED
}
  LRELEASE = $${QT_BIN_DIR}lrelease
}

# Input
HEADERS += timeshop.hpp timeshop_internal.hpp
SOURCES += core.cpp timeshop.cpp controllers.cpp displays.cpp stopwatches.cpp settings.cpp alarms.cpp utility.cpp
RESOURCES = timeshop.qrc
FORMS = timer_settings.ui save_preset.ui
maemo5 {
FORMS += forms/mark_dialog.ui timer_finger.ui
CONFIG += link_pkgconfig mobility12
PKGCONFIG += mafw mafw-shared libosso
SOURCES += mafw_alarm.cpp timeshop_fremantle.cpp
# SOURCES += maemo_playback.cpp
}
else: contains( MEEGO_EDITION, harmattan ) {
CONFIG += mobility
}
else: {
FORMS += forms/quick_timer_desktop.ui
}

mobility|mobility12 {
MOBILITY += systeminfo
DEFINES += TIMESHOP_INHIBIT_SCREENSAVER
}
message( Config: $$CONFIG Mobility: $$MOBILITY Defines: $$DEFINES )

#! \todo Move translation to separate langpack.
trans.target = lang/ru.qm
trans.depends = $$_PRO_FILE_PWD_/lang/ru.ts
trans.commands = mkdir -p lang && $${LRELEASE} $${trans.depends} -qm $${trans.target}
QMAKE_EXTRA_TARGETS += trans
QMAKE_CLEAN += $${trans.target}
PRE_TARGETDEPS += $${trans.target}
TRANSLATIONS = $${trans.depends}

unix:!symbian {
isEmpty( PREFIX ) {
  PREFIX = /usr/local
}
DEFINES += TIMESHOP_DATADIR=\'\"$${PREFIX}/share/timeshop\"\'

LIBDIR = $${PREFIX}/lib
INCDIR = $${PREFIX}/include

target.path += $${LIBDIR}
INSTALLS += target

DEPENDPATH += .
INCLUDEPATH += .

headers.path = $${INCDIR}
headers.files = $${HEADERS}
# headers.extra = $(INSTALL_FILE) timeshop.hpp $(INSTALL_ROOT)$${INCDIR} )
INSTALLS += headers
}
