// -*- coding: utf-8; -*-
// (c) Copyright 2011, Nikolay Slobodskoy
// This file is part of Timeshop.
//
// Timeshop is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Timeshop is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Timeshop.  If not, see <http://www.gnu.org/licenses/>.
//
#ifndef TIMESHOP_QML_WRAPPER_HPP
#define TIMESHOP_QML_WRAPPER_HPP
#include <QGraphicsProxyWidget>
#include <QGraphicsSceneResizeEvent>
#include "timeshop_main.hpp"

class TimeshopQMLWrapper : public QGraphicsProxyWidget
{
  Q_OBJECT
public:
  TimeshopQMLWrapper();
  ~TimeshopQMLWrapper();
public slots:
  void edit_settings();
  void save_settings();
  void save_marks();
  void mark();
  void clear_marks();
  void show_marks( bool Show = true );
  void toggle_marks();
  void show_presets( bool Show = true );
  void toggle_presets();
protected slots:
  void relay_marks( bool Visible );
  void relay_presets( bool Visible );
signals:
  void marks_visible( bool Visible );
  void presets_visible( bool Visible );
protected:
  void resizeEvent( QGraphicsSceneResizeEvent* Ev );
  Timeshop::AlarmTimerWidget* Timer;
  Work TimeWork;
}; // TimeshopQMLWrapper
#endif // TIMESHOP_QML_WRAPPER_HPP
