// -*- coding: utf-8; -*-
// (c) Copyright 2011, Nikolay Slobodskoy
// This file is part of Timeshop.
//
// Timeshop is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Timeshop is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Timeshop.  If not, see <http://www.gnu.org/licenses/>.
//
#include "timeshop_qml_wrapper.hpp"

TimeshopQMLWrapper::TimeshopQMLWrapper() : Timer( 0 )
{
  TimeWork.load_from_config();
  if( TimeWork.timers().size() > 0 )
  {
    Timer = TimeWork.timers().front();
    if( Timer ) setWidget( Timer );
  }
} // TimeshopQMLWrapper()
TimeshopQMLWrapper::~TimeshopQMLWrapper() {}
// public slots:
void TimeshopQMLWrapper::edit_settings() {} //!< \todo Write function.
void TimeshopQMLWrapper::save_settings() { if( Timer ) Timer->save_settings(); }
void TimeshopQMLWrapper::save_marks() { if( Timer ) Timer->save_marks(); }
void TimeshopQMLWrapper::mark() { if( Timer ) Timer->mark(); }
void TimeshopQMLWrapper::clear_marks() { if( Timer ) Timer->clear_marks(); }
void TimeshopQMLWrapper::show_marks( bool Show ) { if( Timer ) Timer->show_marks( Show ); }
void TimeshopQMLWrapper::toggle_marks() { if( Timer ) Timer->show_marks( !Timer->marks_visible() ); }
void TimeshopQMLWrapper::show_presets( bool Show ) { if( Timer ) Timer->show_presets( Show ); }
void TimeshopQMLWrapper::toggle_presets() { if( Timer ) Timer->show_presets( !Timer->presets_visible() ); }

void TimeshopQMLWrapper::relay_marks( bool Visible ) { emit marks_visible( Visible ); }
void TimeshopQMLWrapper::relay_presets( bool Visible ) { emit presets_visible( Visible ); }

void TimeshopQMLWrapper::resizeEvent( QGraphicsSceneResizeEvent* Ev )
{
  qDebug() << "Resize proxy from" << Ev->oldSize() << "to" << Ev->newSize();
  if( Timer )
  {
    qDebug() << "Resize timer to" << Ev->newSize().toSize();
    Timer->resize( Ev->newSize().toSize() );
  }
  else
    qDebug() << "No timer.";
} // resizeEvent( QGraphicsSceneResizeEvent* )
