// -*- coding: utf-8; -*-
// (c) Copyright 2009, Nikolay Slobodskoy
// This file is part of Timeshop.
//
// Timeshop is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Timeshop is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Timeshop.  If not, see <http://www.gnu.org/licenses/>.
//
#ifndef TIMESHOP_MAIN_HPP
#define TIMESHOP_MAIN_HPP
#include <QSettings>
#include <timeshop.hpp>
#include <qplatformdefs.h>
#if defined( Q_WS_HILDON ) || defined( Q_WS_MAEMO_5 ) || defined( Q_WS_S60 ) || defined( MEEGO_EDITION_HARMATTAN )
#define TIMESHOP_HANDSET
#endif
#if !defined( WINCE ) && !defined( TIMESHOP_HANDSET )
#define TIMESHOP_DESKTOP
#endif

class Timer : public Timeshop::AlarmTimerWidget
{
  Q_OBJECT
public:
  typedef Timeshop::AlarmTimerWidget Super;
  class Loader : public Super::Loader
  {
  public:
    static const char Tag[];
    Loader( const char* Tag0 = Tag ) : Super::Loader( Tag0 ) {}
    Timeshop::Persistent* create_object( QXmlStreamReader& Stream, Timeshop::Work* Root, Timeshop::Persistent::ID ObjectID = -1 ) const
    {
      Timer* Result = 0;
      if( Root )
	if( Timeshop::TimerSettings* Settings = find_settings( Stream, Root ) )
	{
	  Result = new Timer( *Root, *Settings, 0, ObjectID );
	  Root->add_timer( *Result );
	}
      return Result;
    } // create_object( QXmlStreamReader&, Timeshop::Work*, Timeshop::Persistent::ID ) const
  }; // Loader
  //  static QString tr( const char* Text ) { return QApplication::translate( "Timer", Text ); }

  Timer( Timeshop::Work& Master0, Timeshop::TimerSettings& Settings0, QWidget* Parent = 0, Timeshop::Persistent::ID ObjectID = -1 );
  const char* loader_tag() const { return Loader::Tag; }
  void update_settings();
  void save_settings();
  void show_marks( bool Show = true );
  void show_presets( bool Show = true );
signals: //! \todo Move to AlarmTimer and Stopwatch
  void marks_visible( bool Visible );
  void presets_visible( bool Visible );
#ifdef TIMESHOP_DESKTOP
public:
  struct WindowMode{ enum { Normal, Frameless, OSD }; };
public slots:
  void change_mode( QAction* Act );
  void normal_mode();
  void frameless_mode( bool Frameless = true );
  void osd_mode();
  void show_frame( bool Show = true );
  void stay_on_top( bool Stay = true );
  void change_opacity( QAction* Act );
  void opacity( qreal NewOpacity );
#endif // TIMESHOP_DESKTOP
protected:
  void closeEvent( QCloseEvent* Event );
#ifdef TIMESHOP_DESKTOP
  void enterEvent( QEvent* Event );
  void leaveEvent( QEvent* Event );
  void mousePressEvent( QMouseEvent* Event );
  void mouseReleaseEvent( QMouseEvent* Event );
  void mouseMoveEvent( QMouseEvent* Event );
  bool has_options() const { return true; }
  bool load_element( QXmlStreamReader& Stream, Timeshop::Work* Root = 0 );
#if 0 //! \todo Read/write menu. Or maybe not?
  void write_attributes( QXmlStreamWriter& Stream ) const;
#endif
  void write_elements( QXmlStreamWriter& Stream ) const;
  void write_options( QXmlStreamWriter& Stream ) const;
  QAction* FramelessAction;
  QAction* OSDAction;
  QAction* OnTopAction;
  QList<QAction*> OpacityActions;
  char Mode;
  qreal Opacity; // Opacity
  bool Drag;
  QPoint StartPos;
  QPoint StartMouse;
#endif // TIMESHOP_DESKTOP
}; // Timer

class Work : public Timeshop::Work
{
Q_OBJECT
public:
  typedef Timeshop::Work Super;
  Work();
  ~Work();
  bool autosave() const { return Autosave; }
  void autosave( bool NewAutosave ) { Autosave = NewAutosave; }
  void load_from_config();
  void create_default_layout( bool Show = true );
  void save_to_stream();
protected:
  bool load_element( QXmlStreamReader& Stream, Timeshop::Work* Root = 0 );
  bool Autosave;
  QString LayoutFileName;
}; // Work
#endif // TIMESHOP_MAIN_HPP
