// -*- coding: utf-8; mode: qml; -*-
// (c) Copyright 2009-2011, 2010 Николай Слободской (Nick Slobodsky)
// This file is part of Timeshop.
//
// Timeshop is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Timeshop is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Timeshop.  If not, see <http://www.gnu.org/licenses/>.
//
import QtQuick 1.1
import com.nokia.meego 1.0

PageStackWindow {
  id: appWindow

  initialPage: timerPage

  TimerPage {
    id: timerPage
  }

  Page {
    id: aboutPage
    // orientationLock: PageOrientation.LockLandscape
    
    Column {
      spacing: 8
      Rectangle {
	width: aboutPage.width
	border.color: "gray"
	border.width: 1
	radius: 16
	gradient: Gradient {
	  GradientStop {
	    position: 0.00;
	    color: "#ff808080";
	  }
	  GradientStop {
	    position: 1.00;
	    color: "#ff000000";
	  }
	}

	Column {
	  x: 16
	  y: 8
	  id: titleBlock
	  Text {
	    text: qsTr( "Time Workshop" )
	    font.pointSize: 40
	    color: "tan"
	    style: "Outline"
	    styleColor: "orange"
	  }
	  Text {
	    font.pointSize: 24
	    text: qsTr( "Version " ) + "0.3.2-alpha1" + qsTr( "<br>&copy; 2009-2011, Nick Slobodsky" )
	    color: "silver"
	  }
	}
	height: titleBlock.height + 16
      }

      Text {
	font.pointSize: 24
	width: parent.width
	wrapMode: "Wrap"
	color: "silver"
	text: qsTr( "<p>Under construction." )
      }
    } // About page contents

    ToolBarLayout {
      id: backTools
      ToolIcon {
        platformIconId: "toolbar-back"
        onClicked: { pageStack.pop(); }
      }
    }
    tools: backTools
  }

  // Component.onCompleted: theme.inverted = true
}
