// -*- coding: utf-8; mode: qml; -*-
// (c) Copyright 2009-2011, 2010 Николай Слободской (Nick Slobodsky)
// This file is part of Timeshop.
//
// Timeshop is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Timeshop is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Timeshop.  If not, see <http://www.gnu.org/licenses/>.
//
import QtQuick 1.1
import com.nokia.meego 1.0
import ru.slobodsky.software.timeshop 0.1

Page {
  // orientationLock: PageOrientation.LockLandscape
  tools: timerTools

  TimeshopQMLWrapper {
    id: timerWidget
    anchors.fill: parent
  }

  Menu {
    id: timerMenu
    visualParent: pageStack
    MenuLayout {
      MenuItem { text: qsTr( "Export marks..." ); onClicked: timeWidget.save_marks(); }
      MenuItem {
        text: qsTr( "Settings..." );
        onClicked: timerWidget.edit_settings();
      }
      MenuItem {
        text: qsTr( "Save preset..." );
        onClicked: timerWidget.save_settings();
      }
      MenuItem {
        text: qsTr( "Mark" );
        onClicked: timerWidget.mark();
      }
      MenuItem {
        text: qsTr( "Clear marks" );
        onClicked: timerWidget.clear_marks();
      }
      MenuItem { text: qsTr( "Marks list" ); }
      MenuItem { text: qsTr( "Presets buttons" ); }
      MenuItem {
        text: qsTr( "About" )
        onClicked: pageStack.push( aboutPage )
      }
      MenuItem {
        text: qsTr( "Exit" )
        onClicked: Qt.quit()
      } // MenuItem
    } // MenuLayout
  }
  
  ToolBarLayout {
    id: timerTools
    /*
    ToolIcon {
      platformIconId: "toolbar-camera"
      onClicked: mirrorCamera.capture()
    }

    ToolIcon {
      platformIconId: "toolbar-back"
      onClicked: Qt.quit()
    }*/

    ToolIcon {
      platformIconId: "toolbar-view-menu"
      anchors.right: ( parent === undefined ) ? undefined : parent.right
      onClicked: ( timerMenu.status == DialogStatus.Closed ) ? timerMenu.open() : mainMenu.close()
    }
  }
}
