# (c) Copyright 2009, 2010 Николай Слободской (Nick Slobodsky)
# This file is part of Timeshop.
#
# Timeshop is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 2 of the License, or
# (at your option) any later version.
#
# Timeshop is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with Timeshop.  If not, see <http://www.gnu.org/licenses/>.
#
VERSION = 0.3.2

TEMPLATE = app
android {
TARGET = timeshopapp
}
else {
TARGET = timeshop
}

QMAKE_CLEAN += $${TARGET}

symbian {
  QT += phonon
  TIMESHOP_LIB_UID = 0xEeafa05b
  LRELEASE = lrelease
}
else {
# Check if it is not always on the PATH
  LRELEASE = $${QT_BIN_DIR}lrelease
}

android {
  DEFINES += TIMESHOP_NO_SOUND TIMESHOP_STATIC
}
else {
  QT += phonon
}

unix {
isEmpty( PREFIX ) {
PREFIX = /usr/local
}

BINDIR = $${PREFIX}/bin
DATADIR = $${PREFIX}/share

target.path += $${BINDIR}
INSTALLS += target

maemo5|contains( QT_CONFIG, hildon ) {
ICONSUBDIR=hildon
CONFIG += link_pkgconfig mobility12
PKGCONFIG += mafw mafw-shared libosso
}
else {
ICONSUBDIR=apps
}
# Icons install
ICONSIZES=16 32 48
ICONDIRPREFIX=$${DATADIR}/icons/hicolor

for( SIZE, ICONSIZES ) {
  ICON = icon$${SIZE}
  ICONPATH = $${ICONDIRPREFIX}/$${SIZE}x$${SIZE}/$${ICONSUBDIR}
  eval( $${ICON}.path = $${ICONPATH} )
  eval( $${ICON}.extra = $(INSTALL_FILE) $$_PRO_FILE_PWD_/images/timeshop/$${SIZE}.png $(INSTALL_ROOT)$${ICONPATH}/timeshop.png )
  eval( INSTALLS += $${ICON} )
}
iconsvg.path = $${ICONDIRPREFIX}/scalable/$${ICONSUBDIR}
contains( MEEGO_EDITION, harmattan ) {
CONFIG += mobility
QT += declarative opengl
iconsvg.files = images/harmattan/timeshop.svg

HEADERS += timeshop_qml_wrapper.hpp
SOURCES += timeshop_qml_wrapper.cpp

QMLs.files = qml/main.qml qml/TimerPage.qml
QMLs.path = /usr/share/timeshop/qml
INSTALLS += QMLs
}
else {
iconsvg.files = images/timeshop.svg
}

INSTALLS += iconsvg

# Menu item
maemo5|contains( QT_CONFIG, hildon ) {
APPMENUSUBDIR = applications/hildon
# Desktop file translation
gettextfile.target = lang/ru.desktop.mo
gettextfile.depends = lang/ru.desktop.po
gettextfile.commands = msgfmt -o $${gettextfile.target} $${gettextfile.depends}
QMAKE_EXTRA_TARGETS += gettextfile
POST_TARGETDEPS += $${gettextfile.target}
QMAKE_CLEAN += $${gettextfile.target}
gettextfile.path = $${DATADIR}/locale/ru/LC_MESSAGES
gettextfile.extra = $(INSTALL_FILE) $${gettextfile.target} $(INSTALL_ROOT)$${gettextfile.path}/$${TARGET}.desktop.mo
INSTALLS += gettextfile
layouts.files = layouts/maemo/colors.layout.timeshop layouts/maemo/sidebuttons.layout.timeshop
# colorlayout.extra = $(INSTALL_FILE) $${colorlayout.target} $(INSTALL_ROOT)$${colorlayout.path}/
}
else {
APPMENUSUBDIR = applications
contains( MEEGO_EDITION, harmattan )
{
layouts.files = layouts/harmattan/colors.layout.timeshop
}
else {
layouts.files = layouts/desktop/colors.layout.timeshop
}
}
layouts.path = $${DATADIR}/timeshop/layouts
INSTALLS += layouts
!android {
appmenu.target = $${TARGET}.desktop
appmenu.depends = $$_PRO_FILE_PWD_/$${appmenu.target}.in
#appmenu.commands = echo $${appmenu.target}
appmenu.commands = sed s\|@BINDIR@\|$${BINDIR}\| < $${appmenu.depends} > $${appmenu.target}
QMAKE_EXTRA_TARGETS += appmenu
POST_TARGETDEPS += $${appmenu.target}
QMAKE_CLEAN += $${appmenu.target}
appmenu.path = $${DATADIR}/$${APPMENUSUBDIR}
appmenu.extra = $(INSTALL_FILE) timeshop.desktop $(INSTALL_ROOT)$${appmenu.path}/$${TARGET}.desktop
INSTALLS += appmenu
} # android
} # unix

DEPENDPATH += ../lib
INCLUDEPATH += ../lib
symbian {
static {
  DEFINES += TIMESHOP_STATIC
  LIBS += -ltimeshop.lib
}
else {
  LIBS += -ltimeshop
}
}
else:win32 {
  LIBS += ../lib/$(OBJECTS_DIR)/timeshop-$${VERSION}.lib
}
else {
  QMAKE_LIBDIR_FLAGS += -L../lib
  LIBS += -ltimeshop
}

# Input
SOURCES += timeshop_main.cpp
HEADERS += timeshop_main.hpp
symbian {
CONFIG += localize_deployment
TRANSLATIONS += symbian/timeshop_package_ru.ts
QMAKE_CLEAN += symbian/timeshop_package_ru.qm
ICON = images/timeshop.svg
libtimeshop.pkg_prerules.main = "($${TIMESHOP_LIB_UID}), 0,3,2, {\"Time Workshop library\"}"
libtimeshop.pkg_postrules = "@\"../lib/timeshop.sis\", ($${TIMESHOP_LIB_UID})"
DEPLOYMENT += libtimeshop
DEPLOYMENT.display_name = "Time Workshop"
}
else:win32 {
  RC_FILE = w32/timeshop.rc
}
#! \todo Move translation to separate langpack.
trans.target = lang/app-ru.qm
trans.depends = $$_PRO_FILE_PWD_/lang/app-ru.ts
trans.commands = mkdir -p lang && $${LRELEASE} $${trans.depends} -qm $${trans.target}
QMAKE_EXTRA_TARGETS += trans
QMAKE_CLEAN += $${trans.target}
PRE_TARGETDEPS += $${trans.target}
TRANSLATIONS += $${trans.depends}

RESOURCES = timeshop_app.qrc

mobility|mobility12 {
MOBILITY += systeminfo
DEFINES += TIMESHOP_INHIBIT_SCREENSAVER
}
