// -*- coding: utf-8; -*-
// (c) Copyright 2009, Nikolay Slobodskoy
// This file is part of Timeshop.
//
// Timeshop is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Timeshop is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Timeshop.  If not, see <http://www.gnu.org/licenses/>.
//
#ifndef TIMESHOP_MAFW_ALARM_HPP
#define TIMESHOP_MAFW_ALARM_HPP
#include "timeshop.hpp"
namespace Timeshop
{
  class MAFWRenderer;
  class TIMESHOP_CLASS MAFWAlarm : public Alarm
  {
  public:
    static void init();
    static void cleanup();
    MAFWAlarm( const QString& SoundFile = QString() );
    ~MAFWAlarm();
    void start();
    void stop();
    void reset();
    void change_sound( const QString& SoundFile );
  protected:
    QString URI;
    MAFWRenderer* Renderer;
  }; // MAFWAlarm
} // Timeshop
#endif // TIMESHOP_MAFW_ALARM_HPP
