// -*- coding: utf-8; -*-
// (c) Copyright 2009, Nikolay Slobodskoy
// This file is part of Timeshop.
//
// Timeshop is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 2 of the License, or
// (at your option) any later version.
//
// Timeshop is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Timeshop.  If not, see <http://www.gnu.org/licenses/>.
//
#include <QDebug>
#include "timeshop.hpp"
#include "maemo_playback.hpp"
namespace Timeshop
{
  void Playback::request_handler_callback( pb_playback_t* /*PB*/, enum pb_state_e State, pb_req_t* Req, void* Data )
  {
    qDebug() << __PRETTY_FUNCTION__;
    if( Playback* This = static_cast<Playback*>( Data ) )
      This->request_handler( State, Req );
    else
      qDebug() << "Wrong \"this\" in request_handler_callback.";
  } // request_handler( pb_playback_t*, enum pb_state_e, pb_req_t*, void* )
  void Playback::state_hint_callback( pb_playback_t* /*PB*/, const int AllowedStates[], void* Data )
  {
    qDebug() << __PRETTY_FUNCTION__;
    if( Playback* This = static_cast<Playback*>( Data ) )
      This->state_hint( AllowedStates );
    else
      qDebug() << "Wrong \"this\" in state_reply_callback.";
  } // state_reply_callback( pb_playback_t*, enum pb_state_e, const char*, pb_req_t*, void* )
  void Playback::state_reply_callback( pb_playback_t* /*PB*/, enum pb_state_e State, const char* Reason, pb_req_t* Req, void* Data )
  {
    qDebug() << __PRETTY_FUNCTION__;
    if( Playback* This = static_cast<Playback*>( Data ) )
      This->state_reply( State, Reason, Req );
    else
      qDebug() << "Wrong \"this\" in state_reply_callback.";
  } // state_reply_callback( pb_playback_t*, enum pb_state_e, const char*, pb_req_t*, void* )
#if 1
  void Playback::mute_state_callback( int Mute, const char* Error, void* Data )
  {
    qDebug() << "Mute:" << Mute << ( Error ? Error : "OK" );
  } // mute_state_callback( int, const char*, void* )
#endif

  void request_handler_one( pb_playback_t* /*PB*/, enum pb_state_e State, pb_req_t* Req, void* Data )
  {
    qDebug() << __PRETTY_FUNCTION__;
  } // request_handler( pb_playback_t*, enum pb_state_e, pb_req_t*, void* )
  void state_reply_one( pb_playback_t* /*PB*/, enum pb_state_e State, const char* Reason, pb_req_t* Req, void* Data )
  {
    qDebug() << __PRETTY_FUNCTION__;
  } // state_reply_callback( pb_playback_t*, enum pb_state_e, const char*, pb_req_t*, void* )

  Playback::Playback( Phonon::MediaObject* Media0, pb_class_e Class ) : Media( Media0 ), Connection( 0 ), PlaybackObject( 0 )
  {
    GError* GErr = 0;
    mafw_shared_init( mafw_registry_get_instance(), &GErr );
    DBusError Err;
    dbus_error_init( &Err );
    Connection = dbus_bus_get( DBUS_BUS_SESSION, &Err );
    if( !Connection )
      qDebug() << "Can't get DBUS for playback:" << Err.message;
    else
    {
      PlaybackObject = pb_playback_new_2( Connection, PB_CLASS_MEDIA, PB_FLAG_AUDIO, PB_STATE_PLAY, request_handler_callback, this );
      if( !PlaybackObject )
	qDebug() << "Can't get playback object.";
      else
      {
	pb_playback_set_state_hint( PlaybackObject, state_hint_callback, this );
	qDebug() << "Playback created successfully.";
	if( Media ) Media->play();
#if 1
	pb_set_mute_cb( Connection, mute_state_callback, this );
	if( !pb_get_mute( Connection ) )
	  qDebug() << "Can't get mute state.";
#endif
	// pb_playback_req_state( PlaybackObject, PB_STATE_PLAY, state_reply_callback, this );
      }
    }
  } // Playback()
  Playback::~Playback()
  {
    qDebug() << "Destroy playback.";
    if( PlaybackObject )
      pb_playback_destroy( PlaybackObject );
    if( Media )
      Media->stop();
  } // ~Playback()

  // Callbacks handlers
  void Playback::request_handler( enum pb_state_e State, pb_req_t* Req )
  {
    if( Media )
      switch( State )
      {
      case PB_STATE_PLAY:
	qDebug() << "New state is PLAY";
	Media->play();
	break;
      case PB_STATE_STOP:
	qDebug() << "New state is STOP";
	Media->pause();
	break;
      default:
	qDebug() << "Enter UNKNOWN state";
	break;
      }
    else
      qDebug() << "No Media in request_handler.";
    pb_playback_req_completed( PlaybackObject, Req );
  } // request_handler( enum pb_state_e, pb_req_t* )
  void Playback::state_hint( const int AllowedStates[] )
  {
    if( Media )
    {
      if( Media->state() != Phonon::PlayingState && AllowedStates[ PB_STATE_PLAY ] )
	pb_playback_req_state( PlaybackObject, PB_STATE_PLAY, state_reply_callback, this );
    }
    qDebug() << "State hint: Play:" << ( AllowedStates[ PB_STATE_PLAY ] ? "Yes" : "No" ) << "Stop:" << ( AllowedStates[ PB_STATE_STOP ] ? "Yes" : "No" );
  } // state_hint( const int[] )
  void Playback::state_reply( enum pb_state_e State, const char* Reason, pb_req_t* Req )
  {
    QString StateStr = "UNKNOWN";
    if( Media )
    {
      switch( State )
      {
      case PB_STATE_PLAY:
	Media->play();
	StateStr = "PLAY";
	break;
      case PB_STATE_STOP:
	Media->pause();
	StateStr = "STOP";
	break;
      default:
	break;
      }
    }
    else
      StateStr = "No Media";
    qDebug() << "State reply:" << StateStr << ( Reason ? Reason : "OK" ); 
    pb_playback_req_completed( PlaybackObject, Req ); // discarded( PB, Req, "It's just a test." );
  } // state_reply( enum pb_state_e, const char*, pb_req_t* )
#if 0
  void Playback::play( Phonon::MediaObject* NewMedia )
  {
    Media = NewMedia;
    if( PlaybackObject )
      if( !pb_playback_req_state( PlaybackObject, PB_STATE_PLAY, state_reply, this ) )
	qDebug() << "Can't send play request!";
  } // play( Phonon::MediaObject* )
  void Playback::stop( Phonon::MediaObject* NewMedia )
  {
    Media = NewMedia;
    if( PlaybackObject )
      if( !pb_playback_req_state( PlaybackObject, PB_STATE_STOP, state_reply, this ) )
	qDebug() << "Can't send stop request!";
  } // stop( Phonon::MediaObject* )
#endif
} // Timeshop
