#ifndef TIMESHOP_MAIN_HPP
#define TIMESHOP_MAIN_HPP
#include <QSettings>
#include <timeshop.hpp>
#if !defined( WINCE ) && !defined( Q_WS_HILDON )
#define TIMESHOP_DESKTOP
#endif

class Timer : public Timeshop::AlarmTimerWidget
{
  Q_OBJECT
public:
  typedef Timeshop::AlarmTimerWidget Super;
  class Loader : public Super::Loader
  {
  public:
    static const char Tag[];
    Loader( const char* Tag0 = Tag ) : Super::Loader( Tag0 ) {}
    Timeshop::Persistent* create_object( QXmlStreamReader& Stream, Timeshop::Work* Root, Timeshop::Persistent::ID ObjectID = -1 ) const
    {
      Timer* Result = 0;
      if( Root )
	if( Timeshop::TimerSettings* Settings = find_settings( Stream, Root ) )
	{
	  Result = new Timer( *Root, *Settings, 0, ObjectID );
	  Root->add_timer( *Result );
	}
      return Result;
    } // create_object( QXmlStreamReader&, Timeshop::Work*, Timeshop::Persistent::ID ) const
  }; // Loader
  //  static QString tr( const char* Text ) { return QApplication::translate( "Timer", Text ); }

  Timer( Timeshop::Work& Master0, Timeshop::TimerSettings& Settings0, QWidget* Parent = 0, Timeshop::Persistent::ID ObjectID = -1 );
  const char* loader_tag() const { return Loader::Tag; }
  void update_settings();
  void save_settings();
  void show_marks( bool Show = true );
  void show_presets( bool Show = true );
#ifdef TIMESHOP_DESKTOP
  struct WindowMode{ enum { Normal, Frameless, OSD }; };
public slots:
  void change_mode( QAction* Act );
  void normal_mode();
  void frameless_mode( bool Frameless = true );
  void osd_mode();
  void show_frame( bool Show = true );
  void stay_on_top( bool Stay = true );
  void change_opacity( QAction* Act );
  void opacity( qreal NewOpacity );
protected:
  void enterEvent( QEvent* Event );
  void leaveEvent( QEvent* Event );
#endif // TIMESHOP_DESKTOP
  void closeEvent( QCloseEvent* Event );
#ifdef TIMESHOP_DESKTOP
  bool has_options() const { return true; }
  bool load_element( QXmlStreamReader& Stream, Timeshop::Work* Root = 0 );
#if 0 //! \todo Read/write menu. Or maybe not?
  void write_attributes( QXmlStreamWriter& Stream ) const;
#endif
  void write_elements( QXmlStreamWriter& Stream ) const;
  void write_options( QXmlStreamWriter& Stream ) const;
#endif // TIMESHOP_DESKTOP
  QAction* ShowMarksAction;
  QAction* ShowPresetsAction;
#ifdef TIMESHOP_DESKTOP
  QAction* FramelessAction;
  QAction* OSDAction;
  QAction* OnTopAction;
  QList<QAction*> OpacityActions;
  char Mode;
  qreal Opacity; // Opacity
#endif // TIMESHOP_DESKTOP
}; // Timer

class Work : public Timeshop::Work
{
Q_OBJECT
public:
  typedef Timeshop::Work Super;
  Work();
  ~Work();
  bool autosave() const { return Autosave; }
  void autosave( bool NewAutosave ) { Autosave = NewAutosave; }
  void load_from_config();
  void create_default_layout( bool Show = true );
  void save_to_stream();
protected:
  bool load_element( QXmlStreamReader& Stream, Timeshop::Work* Root = 0 );
  bool Autosave;
  QString LayoutFileName;
}; // Work
#endif // TIMESHOP_MAIN_HPP
